/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;

public class BLabel
extends BWidget {
    public static final Property text = BLabel.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property image = BLabel.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property font = BLabel.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property foreground = BLabel.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property background = BLabel.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property halign = BLabel.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BLabel.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property textToIconAlign = BLabel.newProperty((int)0, (BValue)BAlign.right, null);
    public static final Property textIconGap = BLabel.newProperty((int)0, (int)4, null);
    public static final Property blink = BLabel.newProperty((int)0, (boolean)false, null);
    public static final Property wordWrapEnabled = BLabel.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BLabel == null ? (class$javax$baja$ui$BLabel = BLabel.class$("javax.baja.ui.BLabel")) : class$javax$baja$ui$BLabel));
    private static final BIcon icon = BIcon.std((String)"widgets/label.png");
    private static final BIcon imageIcon = BIcon.std((String)"widgets/image.png");
    BInsets padding = BInsets.NULL;
    Layout layout = this.createLayout();
    boolean forceLayout;
    int blinkFrame = 2;
    static /* synthetic */ Class class$javax$baja$ui$BLabel;

    public String getText() {
        return this.getString(text);
    }

    public void setText(String string) {
        this.setString(text, string, null);
    }

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage bImage) {
        this.set(image, (BValue)bImage, null);
    }

    public BFont getFont() {
        return (BFont)this.get(font);
    }

    public void setFont(BFont bFont) {
        this.set(font, (BValue)bFont, null);
    }

    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    public void setForeground(BBrush bBrush) {
        this.set(foreground, (BValue)bBrush, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush bBrush) {
        this.set(background, (BValue)bBrush, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign bHalign) {
        this.set(halign, (BValue)bHalign, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign bValign) {
        this.set(valign, (BValue)bValign, null);
    }

    public BAlign getTextToIconAlign() {
        return (BAlign)this.get(textToIconAlign);
    }

    public void setTextToIconAlign(BAlign bAlign) {
        this.set(textToIconAlign, (BValue)bAlign, null);
    }

    public double getTextIconGap() {
        return this.getDouble(textIconGap);
    }

    public void setTextIconGap(double d) {
        this.setDouble(textIconGap, d, null);
    }

    public boolean getBlink() {
        return this.getBoolean(blink);
    }

    public void setBlink(boolean bl) {
        this.setBoolean(blink, bl, null);
    }

    public boolean getWordWrapEnabled() {
        return this.getBoolean(wordWrapEnabled);
    }

    public void setWordWrapEnabled(boolean bl) {
        this.setBoolean(wordWrapEnabled, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLabel(BImage bImage, String string) {
        if (bImage != null) {
            this.setImage(bImage);
        }
        this.setText(string);
    }

    public BLabel(String string) {
        this.setText(string);
    }

    public BLabel(BImage bImage) {
        if (bImage != null) {
            this.setImage(bImage);
        }
    }

    public BLabel(String string, BHalign bHalign) {
        this.setText(string);
        this.setHalign(bHalign);
    }

    public BLabel(String string, BValign bValign) {
        this.setText(string);
        this.setValign(bValign);
    }

    public BLabel(String string, BFont bFont) {
        this.setText(string);
        this.setFont(bFont);
    }

    public BLabel(BImage bImage, String string, BFont bFont) {
        if (bImage != null) {
            this.setImage(bImage);
        }
        this.setText(string);
        this.setFont(bFont);
    }

    public BLabel(BImage bImage, BHalign bHalign) {
        if (bImage != null) {
            this.setImage(bImage);
        }
        this.setHalign(bHalign);
    }

    public BLabel(BImage bImage, BValign bValign) {
        if (bImage != null) {
            this.setImage(bImage);
        }
        this.setValign(bValign);
    }

    public BLabel(String string, BFont bFont, BHalign bHalign) {
        this.setText(string);
        this.setFont(bFont);
        this.setHalign(bHalign);
    }

    public BLabel() {
    }

    public void setWordWrapEnabled(boolean bl, double d) {
        this.setWordWrapEnabled(bl);
        this.setSize(d, this.getHeight());
    }

    public void computePreferredSize() {
        Layout layout = this.createLayout();
        layout.computeBounds();
        BInsets bInsets = this.getPadding();
        layout.aw += bInsets.left + bInsets.right;
        layout.ah += bInsets.top + bInsets.bottom;
        this.setPreferredSize(layout.aw, layout.ah);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.forceLayout = false;
        double d = this.getWidth();
        double d2 = this.getHeight();
        BInsets bInsets = this.getPadding();
        this.layout.lines = null;
        this.layout.computeBounds();
        this.layout.computeAlignment(d -= bInsets.left + bInsets.right, d2 -= bInsets.top + bInsets.bottom);
        this.layout.xo += bInsets.left;
        this.layout.yo += bInsets.top;
    }

    public void changed(Property property, Context context) {
        if (property.equals(text)) {
            this.forceLayout = true;
            this.relayout();
        } else if (property.equals(styleClasses)) {
            this.setImage(Theme.label().getIcon(this));
        }
        super.changed(property, context);
    }

    public BInsets getPadding() {
        return this.padding;
    }

    public void setPadding(BInsets bInsets) {
        this.padding = bInsets;
    }

    public void paint(Graphics graphics) {
        String string;
        if (this.getBlink() && this.blinkFrame <= 1) {
            return;
        }
        if (this.forceLayout) {
            this.forceLayout = false;
            this.relayoutSync();
        }
        LabelTheme labelTheme = this.theme();
        Layout layout = this.layout;
        double d = layout.tx;
        double d2 = layout.ty;
        double d3 = layout.tw;
        double d4 = layout.th;
        double d5 = layout.ix;
        double d6 = layout.iy;
        double d7 = layout.xo;
        double d8 = layout.yo;
        BFont bFont = this.getFont();
        if (bFont.isNull()) {
            bFont = this.theme().getTextFont(this);
        }
        BBrush bBrush = this.getBackground();
        this.paintBackground(graphics, bBrush);
        BImage bImage = labelTheme.getIcon(this);
        if (this.layout.ipaint && !bImage.isNull()) {
            if (!this.isEnabled()) {
                bImage = bImage.getDisabledImage();
            }
            this.paintIcon(graphics, bImage, d5 + d7, d6 + d8);
        }
        if ((string = this.getText()).length() > 0 && layout.lines != null) {
            BBrush bBrush2 = this.getForeground();
            if (bBrush2.isNull()) {
                bBrush2 = labelTheme.getTextBrush(this);
            }
            graphics.setBrush(bBrush2);
            graphics.setFont(bFont);
            BHalign bHalign = this.getHalign();
            for (int i = 0; i < layout.lines.length; ++i) {
                double d9 = 0.0;
                if (bHalign == BHalign.center) {
                    d9 = (d3 - layout.widths[i]) / 2.0;
                } else if (bHalign == BHalign.right) {
                    d9 = d3 - layout.widths[i];
                }
                if (this.isEnabled()) {
                    this.paintText(graphics, layout.lines[i], d + d7 + d9, d2 + d8 + (double)i * layout.lineHeight);
                    continue;
                }
                labelTheme.paintDisabledText(graphics, this, layout.lines[i], d + d7 + d9, d2 + d8 + (double)i * layout.lineHeight);
            }
        }
    }

    protected void paintIcon(Graphics graphics, BImage bImage, double d, double d2) {
        graphics.drawImage(bImage, d, d2);
    }

    protected void paintBackground(Graphics graphics, BBrush bBrush) {
        if (!bBrush.isNull() && !(this instanceof BAbstractButton)) {
            graphics.setBrush(bBrush);
            graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintText(Graphics graphics, String string, double d, double d2) {
        graphics.drawString(string, d, d2);
    }

    public void animate() {
        BImage bImage = this.getImage();
        if (!bImage.isNull()) {
            if (!this.layout.iloaded && bImage.isLoaded()) {
                this.layout.iloaded = true;
                this.relayout();
            }
            if (bImage.animate()) {
                this.repaint();
            }
        }
        if (this.getBlink()) {
            this.blinkFrame = (this.blinkFrame + 1) % 8;
            if (this.blinkFrame == 0 || this.blinkFrame == 2) {
                this.repaint();
            }
        }
    }

    public String getStyleSelector() {
        return "label";
    }

    LabelTheme theme() {
        return Theme.label();
    }

    public BIcon getIcon() {
        return this.getImage().isNull() ? icon : imageIcon;
    }

    public boolean receiveInputEvents() {
        return this.hasBindings();
    }

    public String getDebugString() {
        return "\"" + this.getText() + "\"; ";
    }

    protected Layout createLayout() {
        return new Layout();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Layout {
        boolean valid;
        double tx;
        double ty;
        double tw;
        double th;
        double ix;
        double iy;
        double iw;
        double ih;
        double aw;
        double ah;
        double xo = 0.0;
        double yo = 0.0;
        boolean ipaint;
        boolean iloaded;
        double lineHeight;
        String[] lines = null;
        double[] widths = null;
        public static final String SOFT_DELIM = " \t";
        public static final String HARD_DELIM = "\n\r\f";
        public static final String ALL_DELIM = " \t\n\r\f";

        Layout() {
        }

        void computeAlignment(double d, double d2) {
            switch (BLabel.this.getHalign().getOrdinal()) {
                case 0: {
                    this.xo = 0.0;
                    break;
                }
                case 1: {
                    this.xo = (d - this.aw) / 2.0;
                    break;
                }
                case 2: {
                    this.xo = d - this.aw;
                    break;
                }
                case 3: {
                    this.xo = (d - this.aw) / 2.0;
                }
            }
            switch (BLabel.this.getValign().getOrdinal()) {
                case 0: {
                    this.yo = 0.0;
                    break;
                }
                case 1: {
                    this.yo = (d2 - this.ah) / 2.0;
                    break;
                }
                case 2: {
                    this.yo = d2 - this.ah;
                    break;
                }
                case 3: {
                    this.yo = (d2 - this.ah) / 2.0;
                }
            }
        }

        void computeBounds() {
            this.computeImageBounds();
            this.computeTextBounds();
            if (this.tw > 0.0 && this.iw > 0.0) {
                this.computeCompoundLayout();
            } else {
                this.aw = Math.max(this.tw, this.iw);
                this.ah = Math.max(this.th, this.ih);
            }
        }

        private void computeTextBounds() {
            BFont bFont = BLabel.this.getFont();
            if (bFont.isNull()) {
                bFont = BLabel.this.theme().getTextFont(BLabel.this);
            }
            double d = bFont.getHeight();
            double d2 = bFont.getDescent();
            this.lineHeight = d;
            String string = BLabel.this.getText();
            if (string.length() == 0) {
                this.tw = 0.0;
                this.th = 0.0;
                return;
            }
            if (this.lines == null) {
                this.parse();
                this.widths = new double[this.lines.length];
            }
            this.tx = 0.0;
            this.ty = d - d2;
            this.tw = 0.0;
            this.th = this.lineHeight * (double)this.lines.length;
            for (int i = 0; i < this.lines.length; ++i) {
                this.widths[i] = bFont.width(this.lines[i]);
                this.tw = Math.max(this.tw, this.widths[i]);
            }
        }

        private void computeImageBounds() {
            BImage bImage = BLabel.this.getImage();
            this.iy = 0.0;
            this.ix = 0.0;
            if (bImage.isNull() || !bImage.isLoaded()) {
                this.ipaint = false;
                this.iloaded = false;
            } else {
                this.ipaint = true;
                this.iloaded = true;
                this.iw = bImage.getWidth();
                this.ih = bImage.getHeight();
            }
        }

        private void computeCompoundLayout() {
            double d = BLabel.this.getTextIconGap();
            this.aw = Math.max(this.tw, this.iw);
            this.ah = Math.max(this.th, this.ih);
            switch (BLabel.this.getTextToIconAlign().getOrdinal()) {
                case 0: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = this.th + d;
                    this.ah = this.th + d + this.ih;
                    break;
                }
                case 2: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.ty += this.ih + d;
                    this.ah = this.th + d + this.ih;
                    break;
                }
                case 1: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.ix = this.tw + d;
                    this.aw = this.tw + d + this.iw;
                    break;
                }
                case 3: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.tx += this.iw + d;
                    this.aw = this.tw + d + this.iw;
                    break;
                }
                case 4: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ty += (this.ah - this.th) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                }
            }
        }

        protected void parse() {
            BFont bFont = BLabel.this.getFont();
            if (bFont.isNull()) {
                bFont = BLabel.this.theme().getTextFont(BLabel.this);
            }
            double d = BLabel.this.getWidth();
            boolean bl = false;
            if (this.iw > 0.0) {
                d = d - BLabel.this.getTextIconGap() - this.iw;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = BLabel.this.getWordWrapEnabled() ? new StringTokenizer(BLabel.this.getText(), ALL_DELIM, true) : new StringTokenizer(BLabel.this.getText(), HARD_DELIM, true);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (BLabel.this.getWordWrapEnabled() && this.isSoftDelim(string)) {
                    stringBuffer2.append(string);
                    continue;
                }
                if (this.isHardDelim(string)) {
                    if (bl) continue;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer2.setLength(0);
                    stringBuffer.setLength(0);
                    continue;
                }
                double d2 = bFont.width(stringBuffer.toString() + stringBuffer2 + string);
                if (d > 0.0 && d2 > d) {
                    bl = true;
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    if (bFont.width(string) > d) {
                        arrayList.add(string);
                    } else if (string.length() > 0) {
                        stringBuffer.append(string);
                    }
                } else {
                    bl = false;
                    stringBuffer.append(stringBuffer2).append(string);
                }
                stringBuffer2.setLength(0);
            }
            if (stringBuffer.length() > 0) {
                arrayList.add(stringBuffer.toString());
            }
            this.lines = arrayList.toArray(new String[0]);
        }

        private boolean isSoftDelim(String string) {
            return SOFT_DELIM.indexOf(string) >= 0;
        }

        private boolean isHardDelim(String string) {
            return HARD_DELIM.indexOf(string) >= 0;
        }

        void dump() {
            System.out.println("  text:  " + this.tx + "," + this.ty + "," + this.tw + "," + this.th);
            System.out.println("  image: " + this.ix + "," + this.iy + "," + this.iw + "," + this.ih);
            System.out.println("  aggr:  " + this.aw + "," + this.ah);
            System.out.println("  off:   " + this.xo + "," + this.yo);
        }
    }
}

