/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

public class BDropDown
extends BWidget {
    public static final Property displayWidget = BDropDown.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property dropDownWidget = BDropDown.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property dropDownEnabled = BDropDown.newProperty((int)0, (boolean)true, null);
    public static final Action openDropDown = BDropDown.newAction((int)0, null);
    public static final Action closeDropDown = BDropDown.newAction((int)0, null);
    public static final Topic valueModified = BDropDown.newTopic((int)0, null);
    public static final Topic actionPerformed = BDropDown.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BDropDown == null ? (class$javax$baja$ui$BDropDown = BDropDown.class$("javax.baja.ui.BDropDown")) : class$javax$baja$ui$BDropDown));
    private static final BIcon icon = BIcon.std((String)"widgets/comboBox.png");
    private RectGeom buttonBounds = new RectGeom();
    static /* synthetic */ Class class$javax$baja$ui$BDropDown;

    public BWidget getDisplayWidget() {
        return (BWidget)this.get(displayWidget);
    }

    public void setDisplayWidget(BWidget bWidget) {
        this.set(displayWidget, (BValue)bWidget, null);
    }

    public BWidget getDropDownWidget() {
        return (BWidget)this.get(dropDownWidget);
    }

    public void setDropDownWidget(BWidget bWidget) {
        this.set(dropDownWidget, (BValue)bWidget, null);
    }

    public boolean getDropDownEnabled() {
        return this.getBoolean(dropDownEnabled);
    }

    public void setDropDownEnabled(boolean bl) {
        this.setBoolean(dropDownEnabled, bl, null);
    }

    public void openDropDown() {
        this.invoke(openDropDown, null, null);
    }

    public void closeDropDown() {
        this.invoke(closeDropDown, null, null);
    }

    public void fireValueModified(BWidgetEvent bWidgetEvent) {
        this.fire(valueModified, (BValue)bWidgetEvent, null);
    }

    public void fireActionPerformed(BWidgetEvent bWidgetEvent) {
        this.fire(actionPerformed, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDropDown(BWidget bWidget, BWidget bWidget2) {
        this.setDisplayWidget(bWidget);
        this.setDropDownWidget(bWidget2);
    }

    public BDropDown() {
    }

    public void changed(Property property, Context context) {
        if (property == dropDownEnabled) {
            BWidget bWidget = this.getDropDownWidget();
            if (bWidget != null && !bWidget.isNull()) {
                StyleUtils.toggleStyleClass(bWidget, "readonly", !this.getBoolean(dropDownEnabled));
            }
            if ((bWidget = this.getDisplayWidget()) != null && !bWidget.isNull()) {
                StyleUtils.toggleStyleClass(bWidget, "readonly", !this.getBoolean(dropDownEnabled));
            }
        }
        this.relayout();
    }

    public void computePreferredSize() {
        BWidget bWidget = this.getDisplayWidget();
        bWidget.computePreferredSize();
        double d = bWidget.getPreferredWidth();
        double d2 = bWidget.getPreferredHeight();
        BInsets bInsets = this.getBorderInsets();
        d += bInsets.left + bInsets.right;
        d2 += bInsets.top + bInsets.bottom;
        if (this.getDropDownEnabled()) {
            d += d2;
        }
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        BWidget bWidget = this.getDisplayWidget();
        bWidget.computePreferredSize();
        BInsets bInsets = this.getBorderInsets();
        if (this.getDropDownEnabled()) {
            d = Math.min(d3 - bInsets.top - bInsets.right, bWidget.getPreferredHeight());
            this.buttonBounds.width = Math.min(d, 16.0);
            this.buttonBounds.height = d3 - bInsets.top - bInsets.right;
            this.buttonBounds.x = d2 - bInsets.right - this.buttonBounds.width;
            this.buttonBounds.y = bInsets.top;
        } else {
            this.buttonBounds.x = 0.0;
            this.buttonBounds.y = 0.0;
            this.buttonBounds.width = 0.0;
            this.buttonBounds.height = 0.0;
        }
        d = d2 - bInsets.left - bInsets.right - this.buttonBounds.width;
        double d4 = d3 - bInsets.top - bInsets.bottom;
        bWidget.setBounds(bInsets.left, bInsets.right, d, d4);
        if (!this.isDropDownOpen()) {
            BWidget bWidget2 = this.getDropDownWidget();
            bWidget2.setBounds(0.0, d3, 0.0, 0.0);
        }
    }

    public BInsets getBorderInsets() {
        return Theme.dropDown().getBorderInsets();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getDisplayWidget().setEnabled(bl);
        this.setDropDownEnabled(bl);
    }

    public void paint(Graphics graphics) {
        this.paintChild(graphics, this.getDisplayWidget());
        this.paintBorder(graphics);
        if (this.getDropDownEnabled()) {
            this.paintButton(graphics);
        }
    }

    void paintBorder(Graphics graphics) {
        Theme.dropDown().paintBorder(graphics, this);
    }

    void paintButton(Graphics graphics) {
        Theme.dropDown().paintButton(graphics, this, this.buttonBounds, this.isDropDownOpen());
    }

    public String getStyleSelector() {
        return "drop-down";
    }

    public boolean isDropDownOpen() {
        return UiEnv.get().isPopupOpen(this.getDropDownWidget());
    }

    public void doCloseDropDown() {
        UiEnv.get().closePopup(null);
        this.repaint();
    }

    public void doOpenDropDown() {
        if (!this.getDropDownEnabled()) {
            return;
        }
        if (this.isDropDownOpen()) {
            return;
        }
        BWidget bWidget = this.getDropDownWidget();
        int n = -1;
        bWidget.computePreferredSize();
        double d = Math.max(this.getWidth(), bWidget.getPreferredWidth());
        double d2 = bWidget.getPreferredHeight();
        if (d2 > 300.0) {
            n = 308;
        }
        UiEnv.get().openPopup(bWidget, this, 0.0, this.getHeight(), d, n);
        this.repaint();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.openDropDown();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

