/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.parser.Parser;
import com.tridium.ui.theme.Theme;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBorder
extends BSimple {
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int DOTTED = 2;
    public static final int DASHED = 3;
    public static final int GROOVE = 4;
    public static final int RIDGE = 5;
    public static final int INSET = 6;
    public static final int OUTSET = 7;
    public static final BBorder none = BBorder.make(0);
    public static final BBorder solid = BBorder.make(1);
    public static final BBorder dotted = BBorder.make(2);
    public static final BBorder dashed = BBorder.make(3);
    public static final BBorder groove = BBorder.make(4);
    public static final BBorder ridge = BBorder.make(5);
    public static final BBorder inset = BBorder.make(6);
    public static final BBorder outset = BBorder.make(7);
    public static final BBorder DEFAULT = BBorder.make(1.0, 1, BColor.black.toBrush());
    public static final BBorder NULL = BBorder.make(0.0, 0, BBrush.NULL);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BBorder == null ? (class$javax$baja$ui$BBorder = BBorder.class$("javax.baja.ui.BBorder")) : class$javax$baja$ui$BBorder));
    private static final BBrush shadow = Theme.widget().getControlShadow();
    private static final BBrush hlight = Theme.widget().getControlHighlight();
    private static final int cap = 102;
    private static final int join = 203;
    private static final double[] _dotted = new double[]{2.0, 2.0};
    private static final double[] _dashed = new double[]{8.0, 2.0};
    private static final BPen solidPen = BPen.make((double)1.0, (int)102, (int)203, null);
    private static final BPen dottedPen = BPen.make((double)1.0, (int)102, (int)203, (double[])_dotted);
    private static final BPen dashedPen = BPen.make((double)1.0, (int)102, (int)203, (double[])_dashed);
    public final double topWidth;
    public final double leftWidth;
    public final double bottomWidth;
    public final double rightWidth;
    public final int topStyle;
    public final int leftStyle;
    public final int bottomStyle;
    public final int rightStyle;
    public final BBrush topBrush;
    public final BBrush leftBrush;
    public final BBrush bottomBrush;
    public final BBrush rightBrush;
    static /* synthetic */ Class class$javax$baja$ui$BBorder;

    public static BBorder make(int n) {
        return BBorder.make(1.0, n, BColor.black.toBrush());
    }

    public static BBorder make(BBorder bBorder, BBrush bBrush) {
        return BBorder.make(bBorder.topWidth, bBorder.topStyle, bBrush, bBorder.rightWidth, bBorder.rightStyle, bBrush, bBorder.bottomWidth, bBorder.bottomStyle, bBrush, bBorder.leftWidth, bBorder.leftStyle, bBrush);
    }

    public static BBorder make(double d, int n, BBrush bBrush) {
        return new BBorder(d, n, bBrush, d, n, bBrush, d, n, bBrush, d, n, bBrush);
    }

    public static BBorder make(double d, int n, BBrush bBrush, double d2, int n2, BBrush bBrush2, double d3, int n3, BBrush bBrush3, double d4, int n4, BBrush bBrush4) {
        return new BBorder(d, n, bBrush, d2, n2, bBrush2, d3, n3, bBrush3, d4, n4, bBrush4);
    }

    public static BBorder make(String string) {
        if (string.equals("null")) {
            return NULL;
        }
        Parser parser = new Parser(string);
        Side side = new Side();
        Side side2 = new Side();
        Side side3 = new Side();
        Side side4 = new Side();
        boolean bl = false;
        for (int i = 0; i < 4 && parser.cur.type == 18; ++i) {
            if (parser.cur.str.equals("top")) {
                parser.match(18);
                side = BBorder.parseSide(parser);
                parser.match(8);
                bl = true;
                continue;
            }
            if (parser.cur.str.equals("right")) {
                parser.match(18);
                side2 = BBorder.parseSide(parser);
                parser.match(8);
                bl = true;
                continue;
            }
            if (parser.cur.str.equals("bottom")) {
                parser.match(18);
                side3 = BBorder.parseSide(parser);
                parser.match(8);
                bl = true;
                continue;
            }
            if (!parser.cur.str.equals("left")) continue;
            parser.match(18);
            side4 = BBorder.parseSide(parser);
            parser.match(8);
            bl = true;
        }
        if (!bl) {
            Side side5 = BBorder.parseSide(parser);
            return BBorder.make(side5.width, side5.style, side5.brush);
        }
        return new BBorder(side.width, side.style, side.brush, side2.width, side2.style, side2.brush, side3.width, side3.style, side3.brush, side4.width, side4.style, side4.brush);
    }

    private static Side parseSide(Parser parser) {
        Side side = new Side();
        side.width = -1.0;
        side.style = -1;
        side.brush = null;
        for (int i = 0; i < 3; ++i) {
            if (side.width == -1.0) {
                side.width = BBorder.parseWidth(parser);
            }
            if (side.style == -1) {
                side.style = BBorder.parseStyle(parser);
            }
            if (side.brush != null) continue;
            side.brush = BBorder.parseBrush(parser);
        }
        if (side.width == -1.0) {
            side.width = 1.0;
        }
        if (side.style == -1) {
            side.style = 1;
        }
        if (side.brush == null) {
            side.brush = BColor.black.toBrush();
        }
        return side;
    }

    private static double parseWidth(Parser parser) {
        if (parser.cur.type == 19) {
            return parser.matchNum();
        }
        return -1.0;
    }

    private static int parseStyle(Parser parser) {
        if (parser.cur.type == 15) {
            String string = parser.cur.str;
            if (string.equals("none")) {
                parser.consume();
                return 0;
            }
            if (string.equals("solid")) {
                parser.consume();
                return 1;
            }
            if (string.equals("dotted")) {
                parser.consume();
                return 2;
            }
            if (string.equals("dashed")) {
                parser.consume();
                return 3;
            }
            if (string.equals("groove")) {
                parser.consume();
                return 4;
            }
            if (string.equals("ridge")) {
                parser.consume();
                return 5;
            }
            if (string.equals("inset")) {
                parser.consume();
                return 6;
            }
            if (string.equals("outset")) {
                parser.consume();
                return 7;
            }
        }
        return -1;
    }

    private static BBrush parseBrush(Parser parser) {
        if (parser.cur.type == 15 || parser.cur.type == 17 || parser.cur.type == 18) {
            return parser.parseBrush();
        }
        return null;
    }

    private BBorder(double d, int n, BBrush bBrush, double d2, int n2, BBrush bBrush2, double d3, int n3, BBrush bBrush3, double d4, int n4, BBrush bBrush4) {
        this.topWidth = this.w(n, d);
        this.topStyle = n;
        this.topBrush = bBrush;
        this.rightWidth = this.w(n2, d2);
        this.rightStyle = n2;
        this.rightBrush = bBrush2;
        this.bottomWidth = this.w(n3, d3);
        this.bottomStyle = n3;
        this.bottomBrush = bBrush3;
        this.leftWidth = this.w(n4, d4);
        this.leftStyle = n4;
        this.leftBrush = bBrush4;
    }

    private double w(int n, double d) {
        if (n == 0) {
            return 0.0;
        }
        if (n == 6 || n == 7) {
            return 1.0;
        }
        if (n == 4 || n == 5) {
            return 2.0;
        }
        return d;
    }

    public void paint(Graphics graphics, double d, double d2, double d3, double d4) {
        this.paint(graphics, d, d2, d3, d4, -1.0, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        graphics.push();
        try {
            double d7 = d - 1.0;
            double d8 = d2 - 1.0;
            double d9 = d + d3;
            double d10 = d2 + d4;
            if (this.adjust(this.leftStyle, this.leftWidth)) {
                d7 += this.leftWidth / 2.0;
            }
            if (this.adjust(this.topStyle, this.topWidth)) {
                d8 += this.topWidth / 2.0;
            }
            if (this.adjust(this.rightStyle, this.rightWidth)) {
                d9 -= this.rightWidth / 2.0 - 1.0;
            }
            if (this.adjust(this.bottomStyle, this.bottomWidth)) {
                d10 -= this.bottomWidth / 2.0 - 1.0;
            }
            if (this.leftStyle == 4 || this.leftStyle == 5) {
                d7 += 1.0;
            }
            if (this.topStyle == 4 || this.topStyle == 5) {
                d8 += 1.0;
            }
            if (this.rightStyle == 4 || this.rightStyle == 5) {
                d9 -= 1.0;
            }
            if (this.bottomStyle == 4 || this.bottomStyle == 5) {
                d10 -= 1.0;
            }
            this.paintTop(graphics, d7, d8, d9, d10, d5, d6);
            this.paintLeft(graphics, d7, d8, d9, d10);
            this.paintBottom(graphics, d7, d8, d9, d10);
            this.paintRight(graphics, d7, d8, d9, d10);
        }
        finally {
            graphics.pop();
        }
    }

    private boolean adjust(int n, double d) {
        boolean bl = n == 1 || n == 2 || n == 3;
        boolean bl2 = d > 1.0;
        return bl & bl2;
    }

    private void paintTop(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        if (d5 < 0.0) {
            this.helper(graphics, d, d2, d3, d4);
        } else {
            this.helper(graphics, d, d2, d5 - 2.0, d4);
            this.helper(graphics, d5 + d6 + 1.0, d2, d3, d4);
        }
    }

    private void helper(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = this.topStyle;
        if (n == 0) {
            return;
        }
        if (n == 4 || n == 5) {
            graphics.setPen(solidPen);
            graphics.setBrush(n == 4 ? shadow : hlight);
            graphics.strokeLine(d, d2 - 1.0, d3, d2 - 1.0);
            graphics.setBrush(n == 4 ? hlight : shadow);
            graphics.strokeLine(d + 1.0, d2, d3, d2);
        } else {
            if (n == 6) {
                graphics.setPen(solidPen);
                graphics.setBrush(shadow);
            } else if (n == 7) {
                graphics.setPen(solidPen);
                graphics.setBrush(hlight);
            } else {
                if (n == 1) {
                    graphics.setPen(this.makePen(this.topWidth, 1));
                }
                if (n == 2) {
                    graphics.setPen(this.makePen(this.topWidth, 2));
                }
                if (n == 3) {
                    graphics.setPen(this.makePen(this.topWidth, 3));
                }
                graphics.setBrush(this.topBrush);
            }
            graphics.strokeLine(d, d2, d3, d2);
        }
    }

    private void paintLeft(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = this.leftStyle;
        if (n == 0) {
            return;
        }
        if (n == 4 || n == 5) {
            graphics.setPen(solidPen);
            graphics.setBrush(n == 4 ? shadow : hlight);
            graphics.strokeLine(d - 1.0, d2 - 1.0, d - 1.0, d4);
            graphics.setBrush(n == 4 ? hlight : shadow);
            graphics.strokeLine(d, d2, d, d4);
        } else {
            if (n == 6) {
                graphics.setPen(solidPen);
                graphics.setBrush(shadow);
            } else if (n == 7) {
                graphics.setPen(solidPen);
                graphics.setBrush(hlight);
            } else {
                if (n == 1) {
                    graphics.setPen(this.makePen(this.leftWidth, 1));
                }
                if (n == 2) {
                    graphics.setPen(this.makePen(this.leftWidth, 2));
                }
                if (n == 3) {
                    graphics.setPen(this.makePen(this.leftWidth, 3));
                }
                graphics.setBrush(this.leftBrush);
            }
            graphics.strokeLine(d, d2, d, d4);
        }
    }

    private void paintBottom(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = this.bottomStyle;
        if (n == 0) {
            return;
        }
        if (n == 4 || n == 5) {
            graphics.setPen(solidPen);
            graphics.setBrush(n == 4 ? shadow : hlight);
            graphics.strokeLine(d, d4, d3, d4);
            graphics.setBrush(n == 4 ? hlight : shadow);
            graphics.strokeLine(d, d4 + 1.0, d3, d4 + 1.0);
        } else {
            if (n == 6) {
                graphics.setPen(solidPen);
                graphics.setBrush(hlight);
                d += 1.0;
            } else if (n == 7) {
                graphics.setPen(solidPen);
                graphics.setBrush(shadow);
            } else {
                if (n == 1) {
                    graphics.setPen(this.makePen(this.bottomWidth, 1));
                }
                if (n == 2) {
                    graphics.setPen(this.makePen(this.bottomWidth, 2));
                }
                if (n == 3) {
                    graphics.setPen(this.makePen(this.bottomWidth, 3));
                }
                graphics.setBrush(this.bottomBrush);
            }
            graphics.strokeLine(d, d4, d3, d4);
        }
    }

    private void paintRight(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = this.rightStyle;
        if (n == 0) {
            return;
        }
        if (n == 4 || n == 5) {
            graphics.setPen(solidPen);
            graphics.setBrush(n == 4 ? shadow : hlight);
            graphics.strokeLine(d3, d2, d3, d4);
            graphics.setBrush(n == 4 ? hlight : shadow);
            graphics.strokeLine(d3 + 1.0, d2 - 1.0, d3 + 1.0, d4 + 1.0);
        } else {
            if (n == 6) {
                graphics.setPen(solidPen);
                graphics.setBrush(hlight);
                d2 += 1.0;
            } else if (n == 7) {
                graphics.setPen(solidPen);
                graphics.setBrush(shadow);
            } else {
                if (n == 1) {
                    graphics.setPen(this.makePen(this.rightWidth, 1));
                }
                if (n == 2) {
                    graphics.setPen(this.makePen(this.rightWidth, 2));
                }
                if (n == 3) {
                    graphics.setPen(this.makePen(this.rightWidth, 3));
                }
                graphics.setBrush(this.rightBrush);
            }
            graphics.strokeLine(d3, d2, d3, d4);
        }
    }

    private BPen makePen(double d, int n) {
        switch (n) {
            case 1: {
                if (d == 1.0) {
                    return solidPen;
                }
                return BPen.make((double)d, (int)102, (int)203, null);
            }
            case 2: {
                if (d == 1.0) {
                    return dottedPen;
                }
                return BPen.make((double)d, (int)102, (int)203, (double[])_dotted);
            }
            case 3: {
                if (d == 1.0) {
                    return dashedPen;
                }
                return BPen.make((double)d, (int)102, (int)203, (double[])_dashed);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isNull() {
        return this == NULL || this.equals((Object)NULL);
    }

    public int hashCode() {
        long l = 23L + Double.doubleToRawLongBits(this.topWidth);
        l = l * 37L + (long)this.topStyle;
        l = l * 37L + (long)this.topBrush.hashCode();
        l = l * 37L + Double.doubleToRawLongBits(this.leftWidth);
        l = l * 37L + (long)this.leftStyle;
        l = l * 37L + (long)this.leftBrush.hashCode();
        l = l * 37L + Double.doubleToRawLongBits(this.bottomWidth);
        l = l * 37L + (long)this.bottomStyle;
        l = l * 37L + (long)this.bottomBrush.hashCode();
        l = l * 37L + Double.doubleToRawLongBits(this.rightWidth);
        l = l * 37L + (long)this.rightStyle;
        l = l * 37L + (long)this.rightBrush.hashCode();
        return (int)(l >>> 32) ^ (int)l;
    }

    public boolean equals(Object object) {
        if (object instanceof BBorder) {
            BBorder bBorder = (BBorder)((Object)object);
            return this.topWidth == bBorder.topWidth && this.topStyle == bBorder.topStyle && this.topBrush.equals((Object)bBorder.topBrush) && this.leftWidth == bBorder.leftWidth && this.leftStyle == bBorder.leftStyle && this.leftBrush.equals((Object)bBorder.leftBrush) && this.bottomWidth == bBorder.bottomWidth && this.bottomStyle == bBorder.bottomStyle && this.bottomBrush.equals((Object)bBorder.bottomBrush) && this.rightWidth == bBorder.rightWidth && this.rightStyle == bBorder.rightStyle && this.rightBrush.equals((Object)bBorder.rightBrush);
        }
        return false;
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        if (this.topWidth == this.rightWidth && this.topWidth == this.bottomWidth && this.topWidth == this.leftWidth && this.topStyle == this.rightStyle && this.topStyle == this.bottomStyle && this.topStyle == this.leftStyle && this.topBrush.equals((Object)this.rightBrush) && this.topBrush.equals((Object)this.bottomBrush) && this.topBrush.equals((Object)this.leftBrush)) {
            return this.encodeSide(this.topWidth, this.topStyle, this.topBrush);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.topStyle != 0) {
            stringBuffer.append("top(");
            stringBuffer.append(this.encodeSide(this.topWidth, this.topStyle, this.topBrush));
            stringBuffer.append(") ");
        }
        if (this.rightStyle != 0) {
            stringBuffer.append("right(");
            stringBuffer.append(this.encodeSide(this.rightWidth, this.rightStyle, this.rightBrush));
            stringBuffer.append(") ");
        }
        if (this.bottomStyle != 0) {
            stringBuffer.append("bottom(");
            stringBuffer.append(this.encodeSide(this.bottomWidth, this.bottomStyle, this.bottomBrush));
            stringBuffer.append(") ");
        }
        if (this.leftStyle != 0) {
            stringBuffer.append("left(");
            stringBuffer.append(this.encodeSide(this.leftWidth, this.leftStyle, this.leftBrush));
            stringBuffer.append(") ");
        }
        return stringBuffer.toString().trim();
    }

    private String encodeSide(double d, int n, BBrush bBrush) throws IOException {
        if (this.isNull()) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d).append(" ");
        switch (n) {
            case 0: {
                stringBuffer.append("none");
                break;
            }
            case 1: {
                stringBuffer.append("solid");
                break;
            }
            case 2: {
                stringBuffer.append("dotted");
                break;
            }
            case 3: {
                stringBuffer.append("dashed");
                break;
            }
            case 4: {
                stringBuffer.append("groove");
                break;
            }
            case 5: {
                stringBuffer.append("ridge");
                break;
            }
            case 6: {
                stringBuffer.append("inset");
                break;
            }
            case 7: {
                stringBuffer.append("outset");
            }
        }
        stringBuffer.append(" ").append(bBrush.encodeToString());
        return stringBuffer.toString();
    }

    public BObject decodeFromString(String string) throws IOException {
        return BBorder.make(string);
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 205: {
                this.setBaseOrd(object);
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private void setBaseOrd(Object object) {
        this.topBrush.fw(205, object, null, null, null);
        this.leftBrush.fw(205, object, null, null, null);
        this.bottomBrush.fw(205, object, null, null, null);
        this.rightBrush.fw(205, object, null, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Side {
        double width = 0.0;
        int style = 0;
        BBrush brush = BBrush.NULL;

        private Side() {
        }
    }
}

