/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BKeyEvent;

public final class BAccelerator
extends BSimple {
    private static final String[] keyCodeStrings;
    public static final BAccelerator NULL;
    public static final BAccelerator DEFAULT;
    public static final Type TYPE;
    private int modifiers;
    private int keyCode;
    private String string = "null";
    static /* synthetic */ Class class$javax$baja$ui$BAccelerator;

    public static BAccelerator make(int n, int n2) {
        BAccelerator bAccelerator = new BAccelerator();
        bAccelerator.string = null;
        bAccelerator.keyCode = n;
        bAccelerator.modifiers = n2;
        return bAccelerator;
    }

    public static BAccelerator make(String string) {
        try {
            BAccelerator bAccelerator = new BAccelerator();
            bAccelerator.parse(string);
            return bAccelerator;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid accelerator \"" + string + "\"");
        }
    }

    private BAccelerator() {
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isMatch(BKeyEvent bKeyEvent) {
        return this.keyCode == bKeyEvent.getKeyCode() && (this.modifiers ^ bKeyEvent.getModifiers()) == 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public String getModifiersString() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.modifiers & 2) != 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((this.modifiers & 1) != 0) {
            stringBuffer.append("Shift+");
        }
        if ((this.modifiers & 8) != 0) {
            stringBuffer.append("Alt+");
        }
        if ((this.modifiers & 4) != 0) {
            stringBuffer.append("Meta+");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String getKeyCodeString() {
        String string = null;
        if (this.keyCode > 0 && this.keyCode < keyCodeStrings.length) {
            string = keyCodeStrings[this.keyCode];
        }
        if (string != null) {
            return string;
        }
        throw new IllegalArgumentException("Invalid key code: " + this.keyCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String string) {
        this.string = string;
        StringTokenizer stringTokenizer = new StringTokenizer(TextUtil.toLowerCase((String)string), "+");
        block17: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            int n = string2.length();
            if (n == 1) {
                if ('a' <= c && c <= 'z') {
                    this.keyCode = 65 + (c - 97);
                } else if ('0' <= c && c <= '9') {
                    this.keyCode = 48 + (c - 48);
                } else {
                    if (c != '/') throw new RuntimeException();
                    this.keyCode = 47;
                }
            } else {
                char c2 = string2.charAt(1);
                switch (c) {
                    case 'a': {
                        if (!string2.equals("alt")) break;
                        this.modifiers |= 8;
                        continue block17;
                    }
                    case 'b': {
                        if (!string2.equals("backspace")) break;
                        this.keyCode = 8;
                        continue block17;
                    }
                    case 'c': {
                        if (!string2.equals("ctrl")) break;
                        this.modifiers |= 2;
                        continue block17;
                    }
                    case 'd': {
                        if (string2.equals("down")) {
                            this.keyCode = 40;
                            break;
                        }
                        if (!string2.equals("delete")) break;
                        this.keyCode = 127;
                        break;
                    }
                    case 'e': {
                        if (string2.equals("end")) {
                            this.keyCode = 35;
                            break;
                        }
                        if (!string2.equals("esc")) break;
                        this.keyCode = 27;
                        break;
                    }
                    case 'f': {
                        if (n == 2 && '1' <= c2 && c2 <= '9') {
                            this.keyCode = 112 + (c2 - 49);
                            break;
                        }
                        if (string2.equals("f10")) {
                            this.keyCode = 121;
                            break;
                        }
                        if (string2.equals("f11")) {
                            this.keyCode = 122;
                            break;
                        }
                        if (!string2.equals("f12")) break;
                        this.keyCode = 123;
                        break;
                    }
                    case 'h': {
                        if (!string2.equals("home")) break;
                        this.keyCode = 36;
                        break;
                    }
                    case 'i': {
                        if (!string2.equals("insert")) break;
                        this.keyCode = 155;
                        break;
                    }
                    case 'l': {
                        if (!string2.equals("left")) break;
                        this.keyCode = 37;
                        break;
                    }
                    case 'm': {
                        if (!string2.equals("meta")) break;
                        this.modifiers |= 4;
                        continue block17;
                    }
                    case 'p': {
                        if (string2.equals("pageup")) {
                            this.keyCode = 33;
                            break;
                        }
                        if (!string2.equals("pagedown")) break;
                        this.keyCode = 34;
                        break;
                    }
                    case 'r': {
                        if (!string2.equals("right")) break;
                        this.keyCode = 39;
                        break;
                    }
                    case 's': {
                        if (string2.equals("shift")) {
                            this.modifiers |= 1;
                            continue block17;
                        }
                        if (!string2.equals("space")) break;
                        this.keyCode = 32;
                        break;
                    }
                    case 't': {
                        if (!string2.equals("tab")) break;
                        this.keyCode = 9;
                        break;
                    }
                    case 'u': {
                        if (!string2.equals("up")) break;
                        this.keyCode = 38;
                    }
                }
            }
            if (!stringTokenizer.hasMoreTokens()) break;
            throw new RuntimeException();
        }
        if (this.keyCode != 0) return;
        throw new RuntimeException();
    }

    public int hashCode() {
        return this.keyCode ^ ~this.modifiers;
    }

    public boolean equals(Object object) {
        if (object instanceof BAccelerator) {
            BAccelerator bAccelerator = (BAccelerator)((Object)object);
            return this.keyCode == bAccelerator.keyCode && this.modifiers == bAccelerator.modifiers;
        }
        return false;
    }

    public String toString(Context context) {
        return this.encodeToString();
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public String encodeToString() {
        if (this.string == null) {
            this.string = this.modifiers == 0 ? this.getKeyCodeString() : this.getModifiersString() + '+' + this.getKeyCodeString();
        }
        return this.string;
    }

    public BObject decodeFromString(String string) throws IOException {
        try {
            if (string.equals("null")) {
                return NULL;
            }
            return BAccelerator.make(string);
        }
        catch (Exception exception) {
            throw new IOException("Invalid accelerator: " + string);
        }
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        keyCodeStrings = new String[255];
        for (n = 65; n <= 90; ++n) {
            BAccelerator.keyCodeStrings[n] = String.valueOf((char)(65 + n - 65));
        }
        for (n = 48; n <= 57; ++n) {
            BAccelerator.keyCodeStrings[n] = String.valueOf((char)(48 + n - 48));
        }
        for (n = 112; n <= 123; ++n) {
            BAccelerator.keyCodeStrings[n] = "F" + (n - 112 + 1);
        }
        BAccelerator.keyCodeStrings[47] = "/";
        BAccelerator.keyCodeStrings[38] = "Up";
        BAccelerator.keyCodeStrings[40] = "Down";
        BAccelerator.keyCodeStrings[37] = "Left";
        BAccelerator.keyCodeStrings[39] = "Right";
        BAccelerator.keyCodeStrings[36] = "Home";
        BAccelerator.keyCodeStrings[35] = "End";
        BAccelerator.keyCodeStrings[155] = "Insert";
        BAccelerator.keyCodeStrings[127] = "Delete";
        BAccelerator.keyCodeStrings[33] = "PageUp";
        BAccelerator.keyCodeStrings[34] = "PageDown";
        BAccelerator.keyCodeStrings[8] = "Backspace";
        BAccelerator.keyCodeStrings[9] = "Tab";
        BAccelerator.keyCodeStrings[32] = "Space";
        DEFAULT = NULL = new BAccelerator();
        TYPE = Sys.loadType((Class)(class$javax$baja$ui$BAccelerator == null ? (class$javax$baja$ui$BAccelerator = BAccelerator.class$("javax.baja.ui.BAccelerator")) : class$javax$baja$ui$BAccelerator));
    }
}

