/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.AbstractButtonTheme;
import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

public abstract class BAbstractButton
extends BLabel
implements BMenu.MenuCloseListener {
    public static final Property focusTraversable = BAbstractButton.newProperty((int)0, (boolean)true, null);
    public static final Property buttonStyle = BAbstractButton.newProperty((int)0, (BValue)BButtonStyle.normal, null);
    public static final Action invokeAction = BAbstractButton.newAction((int)0, null);
    public static final Topic actionPerformed = BAbstractButton.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BAbstractButton == null ? (class$javax$baja$ui$BAbstractButton = BAbstractButton.class$("javax.baja.ui.BAbstractButton")) : class$javax$baja$ui$BAbstractButton));
    private boolean mouseOver = false;
    private boolean pressed = false;
    private boolean menuPressed = false;
    Command command;
    MenuController menuController;
    static /* synthetic */ Class class$javax$baja$ui$BAbstractButton;

    public boolean getFocusTraversable() {
        return this.getBoolean(focusTraversable);
    }

    public void setFocusTraversable(boolean bl) {
        this.setBoolean(focusTraversable, bl, null);
    }

    public BButtonStyle getButtonStyle() {
        return (BButtonStyle)this.get(buttonStyle);
    }

    public void setButtonStyle(BButtonStyle bButtonStyle) {
        this.set(buttonStyle, (BValue)bButtonStyle, null);
    }

    public void invokeAction() {
        this.invoke(invokeAction, null, null);
    }

    public void fireActionPerformed(BWidgetEvent bWidgetEvent) {
        this.fire(actionPerformed, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BAbstractButton make(Command command, boolean bl, boolean bl2) {
        if (command instanceof ToggleCommand) {
            return new BToggleButton((ToggleCommand)command, bl, bl2);
        }
        return new BButton(command, bl, bl2);
    }

    public static BAbstractButton make(Command command) {
        return BAbstractButton.make(command, true, true);
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isMenuPressed() {
        return this.menuPressed;
    }

    public IPoint getLabelOffset() {
        if (this.getButtonStyle() == BButtonStyle.hyperlink) {
            return new Point(0.0, 0.0);
        }
        return this.buttonTheme().getLabelOffset(this);
    }

    public double getMenuWidth() {
        if (this.getButtonStyle() == BButtonStyle.hyperlink) {
            return 0.0;
        }
        return this.buttonTheme().getMenuWidth();
    }

    public BInsets getPadding() {
        if (this.padding.isNull()) {
            if (this.getButtonStyle() == BButtonStyle.hyperlink) {
                return super.getPadding();
            }
            IInsets iInsets = this.buttonTheme().getPadding(this);
            return BInsets.make((IInsets)iInsets);
        }
        return this.padding;
    }

    public void paintBackground(Graphics graphics) {
        if (this.getButtonStyle() != BButtonStyle.none && this.getButtonStyle() != BButtonStyle.hyperlink) {
            this.buttonTheme().paintBackground(graphics, this);
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command, boolean bl, boolean bl2) {
        if (this.command != null) {
            this.command.unregister(this);
        }
        if (command == null) {
            return;
        }
        if (bl && command.getLabel() != null) {
            this.setText(command.getLabel());
        }
        if (bl2 && command.getIcon() != null) {
            this.setImage(command.getIcon());
        }
        if (command.getKeyBase() != null) {
            this.setStyleId(command.getKeyBase().replace('.', '-'));
            this.setImage(Theme.button().getIcon(this));
        }
        this.command = command;
        command.register(this);
    }

    public MenuController getMenuController() {
        return this.menuController;
    }

    public void setMenuController(MenuController menuController) {
        this.menuController = menuController;
        this.relayout();
    }

    public void openMenu() {
        BMenu bMenu;
        if (this.menuController != null && (bMenu = this.menuController.getMenu(this)) != null) {
            this.openMenu(bMenu);
        }
    }

    public void openMenu(BMenu bMenu) {
        bMenu.open(this, 0.0, this.getHeight());
    }

    public void menuClosed(BMenu bMenu) {
        this.menuPressed = false;
        this.repaint();
    }

    public final void doInvokeAction() {
        this.doInvokeAction(null);
    }

    public void doInvokeAction(CommandEvent commandEvent) {
        this.fireActionPerformed(new BWidgetEvent(2, this));
        this.repaint();
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double d = this.getPreferredWidth();
        double d2 = this.getPreferredHeight();
        if (this.menuController != null) {
            d += this.getMenuWidth();
        }
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.forceLayout = false;
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (this.menuController != null) {
            d -= this.getMenuWidth();
        }
        BInsets bInsets = this.getPadding();
        this.layout.lines = null;
        this.layout.computeBounds();
        this.layout.computeAlignment(d -= bInsets.left() + bInsets.right(), d2 -= bInsets.top() + bInsets.bottom());
        this.layout.xo += bInsets.left();
        this.layout.yo += bInsets.top();
    }

    public void changed(Property property, Context context) {
        if (property == buttonStyle) {
            if (this.get(property) == BButtonStyle.toolBar) {
                StyleUtils.addStyleClass(this, "toolbar");
                StyleUtils.removeStyleClass(this, "hyperlink");
            } else if (this.get(property) == BButtonStyle.hyperlink) {
                StyleUtils.addStyleClass(this, "hyperlink");
                StyleUtils.removeStyleClass(this, "toolbar");
            } else {
                StyleUtils.removeStyleClass(this, "toolbar");
                StyleUtils.removeStyleClass(this, "hyperlink");
            }
        }
        super.changed(property, context);
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        IPoint iPoint = this.getLabelOffset();
        graphics.translate(iPoint.x(), iPoint.y());
        super.paint(graphics);
    }

    public String getStyleSelector() {
        if (this.getButtonStyle() == BButtonStyle.hyperlink) {
            return "label";
        }
        return "button";
    }

    public boolean isFocusTraversable() {
        return this.getFocusTraversable();
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getKeyCode() == 32) {
            bKeyEvent.consume();
            this.doInvokeAction(new CommandEvent(bKeyEvent));
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.menuController != null && (!this.menuController.isMenuDistinct() || bMouseEvent.getX() > this.getWidth() - this.getMenuWidth())) {
            this.menuPressed = true;
            this.repaint();
            this.openMenu();
            return;
        }
        this.pressed = true;
        StyleUtils.addStyleClass(this, "pressed");
        this.repaint();
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.mouseOver && !this.menuPressed) {
            this.doInvokeAction(new CommandEvent(bMouseEvent));
        }
        this.pressed = false;
        StyleUtils.removeStyleClass(this, "pressed");
        this.repaint();
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        String string = this.getToolTip();
        if (bWidgetShell != null && string != null) {
            bWidgetShell.showStatus(string);
        }
        if (bWidgetShell != null && this.getButtonStyle() == BButtonStyle.hyperlink) {
            this.setMouseCursor(MouseCursor.hand);
        }
        this.mouseOver = true;
        StyleUtils.addStyleClass(this, "hover");
        this.repaint();
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        UiEnv.get().closeBubbleHelp();
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            bWidgetShell.showStatus(null);
        }
        if (bWidgetShell != null && this.getButtonStyle() == BButtonStyle.hyperlink) {
            this.setMouseCursor(MouseCursor.normal);
        }
        this.mouseOver = false;
        StyleUtils.removeStyleClass(this, "hover");
        this.repaint();
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        String string;
        if (this.getButtonStyle() == BButtonStyle.toolBar && this.command != null && (string = this.command.getLabel()) != null && string.length() > 0) {
            double d = bMouseEvent.getX();
            double d2 = bMouseEvent.getY();
            d2 = Math.max(this.getHeight() + 1.0, d2 + 16.0);
            UiEnv.get().openBubbleHelp(this, d, d2, string);
        }
    }

    private String getToolTip() {
        String string;
        if (this.command != null) {
            string = this.command.getLabel();
            String string2 = this.command.getDescription();
            if (string != null && string.length() > 0) {
                if (string.endsWith("...")) {
                    string = string.substring(0, string.length() - 3);
                }
                if (string.endsWith("..")) {
                    string = string.substring(0, string.length() - 2);
                }
                if (string2 != null && string2.length() > 0) {
                    return string + ": " + string2;
                }
                return string;
            }
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
        }
        if ((string = this.getText()) != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    LabelTheme theme() {
        return this.buttonTheme();
    }

    abstract AbstractButtonTheme buttonTheme();

    public String getDebugString() {
        return "\"" + this.getText() + "\"; ";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface MenuController {
        public boolean isMenuDistinct();

        public BMenu getMenu(BAbstractButton var1);
    }
}

