/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step;

import com.tridium.ui.wizard.step.BWizardButtonMode;
import com.tridium.ui.wizard.step.CannotCancelException;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import java.util.ListIterator;
import javax.baja.nre.util.Array;
import javax.baja.sys.Context;
import javax.baja.util.CannotValidateException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WizardStep {
    public static final NullCommitLog nullCommitLog = new NullCommitLog();
    private Array validators;
    private Array commits;
    private IUiHandler uiHandler;
    private IRouter router;
    private IRouter endRouter;
    private IRouter lastEndRouter;
    private BWizardButtonMode overrideMode;
    private boolean runOnce;
    private boolean forceFinishStep;
    private ICommitLog commitLog;
    static /* synthetic */ Class class$com$tridium$ui$wizard$step$WizardStep$IValidator;
    static /* synthetic */ Class class$com$tridium$ui$wizard$step$WizardStep$ICommit;

    public final void addValidator(IValidator iValidator) {
        this.validators.add((Object)iValidator);
    }

    public final void remoteValidator(IValidator iValidator) {
        this.validators.remove((Object)iValidator);
    }

    public final IValidator[] getValidators() {
        return (IValidator[])this.validators.trim();
    }

    public final void addCommit(ICommit iCommit) {
        this.commits.add((Object)iCommit);
    }

    public final void removeCommit(ICommit iCommit) {
        this.commits.remove((Object)iCommit);
    }

    public final ICommit[] getCommits() {
        return (ICommit[])this.commits.trim();
    }

    public final void setUiHandler(IUiHandler iUiHandler) {
        this.uiHandler = iUiHandler;
    }

    public final IUiHandler getUiHandler() {
        return this.uiHandler;
    }

    public final void setRouter(IRouter iRouter) {
        this.router = iRouter;
    }

    public final IRouter getRouter() {
        return this.router;
    }

    public final void validate(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) throws CannotValidateException {
        ListIterator listIterator = this.validators.iterator();
        while (listIterator.hasNext()) {
            IValidator iValidator = (IValidator)listIterator.next();
            iValidator.validate(stepArtifact, stepModel, iWizardView, context);
        }
    }

    public final void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) throws CannotCommitException {
        ListIterator listIterator = this.commits.iterator();
        while (listIterator.hasNext()) {
            ICommit iCommit = (ICommit)listIterator.next();
            iCommit.commit(stepArtifact, stepModel, iWizardView, this.commitLog, context);
        }
    }

    public void setCommitLog(ICommitLog iCommitLog) {
        this.commitLog = iCommitLog;
    }

    public final WizardStep next(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        WizardStep wizardStep = null;
        if (this.router != null) {
            wizardStep = this.router.next(stepArtifact, stepModel, iWizardView, context);
            while (wizardStep != null && wizardStep.skipStep(stepArtifact, stepModel, iWizardView, context)) {
                wizardStep = wizardStep.next(stepArtifact, stepModel, iWizardView, context);
            }
        }
        if (wizardStep == null && this.lastEndRouter != null) {
            wizardStep = this.lastEndRouter.next(stepArtifact, stepModel, iWizardView, context);
            while (wizardStep != null && wizardStep.skipStep(stepArtifact, stepModel, iWizardView, context)) {
                wizardStep = wizardStep.next(stepArtifact, stepModel, iWizardView, context);
            }
            if (wizardStep != null && wizardStep.getEndRouter() == null) {
                wizardStep.lastEndRouter = null;
            }
        } else if (wizardStep != null && wizardStep.getEndRouter() == null) {
            wizardStep.lastEndRouter = this.lastEndRouter;
        }
        return wizardStep;
    }

    public final WizardStep setNext(WizardStep wizardStep) {
        this.router = DefaultRouter.make(wizardStep);
        return wizardStep;
    }

    public void setEndRouter(IRouter iRouter) {
        this.endRouter = iRouter;
        this.lastEndRouter = iRouter;
    }

    public IRouter getEndRouter() {
        return this.endRouter;
    }

    public final WizardStep setEnd(WizardStep wizardStep) {
        this.setEndRouter(DefaultRouter.make(wizardStep));
        return wizardStep;
    }

    public final StepArtifact create(StepModel stepModel, IWizardView iWizardView, Context context) {
        if (this.uiHandler != null) {
            return this.uiHandler.create(this, stepModel, iWizardView, context);
        }
        return null;
    }

    public final void detach(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        if (this.uiHandler != null) {
            this.uiHandler.detach(stepArtifact, stepModel, iWizardView, context);
        }
    }

    public final StepArtifact updateStepArtifact(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        if (this.uiHandler != null) {
            return this.uiHandler.updateStepArtifact(stepArtifact, stepModel, iWizardView, context);
        }
        return null;
    }

    public final boolean restoreFromNext(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        if (this.uiHandler != null) {
            return this.uiHandler.restoreFromNext(stepArtifact, stepModel, iWizardView, context);
        }
        return false;
    }

    public final boolean restoreFromBack(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        if (this.uiHandler != null) {
            return this.uiHandler.restoreFromBack(stepArtifact, stepModel, iWizardView, context);
        }
        return false;
    }

    public void setOverrideMode(BWizardButtonMode bWizardButtonMode) {
        this.overrideMode = bWizardButtonMode;
    }

    public void clearOverrideMode() {
        this.overrideMode = null;
    }

    public BWizardButtonMode getOverrideMode() {
        return this.overrideMode;
    }

    public BWizardButtonMode getWizardButtonMode(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        WizardStep wizardStep;
        if (this.overrideMode != null) {
            return this.overrideMode;
        }
        BWizardButtonMode bWizardButtonMode = BWizardButtonMode.cancel;
        if (stepModel.isFinished()) {
            return bWizardButtonMode;
        }
        if (stepModel.getStepArtifactHistory().isBackward() && !(wizardStep = stepModel.getStepArtifactHistory().peekBackward().getStep()).isRunOnce() && !this.isRunOnce()) {
            bWizardButtonMode = bWizardButtonMode.merge(BWizardButtonMode.back);
        }
        bWizardButtonMode = this.next(stepArtifact, stepModel, iWizardView, context) != null && !this.isForceFinishStep() ? bWizardButtonMode.merge(BWizardButtonMode.next) : bWizardButtonMode.merge(BWizardButtonMode.finish);
        return bWizardButtonMode;
    }

    public void setRunOnce(boolean bl) {
        this.runOnce = bl;
    }

    public boolean isRunOnce() {
        return this.runOnce;
    }

    public void setForceFinishStep(boolean bl) {
        this.forceFinishStep = bl;
    }

    public boolean isForceFinishStep() {
        return this.forceFinishStep;
    }

    public void back(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
    }

    public void cancel(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) throws CannotCancelException {
    }

    public boolean skipStep(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$ui$wizard$step$WizardStep$IValidator;
        if (clazz == null) {
            clazz = class$com$tridium$ui$wizard$step$WizardStep$IValidator = WizardStep.class("[Lcom.tridium.ui.wizard.step.WizardStep$IValidator;", false);
        }
        this.validators = new Array(clazz, 1);
        Class clazz2 = class$com$tridium$ui$wizard$step$WizardStep$ICommit;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$ui$wizard$step$WizardStep$ICommit = WizardStep.class("[Lcom.tridium.ui.wizard.step.WizardStep$ICommit;", false);
        }
        this.commits = new Array(clazz2, 1);
        this.overrideMode = null;
        this.runOnce = false;
        this.forceFinishStep = false;
        this.commitLog = nullCommitLog;
    }

    public WizardStep() {
        this.this();
    }

    public WizardStep(IUiHandler iUiHandler) {
        this.this();
        this.setUiHandler(iUiHandler);
    }

    public static interface IValidator {
        public void validate(StepArtifact var1, StepModel var2, IWizardView var3, Context var4) throws CannotValidateException;
    }

    public static interface ICommit {
        public void commit(StepArtifact var1, StepModel var2, IWizardView var3, ICommitLog var4, Context var5) throws CannotCommitException;
    }

    public static interface IRouter {
        public WizardStep next(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);
    }

    public static final class DefaultRouter
    implements IRouter {
        private WizardStep next;

        public static final DefaultRouter make(WizardStep wizardStep) {
            return new DefaultRouter(wizardStep);
        }

        public final WizardStep next(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
            return this.next;
        }

        public DefaultRouter(WizardStep wizardStep) {
            this.next = wizardStep;
        }
    }

    public static interface IUiHandler {
        public StepArtifact create(WizardStep var1, StepModel var2, IWizardView var3, Context var4);

        public void detach(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);

        public StepArtifact updateStepArtifact(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);

        public boolean restoreFromNext(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);

        public boolean restoreFromBack(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);
    }

    private static final class NullCommitLog
    implements ICommitLog {
        public final void log(String string) {
        }

        private NullCommitLog() {
        }
    }
}

