/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step;

import com.tridium.ui.wizard.step.BWizardButtonMode;
import com.tridium.ui.wizard.step.CannotCancelException;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepArtifactHistory;
import com.tridium.ui.wizard.step.WizardStep;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StepModel {
    private StepArtifactHistory stepHistory;
    private WizardStep currentStep;
    private WizardStep firstStep;
    private volatile boolean finished;

    public static final StepModel make(WizardStep wizardStep) {
        return new StepModel(wizardStep);
    }

    public final void init(IWizardView iWizardView) {
        if (this.finished) {
            return;
        }
        this.stepHistory.clear();
        this.currentStep = null;
        this.loadNextStep(this.firstStep, iWizardView, iWizardView.getWizardContext());
    }

    public final void deactivated(IWizardView iWizardView) {
        if (this.currentStep != null) {
            this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext()));
            this.currentStep.detach(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext());
        }
    }

    public final void back(IWizardView iWizardView) {
        if (!this.finished && this.currentStep != null) {
            this.loadBackStep(iWizardView, iWizardView.getWizardContext());
        }
    }

    public final void next(IWizardView iWizardView) {
        if (!this.finished && this.currentStep != null) {
            this.loadNextStep(this.currentStep.next(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext()), iWizardView, iWizardView.getWizardContext());
        }
    }

    public final boolean finish(IWizardView iWizardView) {
        if (!this.finished && this.currentStep != null) {
            if (this.hasNext(iWizardView)) {
                this.next(iWizardView);
            } else {
                try {
                    this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext()));
                    this.currentStep.validate(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext());
                    this.currentStep.commit(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext());
                    this.setFinished();
                }
                catch (Exception exception) {
                    iWizardView.handleError(exception);
                }
                this.update(iWizardView);
            }
        }
        return this.finished;
    }

    public final boolean cancel(IWizardView iWizardView) {
        if (this.currentStep != null) {
            try {
                this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext()));
                this.currentStep.cancel(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext());
                return true;
            }
            catch (CannotCancelException cannotCancelException) {
                iWizardView.handleError((Throwable)((Object)cannotCancelException));
                return false;
            }
        }
        return false;
    }

    private final void loadNextStep(WizardStep wizardStep, IWizardView iWizardView, Context context) {
        if (this.finished) {
            return;
        }
        if (wizardStep == null) {
            return;
        }
        if (this.currentStep != null) {
            this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, iWizardView, context));
            try {
                this.currentStep.validate(this.stepHistory.getCurrent(), this, iWizardView, context);
                this.currentStep.commit(this.stepHistory.getCurrent(), this, iWizardView, context);
            }
            catch (Exception exception) {
                iWizardView.handleError(exception);
                return;
            }
            this.currentStep.detach(this.stepHistory.getCurrent(), this, iWizardView, context);
        }
        this.currentStep = wizardStep;
        boolean bl = false;
        if (this.stepHistory.isForward()) {
            StepArtifact stepArtifact = this.stepHistory.forward();
            if (stepArtifact.getStep().equals(this.currentStep)) {
                bl = this.currentStep.restoreFromNext(stepArtifact, this, iWizardView, context);
            }
            if (!bl) {
                this.stepHistory.removeCurrent();
            }
        }
        if (!bl) {
            this.stepHistory.add(this.currentStep.create(this, iWizardView, context));
        }
        this.update(iWizardView);
    }

    private final void loadBackStep(IWizardView iWizardView, Context context) {
        if (this.finished) {
            return;
        }
        if (this.currentStep == null) {
            return;
        }
        if (!this.stepHistory.isBackward()) {
            return;
        }
        this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, iWizardView, context));
        this.currentStep.back(this.stepHistory.getCurrent(), this, iWizardView, context);
        this.currentStep.detach(this.stepHistory.getCurrent(), this, iWizardView, context);
        StepArtifact stepArtifact = this.stepHistory.backward();
        if (stepArtifact == null) {
            return;
        }
        this.currentStep = stepArtifact.getStep();
        if (!this.currentStep.restoreFromBack(stepArtifact, this, iWizardView, context)) {
            this.stepHistory.removeCurrent();
            this.stepHistory.add(this.currentStep.create(this, iWizardView, context));
        }
        this.update(iWizardView);
    }

    public final void update(IWizardView iWizardView) {
        if (this.currentStep != null) {
            this.update(this.currentStep.getWizardButtonMode(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext()), iWizardView);
        }
    }

    private final void update(BWizardButtonMode bWizardButtonMode, IWizardView iWizardView) {
        iWizardView.update(bWizardButtonMode);
    }

    public final StepArtifactHistory getStepArtifactHistory() {
        return this.stepHistory;
    }

    public final WizardStep getFirstStep() {
        return this.firstStep;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final void setFinished() {
        this.finished = true;
    }

    public final boolean hasNext(IWizardView iWizardView) {
        if (this.currentStep == null) {
            return false;
        }
        boolean bl = false;
        if (this.currentStep.next(this.stepHistory.getCurrent(), this, iWizardView, iWizardView.getWizardContext()) != null) {
            bl = true;
        }
        return bl;
    }

    public final WizardStep getCurrentStep() {
        return this.currentStep;
    }

    private final /* synthetic */ void this() {
        this.stepHistory = new StepArtifactHistory();
        this.finished = false;
    }

    private StepModel(WizardStep wizardStep) {
        this.this();
        this.firstStep = wizardStep;
    }
}

