/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.SliderTheme;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BSlider;
import javax.baja.ui.enums.BOrientation;

public class PalladiumSliderTheme
extends PalladiumWidgetTheme
implements SliderTheme {
    public double getFixedWidth(BSlider bSlider) {
        return 17.0;
    }

    public double getThumbWidth(BSlider bSlider) {
        return 11.0;
    }

    public void paintTrack(Graphics graphics, BSlider bSlider, RectGeom rectGeom) {
        BBrush bBrush = bSlider.getTrackBrush();
        graphics.setBrush(bBrush.isNull() ? this.getControlAuxiliary() : bBrush);
        graphics.fillRect(rectGeom.x, rectGeom.y, rectGeom.width, rectGeom.height);
        if (bSlider.getEnabled()) {
            graphics.setBrush(this.getControlForeground());
        } else {
            graphics.setBrush(this.getControlShadow());
        }
        graphics.strokeRect(rectGeom.x, rectGeom.y, rectGeom.width, rectGeom.height);
        if (bSlider.getEnabled()) {
            graphics.setBrush(this.getControlShadow());
        } else {
            graphics.setBrush(this.getControlAuxiliary());
        }
        graphics.strokeLine(rectGeom.x + 1.0, rectGeom.y + 1.0, rectGeom.x + rectGeom.width - 1.0, rectGeom.y + 1.0);
        graphics.strokeLine(rectGeom.x + 1.0, rectGeom.y + 1.0, rectGeom.x + 1.0, rectGeom.y + rectGeom.height - 1.0);
        graphics.setBrush(this.getControlBackground());
        graphics.strokeLine(rectGeom.x + (double)2, rectGeom.y + rectGeom.height - 1.0, rectGeom.x + rectGeom.width - 1.0, rectGeom.y + rectGeom.height - 1.0);
        graphics.strokeLine(rectGeom.x + rectGeom.width - 1.0, rectGeom.y + rectGeom.height - 1.0, rectGeom.x + rectGeom.width - 1.0, rectGeom.y + (double)2);
    }

    public void paintThumb(Graphics graphics, BSlider bSlider, RectGeom rectGeom) {
        if (bSlider.getOrientation() == BOrientation.horizontal) {
            this.paintThumbHoriz(graphics, bSlider, rectGeom);
        } else {
            this.paintThumbVert(graphics, bSlider, rectGeom);
        }
    }

    private final void paintThumbHoriz(Graphics graphics, BSlider bSlider, RectGeom rectGeom) {
        double d = rectGeom.x;
        double d2 = rectGeom.y;
        double d3 = rectGeom.width;
        double d4 = rectGeom.height;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d;
        dArray2[1] = d2 + d4 - 6.0;
        dArray[2] = d + (d3 - 1.0) / (double)2;
        dArray2[2] = d2 + d4 - 1.0;
        dArray[3] = d + d3 - 1.0;
        dArray2[3] = d2 + d4 - 6.0;
        dArray[4] = d + d3 - 1.0;
        dArray2[4] = d2;
        PolygonGeom polygonGeom = new PolygonGeom(dArray, dArray2, 5);
        BBrush bBrush = bSlider.getThumbBrush();
        graphics.setBrush(bBrush.isNull() ? this.getControlBackground() : bBrush);
        graphics.fill((IGeom)polygonGeom);
        if (bSlider.getEnabled()) {
            graphics.setBrush(this.getControlForeground());
        } else {
            graphics.setBrush(this.getControlShadow());
        }
        graphics.stroke((IGeom)polygonGeom);
        graphics.setBrush(this.getControlHighlight());
        graphics.strokeLine(rectGeom.x + 1.0, rectGeom.y + 1.0, rectGeom.x + rectGeom.width - (double)3, rectGeom.y + 1.0);
        graphics.strokeLine(rectGeom.x + 1.0, rectGeom.y + 1.0, rectGeom.x + 1.0, rectGeom.y + rectGeom.height - 6.0);
        if (bSlider.getEnabled()) {
            graphics.setBrush(this.getControlShadow());
        } else {
            graphics.setBrush(this.getControlAuxiliary());
        }
        graphics.strokeLine(d + d3 - (double)2, d2 + 1.0, d + d3 - (double)2, d2 + d4 - 6.0);
        graphics.strokeLine(d + (d3 - 1.0) / (double)2, d2 + d4 - (double)2, d + d3 - (double)2, d2 + d4 - 6.0);
        double d5 = d + (double)4;
        double d6 = d2 + (double)4;
        graphics.setBrush(this.getControlHighlight());
        graphics.strokeLine(d5, d6 + 1.0, d5 + (double)2, d6 + 1.0);
        graphics.strokeLine(d5, d6 + (double)5, d5 + (double)2, d6 + (double)5);
        graphics.setBrush(this.getControlShadow());
        graphics.strokeLine(d5, d6, d5, d6 + 1.0);
        graphics.strokeLine(d5, d6 + (double)4, d5, d6 + (double)5);
        graphics.strokeLine(d5, d6, d5 + (double)2, d6);
        graphics.strokeLine(d5, d6 + (double)4, d5 + (double)2, d6 + (double)4);
    }

    private final void paintThumbVert(Graphics graphics, BSlider bSlider, RectGeom rectGeom) {
        double d = rectGeom.x;
        double d2 = rectGeom.y;
        double d3 = rectGeom.width;
        double d4 = rectGeom.height;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d + d3 - 6.0;
        dArray2[1] = d2;
        dArray[2] = d + d3 - 1.0;
        dArray2[2] = d2 + (d4 - 1.0) / (double)2;
        dArray[3] = d + d3 - 6.0;
        dArray2[3] = d2 + d4 - 1.0;
        dArray[4] = d;
        dArray2[4] = d2 + d4 - 1.0;
        PolygonGeom polygonGeom = new PolygonGeom(dArray, dArray2, 5);
        BBrush bBrush = bSlider.getThumbBrush();
        graphics.setBrush(bBrush.isNull() ? this.getControlBackground() : bBrush);
        graphics.fill((IGeom)polygonGeom);
        if (bSlider.getEnabled()) {
            graphics.setBrush(this.getControlForeground());
        } else {
            graphics.setBrush(this.getControlShadow());
        }
        graphics.stroke((IGeom)polygonGeom);
        graphics.setBrush(this.getControlHighlight());
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + d3 - 6.0, d2 + 1.0);
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + 1.0, d2 + d4 - (double)3);
        if (bSlider.getEnabled()) {
            graphics.setBrush(this.getControlShadow());
        } else {
            graphics.setBrush(this.getControlAuxiliary());
        }
        graphics.strokeLine(d + 1.0, d2 + d4 - (double)2, d + d3 - 6.0, d2 + d4 - (double)2);
        graphics.strokeLine(d + d3 - (double)2, d2 + (d4 - 1.0) / (double)2, d + d3 - 6.0, d2 + d4 - (double)2);
        double d5 = d + (double)4;
        double d6 = d2 + (double)4;
        graphics.setBrush(this.getControlHighlight());
        graphics.strokeLine(d5 + 1.0, d6, d5 + 1.0, d6 + (double)2);
        graphics.strokeLine(d5 + (double)5, d6, d5 + (double)5, d6 + (double)2);
        graphics.setBrush(this.getControlShadow());
        graphics.strokeLine(d5, d6, d5 + 1.0, d6);
        graphics.strokeLine(d5 + (double)4, d6, d5 + (double)5, d6);
        graphics.strokeLine(d5, d6, d5, d6 + (double)2);
        graphics.strokeLine(d5 + (double)4, d6, d5 + (double)4, d6 + (double)2);
    }
}

