/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.AbstractButtonTheme;
import com.tridium.ui.theme.palladium.PalladiumLabelTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.enums.BButtonStyle;

public abstract class PalladiumAbstractButtonTheme
extends PalladiumLabelTheme
implements AbstractButtonTheme {
    static Point noOffset = new Point(0.0, 0.0);
    static Point pressedOffset = new Point(1.0, 1.0);
    static BInsets normalPadding = BInsets.make((double)5, (double)13.0, (double)5, (double)13.0);
    static BInsets toolbarPadding = BInsets.make((double)3, (double)3, (double)3, (double)3);
    static double menuWidth = 11.0;

    public BFont getTextFont() {
        return this.getBoldText();
    }

    public BBrush getTextBrush(boolean bl) {
        return bl ? this.getControlForeground() : this.getControlShadow();
    }

    public IInsets getPadding(BAbstractButton bAbstractButton) {
        if (bAbstractButton.getButtonStyle() == BButtonStyle.toolBar) {
            return toolbarPadding;
        }
        return normalPadding;
    }

    public IPoint getLabelOffset(BAbstractButton bAbstractButton) {
        BAbstractButton.MenuController menuController = bAbstractButton.getMenuController();
        if (menuController != null && !menuController.isMenuDistinct() && bAbstractButton.isMenuPressed()) {
            return pressedOffset;
        }
        if (bAbstractButton.isPressed() && bAbstractButton.isMouseOver()) {
            return pressedOffset;
        }
        if (bAbstractButton instanceof BToggleButton && ((BToggleButton)bAbstractButton).isSelected()) {
            return pressedOffset;
        }
        return noOffset;
    }

    public double getMenuWidth() {
        return menuWidth;
    }

    public void paintDisabledText(Graphics graphics, String string, double d, double d2) {
        graphics.setBrush(this.getControlHighlight());
        graphics.drawString(string, d + 1.0, d2 + 1.0);
        graphics.setBrush(this.getControlShadow());
        graphics.drawString(string, d, d2);
    }

    public void paintBackground(Graphics graphics, BAbstractButton bAbstractButton) {
        boolean bl = bAbstractButton.getEnabled();
        boolean bl2 = bAbstractButton.isMouseOver();
        boolean bl3 = bAbstractButton.isPressed();
        boolean bl4 = bAbstractButton.isMenuPressed();
        boolean bl5 = false;
        if (bAbstractButton.getMenuController() != null) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (bl6) {
            bl7 = bAbstractButton.getMenuController().isMenuDistinct();
        }
        boolean bl8 = bl7;
        boolean bl9 = false;
        if (bAbstractButton instanceof BToggleButton) {
            bl9 = ((BToggleButton)bAbstractButton).isSelected();
        }
        double d = bAbstractButton.getWidth();
        double d2 = bAbstractButton.getHeight();
        double d3 = this.getMenuWidth();
        if (bl6) {
            d -= this.getMenuWidth();
        }
        boolean bl10 = true;
        boolean bl11 = true;
        if (!bl6) {
            bl8 = true;
        }
        if (!(bAbstractButton.getButtonStyle() != BButtonStyle.toolBar || bl2 && bl || bl4)) {
            bl10 = false;
            if (!bl9) {
                bl11 = false;
            }
        }
        graphics.setBrush(this.getBackground(bAbstractButton, bl3, bl9));
        graphics.fillRect(1.0, 1.0, d - (double)2, d2 - (double)2);
        if (bl10) {
            if (bl) {
                graphics.setBrush(this.getControlForeground());
            } else {
                graphics.setBrush(this.getControlShadow());
            }
            graphics.strokeRect(0.0, 0.0, !bl8 ? d - 1.0 + d3 : d - 1.0, d2 - 1.0);
            if (bl6 && bl8) {
                graphics.strokeRect(d - 1.0, 0.0, d3, d2 - 1.0);
            }
        }
        if (bl11) {
            if (bl4 && !bl8 || !bl4 && bl3 && bl2 || bl9) {
                graphics.setBrush(this.getControlShadow());
            } else {
                graphics.setBrush(this.getControlHighlight());
            }
            double d4 = d + (!bl8 ? d3 : 0.0);
            graphics.strokeLine(1.0, 1.0, d4 - (double)3, 1.0);
            graphics.strokeLine(1.0, 1.0, 1.0, d2 - (double)3);
            if (bl6 && bl8 && (bAbstractButton.getButtonStyle() != BButtonStyle.toolBar || bl3 || bl2)) {
                if (bl4) {
                    graphics.setBrush(this.getControlShadow());
                } else {
                    graphics.setBrush(this.getControlHighlight());
                }
                graphics.strokeLine(d, 1.0, d + d3 - (double)3, 1.0);
                graphics.strokeLine(d, 1.0, d, d2 - (double)3);
            }
            if (bl || bl9) {
                graphics.setBrush(this.getControlShadow());
            } else {
                graphics.setBrush(this.getControlAuxiliary());
            }
            graphics.strokeLine(d4 - (double)2, 1.0, d4 - (double)2, d2 - (double)2);
            graphics.strokeLine(1.0, d2 - (double)2, d4 - (double)2, d2 - (double)2);
            if (bl6 && bl8 && (bAbstractButton.getButtonStyle() != BButtonStyle.toolBar || bl3 || bl2)) {
                graphics.strokeLine(d + d3 - (double)2, 1.0, d + d3 - (double)2, d2 - (double)2);
                graphics.strokeLine(d, d2 - (double)2, d + d3 - (double)2, d2 - (double)2);
            }
        }
        if (bl6) {
            if (bl) {
                graphics.setBrush(this.getControlForeground());
            } else {
                graphics.setBrush(this.getControlShadow());
            }
            int n = 3;
            int n2 = (int)d + (int)this.getMenuWidth() - n - 4;
            if (!bl8 && bAbstractButton.getButtonStyle() != BButtonStyle.toolBar) {
                n2 -= 3;
            }
            int n3 = n + ((int)d2 - n) / 2 - 1;
            if (bl4) {
                n2 = (int)((double)n2 + PalladiumAbstractButtonTheme.pressedOffset.x);
                n3 = (int)((double)n3 + PalladiumAbstractButtonTheme.pressedOffset.y);
            }
            int n4 = 0;
            while (n4 < n) {
                graphics.strokeLine((double)(n2 - n4), (double)(n3 - n4), (double)(n2 + n4), (double)(n3 - n4));
                ++n4;
            }
        }
        if (bAbstractButton.hasFocus() && bAbstractButton.getButtonStyle() != BButtonStyle.toolBar) {
            this.paintFocus(graphics, new RectGeom((double)3, (double)3, d - 7.0, d2 - 7.0));
        }
        this.paintDefaultBorder(graphics, bAbstractButton, bl3);
    }

    protected BBrush getBackground(BAbstractButton bAbstractButton, boolean bl, boolean bl2) {
        return bAbstractButton.getBackground().isNull() ? this.getControlBackground() : bAbstractButton.getBackground();
    }

    protected void paintDefaultBorder(Graphics graphics, BAbstractButton bAbstractButton, boolean bl) {
    }
}

