/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss.selector;

import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSException;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.theme.custom.nss.selector.NSSPath;
import java.util.ArrayList;
import java.util.List;
import javax.baja.ui.style.IStylable;

public class NSSSelector {
    private List styleClasses;
    private String styleId;
    private String tag;
    private Object result;
    private int foundBy = -1;
    private NSSPath path;
    private static final int BY_ID = 2;
    private static final int BY_CLASS = 1;
    private static final int BY_TAG = 0;

    public NSSSelector(String string) {
        this.path = new NSSPath(string);
        this.styleClasses = this.getStyleClassList(this.path);
        this.styleId = this.getStyleId(this.path);
        this.tag = this.path.getName();
    }

    public NSSSelector(IStylable iStylable, String string, String string2) {
        this((string == null ? "" : string) + " " + string2);
        this.styleClasses = this.getStyleClassList(iStylable);
        this.styleClasses.addAll(this.getStyleClassList(this.path));
        this.styleId = iStylable.getStyleId();
        this.tag = this.path.getName();
    }

    public Object select(NSS nSS) {
        Object object = this.selectForward(nSS, this.path);
        if (object == null) {
            object = this.selectBackward(nSS, this.path.getName());
        }
        return object;
    }

    private Object selectBackward(NSS nSS, String string) {
        Object object = null;
        while (object == null && nSS != null) {
            object = this.doSelectWithClassAndId(nSS, string);
            nSS = nSS.getParent();
        }
        return object;
    }

    private Object selectForward(NSS nSS, NSSPath nSSPath) {
        if (nSS == null) {
            return this.result;
        }
        Object object = this.doSelectWithClassAndId(nSS, this.tag);
        if (object != null) {
            this.result = object;
        }
        if (nSSPath.size() == 0) {
            return this.result;
        }
        Object v = nSS.get(nSSPath.getHead());
        if (v instanceof NSS) {
            nSSPath = nSSPath.removeHead();
            return this.selectForward((NSS)v, nSSPath);
        }
        return this.result;
    }

    public NSS selectNode(NSS nSS) {
        Object object = this.select(nSS);
        if (object instanceof NSS) {
            return (NSS)object;
        }
        return nSS;
    }

    public Object selectProperty(NSS nSS) {
        Object object = this.select(nSS);
        return this.convertToProperty(object);
    }

    private Object convertToProperty(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof NSS) {
            throw new NSSException("NSS selector '" + this.path + "' references " + "an NSS node, not a property.");
        }
        return object;
    }

    private Object doSelectStrict(NSS nSS, NSSPath nSSPath) {
        Object object = this.doSelectWithClassAndId(nSS, nSSPath.getHead());
        if (nSSPath.size() == 0) {
            return object;
        }
        if (object instanceof NSS) {
            nSSPath = nSSPath.removeHead();
            return this.doSelectStrict((NSS)object, nSSPath);
        }
        return null;
    }

    public Object selectStrict(NSS nSS) {
        return this.doSelectStrict(nSS, this.path);
    }

    private List getStyleClassList(IStylable iStylable) {
        List list = StyleUtils.toStyleClassList(iStylable.getStyleClasses());
        list.addAll(StyleUtils.getAutoClasses(iStylable));
        return list;
    }

    private List getStyleClassList(NSSPath nSSPath) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nSSPath.size(); ++i) {
            String string = nSSPath.get(i);
            if (string.charAt(0) != '.') continue;
            arrayList.add(string.substring(1));
        }
        return arrayList;
    }

    private String getStyleId(NSSPath nSSPath) {
        for (int i = 0; i < nSSPath.size(); ++i) {
            String string = nSSPath.get(i);
            if (string.charAt(0) != '#') continue;
            return string.substring(1);
        }
        return null;
    }

    private Object doSelectWithClassAndId(NSS nSS, String string) {
        return this.getFromNode(nSS, string, true);
    }

    private Object getFromNode(NSS nSS, String string, boolean bl) {
        Object object = null;
        NSS nSS2 = this.getIdNode(nSS);
        if (nSS2 != null) {
            object = nSS2.get(string);
            this.foundBy = 2;
        }
        if (!(object != null || this.foundBy >= 2 && bl)) {
            List list = this.getClassNodes(nSS);
            for (int i = 0; i < list.size() && object == null; ++i) {
                Object object2 = this.getFromNode((NSS)list.get(i), string, false);
                if (object2 == null) continue;
                object = object2;
                this.foundBy = 1;
            }
        }
        if (!(object != null || this.foundBy >= 1 && bl)) {
            object = nSS.get(string);
            this.foundBy = 0;
        }
        return object;
    }

    private NSS getIdNode(NSS nSS) {
        Object v;
        if (this.styleId != null && (v = nSS.get("#" + this.styleId)) instanceof NSS) {
            return (NSS)v;
        }
        return null;
    }

    private List getClassNodes(NSS nSS) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.styleClasses.size(); ++i) {
            Object v = nSS.get("." + this.styleClasses.get(i));
            if (!(v instanceof NSS)) continue;
            arrayList.add(v);
        }
        return arrayList;
    }
}

