/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss;

import com.tridium.gx.GxEnv;
import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSDefaults;
import com.tridium.ui.theme.custom.nss.NSSException;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.baja.file.BIFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NSSReader {
    private Stack stack;
    private String currentTagName;
    private Object currentValue;
    private Map definitions;
    private StreamTokenizer tokenizer;
    private String token;
    private int tagNumber;
    private NSS nss;
    private NSS parentNSS;
    private boolean fontsOverridden;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSS readFromFile(BIFile bIFile) throws IOException {
        NSS nSS;
        block2: {
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader(bIFile.getInputStream());
                nSS = NSSReader.doRead(inputStreamReader);
                Object var3_3 = null;
                if (inputStreamReader == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_4 = null;
                    if (inputStreamReader == null) break block3;
                    ((Reader)inputStreamReader).close();
                }
                throw throwable;
            }
            ((Reader)inputStreamReader).close();
        }
        return nSS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSS readFromString(String string) throws IOException {
        NSS nSS;
        block2: {
            StringReader stringReader = null;
            try {
                stringReader = new StringReader(string);
                nSS = NSSReader.doRead(stringReader);
                Object var3_3 = null;
                if (stringReader == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_4 = null;
                    if (stringReader == null) break block3;
                    ((Reader)stringReader).close();
                }
                throw throwable;
            }
            ((Reader)stringReader).close();
        }
        return nSS;
    }

    private static final NSS doRead(Reader reader) throws IOException {
        NSSReader nSSReader = new NSSReader(reader);
        nSSReader.read();
        nSSReader.finish();
        NSS nSS = new NSS();
        NSSDefaults.setPalladiumDefaults(nSS);
        NSSReader.overrideNSS(nSSReader.nss, nSS);
        return nSS;
    }

    private static final void overrideNSS(NSS nSS, NSS nSS2) {
        Iterator iterator = nSS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = nSS2.get(k);
            if (v instanceof NSS && v2 instanceof NSS) {
                NSSReader.overrideNSS((NSS)v, (NSS)v2);
                continue;
            }
            nSS2.put(k, v);
        }
    }

    private final void read() throws IOException {
        NSS nSS = new NSS();
        this.stack.push(nSS);
        while ((this.token = this.getNextToken()) != null) {
            if (this.token.equals("{")) {
                this.startNewNode();
                continue;
            }
            if (this.token.equals("}")) {
                this.closeCurrentNode();
                continue;
            }
            if (this.token.equals(";")) {
                this.closeTag();
                continue;
            }
            if (this.token.equals(":")) {
                this.verifyTagStarted();
                continue;
            }
            this.handleValueToken();
        }
        if (this.parentNSS != null) {
            NSSReader.overrideNSS(nSS, this.parentNSS);
            this.nss = this.parentNSS;
        } else {
            this.nss = nSS;
        }
    }

    private final String getNextToken() throws IOException {
        if (this.tokenizer.nextToken() == -1) {
            return null;
        }
        switch (this.tokenizer.ttype) {
            case 10: {
                return "";
            }
            case -3: 
            case 34: 
            case 39: {
                return this.tokenizer.sval;
            }
        }
        return new String(new char[]{(char)this.tokenizer.ttype});
    }

    private final void startNewNode() {
        if (this.currentTagName == null) {
            throw new NSSException("unexpected symbol '{' on line " + this.tokenizer.lineno() + " (did you omit a name?)");
        }
        NSS nSS = new NSS((NSS)this.stack.peek(), this.currentTagName);
        this.addToHead(this.currentTagName, nSS);
        this.stack.push(nSS);
        this.reset();
    }

    private final void closeCurrentNode() {
        if (this.stack.size() == 1) {
            throw new NSSException("unexpected symbol '}' on line " + this.tokenizer.lineno() + " (you've tried to close  a block with '}' but missed the opening '{')");
        }
        NSS nSS = (NSS)this.stack.pop();
        if (nSS.getName().equals("font-families")) {
            this.applyFontOverrides(nSS);
        }
        this.reset();
    }

    private final void applyFontOverrides(NSS nSS) {
        if (this.fontsOverridden) {
            throw new NSSException("Duplicate font-families tag detected - only one font-families tag allowed per NSS file");
        }
        if (nSS.has("serif")) {
            NSSReader.doFontOverride("serif", (String)nSS.get("serif"));
        }
        if (nSS.has("sansserif")) {
            NSSReader.doFontOverride("sansserif", (String)nSS.get("sansserif"));
        }
        if (nSS.has("monospaced")) {
            NSSReader.doFontOverride("monospaced", (String)nSS.get("monospaced"));
        }
        if (nSS.has("dialog")) {
            NSSReader.doFontOverride("dialog", (String)nSS.get("dialog"));
        }
        if (nSS.has("dialoginput")) {
            NSSReader.doFontOverride("dialoginput", (String)nSS.get("dialoginput"));
        }
        this.fontsOverridden = true;
    }

    private static final void doFontOverride(String string, String string2) {
        GxEnv.get().overrideFontFamily(string, string2);
    }

    private final void handleValueToken() {
        if (this.token.length() > 0) {
            if (this.currentTagName == null) {
                this.startTag(this.token);
            } else {
                this.appendValue(this.token);
            }
        }
    }

    private final void startTag(String string) {
        this.currentTagName = string;
    }

    private final void appendValue(String string) {
        this.currentValue = this.currentValue instanceof String ? this.currentValue + ' ' + string : string;
    }

    private final void closeTag() {
        if (this.currentTagName == null || this.currentValue == null) {
            throw new NSSException("Unexpected symbol ';' at line " + this.tokenizer.lineno() + " (did you omit a property?)");
        }
        this.addToHead(this.currentTagName, this.currentValue);
        this.reset();
    }

    private final void verifyTagStarted() {
        if (this.currentTagName == null || this.currentValue != null) {
            throw new NSSException("Unexpected symbol ':' on line " + this.tokenizer.lineno() + ": ':' is optional but must always separate tag name and value");
        }
    }

    private final void reset() {
        this.currentTagName = null;
        this.currentValue = null;
    }

    private final void addToHead(String string, Object object) {
        ++this.tagNumber;
        NSS nSS = (NSS)this.stack.peek();
        if (object instanceof NSS) {
            this.addChildNode(nSS, string, (NSS)object);
        } else if (object instanceof String) {
            String string2 = (String)object;
            if (string.equals("#define")) {
                this.addDefinition(string2);
            } else if (string.equals("#extends")) {
                this.processExtends(string2);
            } else {
                this.addChildString(nSS, string, string2);
            }
        }
    }

    private final void addChildNode(NSS nSS, String string, NSS nSS2) {
        nSS.put(string, nSS2);
    }

    private final void addChildString(NSS nSS, String string, String string2) {
        nSS.put(string, string2);
    }

    private final void addDefinition(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f=");
        Definition definition = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (definition == null) {
                definition = new Definition(string2, this.tokenizer.lineno());
                continue;
            }
            definition.append(string2);
        }
        if (definition != null && definition.value != null) {
            this.definitions.put(definition.tagName, definition);
        }
    }

    private final boolean isDefinition(String string) {
        return string.startsWith("$");
    }

    private final Definition getDefinition(String string) {
        Definition definition = (Definition)this.definitions.get(string.substring(1));
        if (definition == null) {
            throw new NSSException("No definition available for reference '" + string + '\'');
        }
        return definition;
    }

    private final void finish() {
        this.finalizeNSS(this.nss);
    }

    private final void finalizeNSS(NSS nSS) {
        Iterator iterator = nSS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String) {
                String string2 = (String)v;
                if (this.isDefinition(string2)) {
                    Definition definition = this.getDefinition(string2);
                    try {
                        entry.setValue(NSSUtils.makeValueByTag(string, definition.value));
                        continue;
                    }
                    catch (Exception exception) {
                        throw new NSSException("Could not successfully parse defined value '" + definition.value + "' defined by '" + string2 + "' at line " + definition.lineNumber);
                    }
                }
                try {
                    entry.setValue(NSSUtils.makeValueByTag(string, string2));
                    continue;
                }
                catch (Exception exception) {
                    throw new NSSException("Could not successfully parse value '" + v + "'.");
                }
            }
            if (!(v instanceof NSS)) continue;
            this.finalizeNSS((NSS)v);
        }
    }

    /*
     * Exception decompiling
     */
    private final void processExtends(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 153->157)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final StreamTokenizer makeStreamTokenizer(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.wordChars(33, 41);
        streamTokenizer.wordChars(43, 46);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.ordinaryChar(92);
        streamTokenizer.wordChars(92, 92);
        streamTokenizer.quoteChar(39);
        streamTokenizer.quoteChar(34);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.ordinaryChar(59);
        streamTokenizer.ordinaryChar(58);
        return streamTokenizer;
    }

    private final /* synthetic */ void this() {
        this.stack = new Stack();
        this.currentTagName = null;
        this.currentValue = null;
        this.definitions = new HashMap();
        this.token = "";
        this.tagNumber = 0;
        this.fontsOverridden = false;
    }

    private NSSReader(Reader reader) {
        this.this();
        this.tokenizer = NSSReader.makeStreamTokenizer(reader);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Definition {
        String tagName;
        String value;
        int lineNumber;

        public void append(String string) {
            this.value = this.value == null ? string : this.value + ' ' + string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Definition)) {
                return false;
            }
            return this.tagName.equals(((Definition)object).tagName);
        }

        public int hashCode() {
            return this.tagName.hashCode();
        }

        public String toString() {
            return this.tagName;
        }

        public Definition(String string, int n) {
            this.tagName = string;
            this.lineNumber = n;
        }
    }
}

