/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.WidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.log.Log;
import javax.baja.ui.style.IStylable;

public class CustomWidgetTheme
implements WidgetTheme {
    static final Log logger = Log.getLog((String)"com.tridium.ui.theme.custom");
    private static NSS nss;

    String getNSSSelector() {
        return "";
    }

    public static NSS getNSS() {
        return nss;
    }

    public static void setNSS(NSS nSS) {
        nss = nSS;
    }

    Object select(String string) {
        return CustomWidgetTheme.getNSS().select(this.getNSSSelector() + ' ' + string);
    }

    Object selectStrict(String string) {
        return CustomWidgetTheme.getNSS().selectStrict(this.getNSSSelector() + ' ' + string);
    }

    Object select(IStylable iStylable, String string) {
        if (iStylable == null) {
            return this.select(string);
        }
        String string2 = iStylable.getStyleSelector();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = this.getNSSSelector();
        }
        return CustomWidgetTheme.getNSS().select(iStylable, string2, string);
    }

    Object selectStrict(IStylable iStylable, String string) {
        if (iStylable == null) {
            return this.selectStrict(string);
        }
        String string2 = iStylable.getStyleSelector();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = this.getNSSSelector();
        }
        return CustomWidgetTheme.getNSS().selectStrict(iStylable, string2, string);
    }

    public BBrush getWindowBackground() {
        BBrush bBrush = (BBrush)this.select("window-background-color");
        if (bBrush == null) {
            bBrush = (BBrush)this.select("background-color");
        }
        return bBrush;
    }

    public BBrush getWindowBackground(IStylable iStylable) {
        BBrush bBrush = (BBrush)this.selectStrict(iStylable, "background-color");
        if (bBrush == null) {
            bBrush = (BBrush)this.select(iStylable, "window-background-color");
        }
        if (bBrush == null) {
            bBrush = (BBrush)this.select(iStylable, "background-color");
        }
        return bBrush;
    }

    public BBrush getWindowForeground() {
        BBrush bBrush = (BBrush)this.select("window-color");
        if (bBrush == null) {
            bBrush = (BBrush)this.select("color");
        }
        return bBrush;
    }

    public BBrush getWindowForeground(IStylable iStylable) {
        BBrush bBrush = (BBrush)this.selectStrict(iStylable, "color");
        if (bBrush == null) {
            bBrush = (BBrush)this.select(iStylable, "window-color");
        }
        if (bBrush == null) {
            bBrush = (BBrush)this.select(iStylable, "color");
        }
        return bBrush;
    }

    public BBrush getControlBackground() {
        return (BBrush)this.select("background-color");
    }

    public BBrush getControlBackground(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "background-color");
    }

    public BBrush getControlForeground() {
        return (BBrush)this.select("outline");
    }

    public BBrush getControlForeground(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "outline");
    }

    public BBrush getControlHighlight() {
        return (BBrush)this.select("highlight");
    }

    public BBrush getControlHighlight(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "highlight");
    }

    public BBrush getControlShadow() {
        return (BBrush)this.select("shadow");
    }

    public BBrush getControlShadow(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "shadow");
    }

    public BBrush getControlAuxiliary() {
        return (BBrush)this.select("auxiliary-color");
    }

    public BBrush getControlAuxiliary(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "auxiliary-color");
    }

    public BBrush getSelectionBackground() {
        return (BBrush)this.select("selection-background-color");
    }

    public BBrush getSelectionBackground(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "selection-background-color");
    }

    public BBrush getSelectionForeground() {
        return (BBrush)this.select("selection-color");
    }

    public BBrush getSelectionForeground(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "selection-color");
    }

    public BBrush getDropOkForeground() {
        return (BBrush)this.select("drop-ok-color");
    }

    public BBrush getDropOkForeground(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "drop-ok-color");
    }

    public BBrush getDropOkBackground() {
        return (BBrush)this.select("drop-ok-background-color");
    }

    public BBrush getDropOkBackground(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "drop-ok-background-color");
    }

    public BFont getPlainText() {
        return (BFont)this.select("font");
    }

    public BFont getPlainText(IStylable iStylable) {
        return (BFont)this.select(iStylable, "font");
    }

    public BFont getBoldText() {
        return (BFont)this.select("bold-font");
    }

    public BFont getBoldText(IStylable iStylable) {
        return (BFont)this.select(iStylable, "bold-font");
    }

    public BFont getLargeFont() {
        return (BFont)this.select("large-font");
    }

    public BFont getLargeFont(IStylable iStylable) {
        return (BFont)this.select(iStylable, "large-font");
    }

    public BFont getLargeBoldFont() {
        return (BFont)this.select("large-bold-font");
    }

    public BFont getLargeBoldFont(IStylable iStylable) {
        return (BFont)this.select(iStylable, "large-bold-font");
    }

    public BFont getFixedWidthFont() {
        return (BFont)this.select("fixed-font");
    }

    public BFont getFixedWidthFont(IStylable iStylable) {
        return (BFont)this.select(iStylable, "fixed-font");
    }

    public BFont getFixedWidthBoldFont() {
        return (BFont)this.select("fixed-bold-font");
    }

    public BFont getFixedWidthBoldFont(IStylable iStylable) {
        return (BFont)this.select(iStylable, "fixed-bold-font");
    }

    public BFont getTextFont() {
        return (BFont)this.select("font");
    }

    public BFont getTextFont(IStylable iStylable) {
        return (BFont)this.select(iStylable, "font");
    }

    public BBrush getTextBrush() {
        return (BBrush)this.select("color");
    }

    public BBrush getTextBrush(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "color");
    }

    public BBrush getFocusBrush() {
        return (BBrush)this.select("focus-color");
    }

    public BBrush getFocusBrush(IStylable iStylable) {
        return (BBrush)this.select(iStylable, "focus-color");
    }

    public BBrush getTextDisabled() {
        return (BBrush)this.select(".disabled color");
    }

    public BBrush getTextDisabled(IStylable iStylable) {
        return (BBrush)this.select(iStylable, ".disabled color");
    }

    public void paintDisabledText(Graphics graphics, String string, double d, double d2) {
        this.paintDisabledText(graphics, null, string, d, d2);
    }

    public void paintDisabledText(Graphics graphics, IStylable iStylable, String string, double d, double d2) {
        graphics.setBrush(this.getTextDisabled(iStylable));
        graphics.drawString(string, d, d2);
    }

    public void paintFocus(Graphics graphics, RectGeom rectGeom) {
        graphics.setBrush(this.getFocusBrush());
        PaintUtil.drawDashedRect(graphics, (IRectGeom)rectGeom);
    }

    void regFallbackValue(NSS nSS, String string, String string2, String string3) {
        Object object = nSS.select(string2);
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = NSSUtils.setThemeProperty(this, string, object);
        }
        catch (Throwable throwable) {
            bl2 = true;
        }
        if (!bl) {
            String string4 = "NSS selector '" + nSS.getSelector() + ' ' + string2 + "' does not reference a valid property. ";
            if (string3 != null) {
                if (bl2) {
                    logger.warning(string4 + "Using default of '" + string3 + "'.");
                }
                NSSUtils.setThemeProperty(this, string, string3);
            } else if (bl2) {
                logger.error(string4);
            }
        }
    }

    void regFallbackSelector(NSS nSS, String string, String string2, String string3) {
        Object object = nSS.select(string2);
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = NSSUtils.setThemeProperty(this, string, object);
        }
        catch (Throwable throwable) {
            bl2 = true;
        }
        if (!bl) {
            String string4 = "NSS selector '" + nSS.getSelector() + ' ' + string2 + "' does not reference a valid property. ";
            if (string3 != null) {
                if (bl2) {
                    logger.warning(string4 + "Using default of '" + string3 + "'.");
                }
                this.regFallbackSelector(nSS, string, string3, null);
            } else if (bl2) {
                logger.error(string4);
            }
        }
    }

    void reg(NSS nSS, String string, String string2) {
        this.regFallbackValue(nSS, string, string2, null);
    }
}

