/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.TreeTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;

public class CustomTreeTheme
extends CustomWidgetTheme
implements TreeTheme {
    private double expanderWidth;
    private double expanderHeight;
    private BInsets insets;

    String getNSSSelector() {
        return "tree";
    }

    public BFont getFont(BWidget bWidget) {
        return this.getTextFont(bWidget);
    }

    public BBrush getForeground(BWidget bWidget) {
        return this.getTextBrush(bWidget);
    }

    public BBrush getBackground(BWidget bWidget) {
        return this.getControlBackground(bWidget);
    }

    public BBrush getConnectingBrush(BWidget bWidget) {
        BBrush bBrush = (BBrush)this.select(bWidget, "connector-color");
        if (bBrush == null) {
            return this.getWindowForeground(bWidget);
        }
        return bBrush;
    }

    public BBrush getExpanderBrush(BWidget bWidget) {
        return (BBrush)this.select(bWidget, "expander color");
    }

    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets bInsets) {
        this.insets = bInsets;
    }

    public BInsets getInsets(BWidget bWidget) {
        return (BInsets)this.select(bWidget, "padding");
    }

    public double getExpanderHeight() {
        return this.expanderHeight;
    }

    public void setExpanderHeight(double d) {
        this.expanderHeight = d;
    }

    public double getExpanderWidth() {
        return this.expanderWidth;
    }

    public void setExpanderWidth(double d) {
        this.expanderWidth = d;
    }

    public boolean inExpander(double d, double d2, double d3, double d4) {
        boolean bl = false;
        if (d3 >= d && d3 <= d + this.expanderWidth && d4 >= d2 && d4 <= d2 + this.expanderHeight) {
            bl = true;
        }
        return bl;
    }

    public void paintExpander(Graphics graphics, BWidget bWidget, double d, double d2, boolean bl) {
        BBrush bBrush = graphics.getBrush();
        double d3 = d + (double)((int)(this.expanderWidth / (double)2));
        double d4 = d2 + (double)((int)(this.expanderHeight / (double)2));
        graphics.setBrush(this.getConnectingBrush(bWidget));
        graphics.strokeLine(d, d2, d + this.expanderWidth - 1.0, d2);
        graphics.strokeLine(d, d2, d, d2 + this.expanderHeight - 1.0);
        graphics.strokeLine(d + this.expanderWidth - 1.0, d2, d + this.expanderWidth - 1.0, d2 + this.expanderHeight - 1.0);
        graphics.strokeLine(d, d2 + this.expanderHeight - 1.0, d + this.expanderWidth - 1.0, d2 + this.expanderHeight - 1.0);
        graphics.setBrush(this.getExpanderBrush(bWidget));
        graphics.strokeLine(d + (double)2, d4, d + this.expanderWidth - (double)3, d4);
        if (!bl) {
            graphics.strokeLine(d3, d2 + (double)2, d3, d2 + this.expanderHeight - (double)3);
        }
        graphics.setBrush(bBrush);
    }

    public void paintExpander(Graphics graphics, BWidget bWidget, double d, double d2, boolean bl, boolean bl2) {
        this.paintExpander(graphics, bWidget, d, d2, bl2);
    }

    public CustomTreeTheme() {
        NSS nSS = CustomTreeTheme.getNSS();
        NSS nSS2 = nSS.selectNode("tree");
        this.regFallbackValue(nSS2, "insets", "padding", "2 4");
        NSS nSS3 = nSS2.selectNode("expander");
        this.regFallbackValue(nSS3, "expanderWidth", "width", "9");
        this.regFallbackValue(nSS3, "expanderHeight", "height", "9");
    }
}

