/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;

public class CustomThemeModuleManager {
    private static Log logger = Log.getLog((String)"com.tridium.ui.theme.custom");
    private static BEnumRange themeModules = CustomThemeModuleManager.initializeThemeModules();
    private static final String[] DEFAULT_THEMES = new String[]{"Lucid", "Palladium"};

    private static final BEnumRange initializeThemeModules() {
        String[] stringArray = Sys.getRegistry().getDefs("themeName");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            BDirectory bDirectory = CustomThemeModuleManager.getNSSDirectory(string);
            if (bDirectory != null) {
                BIFile[] bIFileArray = bDirectory.listFiles();
                int n2 = 0;
                while (n2 < bIFileArray.length) {
                    String string2 = CustomThemeModuleManager.getDisplayNSSPath(string, bIFileArray[n2]);
                    if (string2 != null) {
                        arrayList.add(string2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Collections.sort(arrayList);
        return BEnumRange.make((String[])arrayList.toArray(new String[arrayList.size()]));
    }

    private static final BDirectory getNSSDirectory(String string) {
        BOrd bOrd = BOrd.make((String)("module://" + string + "/nss"));
        try {
            BObject bObject = bOrd.get();
            if (bObject instanceof BDirectory && !bObject.isNull()) {
                return (BDirectory)bObject;
            }
            return null;
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            moduleNotFoundException.printStackTrace();
            return null;
        }
    }

    private static final String getDisplayNSSPath(String string, BIFile bIFile) {
        String string2 = bIFile.getFilePath().toString();
        if (!string2.endsWith(".nss")) {
            return null;
        }
        if (string2.startsWith("zip:/")) {
            string2 = string2.substring(5);
        }
        if (string2.startsWith("nss/")) {
            string2 = string2.substring(4);
        }
        if (string2.endsWith(".nss")) {
            string2 = string2.substring(0, string2.indexOf(".nss"));
        }
        if ((string2 = string2.equals("theme") ? string : string + '/' + string2).startsWith("theme")) {
            string2 = string2.substring(5);
        }
        string2 = SlotPath.escape((String)string2);
        return string2;
    }

    public static BDynamicEnum getModuleEnumForTag(String string) {
        try {
            BEnum bEnum = themeModules.get(string);
            return BDynamicEnum.make((BEnum)bEnum);
        }
        catch (InvalidEnumException invalidEnumException) {
            return CustomThemeModuleManager.getDefaultThemeEnum();
        }
    }

    public static BDynamicEnum getDefaultThemeEnum() {
        int[] nArray;
        BEnum bEnum = null;
        int n = 0;
        while (n < DEFAULT_THEMES.length) {
            String string = DEFAULT_THEMES[n];
            try {
                bEnum = themeModules.get(SlotPath.escape((String)string));
                return BDynamicEnum.make((BEnum)bEnum);
            }
            catch (InvalidEnumException invalidEnumException) {
                ++n;
            }
        }
        if (bEnum == null && (nArray = themeModules.getOrdinals()).length > 0) {
            return BDynamicEnum.make((BEnum)themeModules.get(nArray[0]));
        }
        return BDynamicEnum.DEFAULT;
    }

    public static void installFromEnum(BDynamicEnum bDynamicEnum) {
        String string = bDynamicEnum.getTag();
        if (string == null || string.equals("0")) {
            logger.warning("Default theme module could not be loaded. Using default.");
            Theme.installDefaultTheme();
        } else {
            Theme.installCustomTheme(null, string);
        }
    }
}

