/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.TabbedPaneTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.pane.BTabbedPane;

public class CustomTabbedPaneTheme
extends CustomWidgetTheme
implements TabbedPaneTheme {
    private static BInsets contentInsetsFull = BInsets.make((double)2, (double)2, (double)2, (double)2);
    private static BInsets tabInsets = BInsets.make((double)5, (double)5, (double)5, (double)5);
    private static BInsets contentInsetsTop = BInsets.make((double)8.0, (double)0.0, (double)0.0, (double)0.0);
    private static BInsets contentInsetsLeft = BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)8.0);
    private static BInsets contentInsetsRight = BInsets.make((double)0.0, (double)8.0, (double)0.0, (double)0.0);
    private static BInsets contentInsetsBottom = BInsets.make((double)0.0, (double)0.0, (double)8.0, (double)0.0);

    String getNSSSelector() {
        return "pane tabbed-pane";
    }

    private final BBrush selectedBrush(boolean bl, String string) {
        return (BBrush)this.select(bl ? ".selected " + string : string);
    }

    private final BBrush getShadow(boolean bl) {
        return this.selectedBrush(bl, "shadow");
    }

    private final BBrush getHighlight(boolean bl) {
        return this.selectedBrush(bl, "highlight");
    }

    private final BBrush getOutline(boolean bl) {
        return this.selectedBrush(bl, "outline");
    }

    private final BBrush getBackground(boolean bl) {
        return this.selectedBrush(bl, "background-color");
    }

    public BInsets getTabInsets(BAlign bAlign) {
        return tabInsets;
    }

    public BInsets getContentInsets(BAlign bAlign, boolean bl) {
        if (bl) {
            return contentInsetsFull;
        }
        switch (bAlign.getOrdinal()) {
            case 0: {
                return contentInsetsTop;
            }
            case 1: {
                return contentInsetsLeft;
            }
            case 3: {
                return contentInsetsRight;
            }
            case 2: {
                return contentInsetsBottom;
            }
        }
        return null;
    }

    public void paintContentBackground(Graphics graphics, BTabbedPane bTabbedPane, BAlign bAlign, BWidget bWidget, boolean bl) {
        BInsets bInsets = this.getContentInsets(bAlign, bl);
        double d = bWidget.getX() - bInsets.left;
        double d2 = bWidget.getY() - bInsets.top;
        double d3 = bWidget.getWidth() + bInsets.left + bInsets.right;
        double d4 = bWidget.getHeight() + bInsets.top + bInsets.bottom;
        BBrush bBrush = this.getControlForeground(bTabbedPane);
        BBrush bBrush2 = this.getControlHighlight(bTabbedPane);
        BBrush bBrush3 = this.getControlShadow(bTabbedPane);
        if (bl) {
            graphics.setBrush(bBrush);
            graphics.strokeRect(d, d2, d3 - 1.0, d4 - 1.0);
            graphics.setBrush(bBrush2);
            graphics.strokeLine(d + 1.0, d2 + 1.0, d + d3 - (double)3, d2 + 1.0);
            graphics.strokeLine(d + 1.0, d2 + 1.0, d + 1.0, d2 + d4 - (double)3);
            graphics.setBrush(bBrush3);
            graphics.strokeLine(d + d3 - (double)2, d2 + 1.0, d + d3 - (double)2, d2 + d4 - (double)2);
            graphics.strokeLine(d + d3 - (double)2, d2 + d4 - (double)2, d + 1.0, d2 + d4 - (double)2);
        } else {
            switch (bAlign.getOrdinal()) {
                case 0: {
                    graphics.setBrush(bBrush);
                    graphics.strokeLine(d, d2, d + d3, d2);
                    graphics.setBrush(bBrush2);
                    graphics.strokeLine(d, d2 + 1.0, d + d3, d2 + 1.0);
                    break;
                }
                case 2: {
                    graphics.setBrush(bBrush);
                    graphics.strokeLine(d, d2 + d4 - 1.0, d + d3, d2 + d4 - 1.0);
                    graphics.setBrush(bBrush3);
                    graphics.strokeLine(d, d2 + d4 - (double)2, d + d3, d2 + d4 - (double)2);
                    break;
                }
                case 1: {
                    graphics.setBrush(bBrush);
                    graphics.strokeLine(d, d2, d, d2 + d4 - 1.0);
                    graphics.setBrush(bBrush2);
                    graphics.strokeLine(d + 1.0, d2, d + 1.0, d2 + d4 - 1.0);
                    break;
                }
                case 3: {
                    graphics.setBrush(bBrush);
                    graphics.strokeLine(d + d3 - 1.0, d2, d + d3 - 1.0, d2 + d4 - 1.0);
                    graphics.setBrush(bBrush3);
                    graphics.strokeLine(d + d3 - (double)2, d2, d + d3 - (double)2, d2 + d4 - 1.0);
                    break;
                }
            }
        }
    }

    public void paintTabBackground(Graphics graphics, BTabbedPane bTabbedPane, BAlign bAlign, BLabel bLabel, boolean bl, BWidget bWidget, boolean bl2) {
        BInsets bInsets = this.getTabInsets(bAlign);
        BInsets bInsets2 = this.getContentInsets(bAlign, bl2);
        double d = bLabel.getX() - bInsets.left;
        double d2 = bLabel.getY() - bInsets.top;
        double d3 = bLabel.getWidth() + bInsets.left + bInsets.right;
        double d4 = bLabel.getHeight() + bInsets.top + bInsets.bottom;
        double d5 = d3;
        double d6 = d4;
        if (d + d3 >= bTabbedPane.getWidth()) {
            d3 = bTabbedPane.getWidth() - d - 1.0;
        }
        if (d2 + d4 >= bTabbedPane.getHeight()) {
            d4 = bTabbedPane.getHeight() - d2 - 1.0;
        }
        switch (bAlign.getOrdinal()) {
            case 0: {
                d6 = bWidget.getY() - bInsets2.top;
                break;
            }
            case 2: {
                d6 = bWidget.getY() + bWidget.getHeight() + bInsets2.bottom;
                break;
            }
            case 1: {
                d5 = bWidget.getX() - bInsets2.left;
                break;
            }
            case 3: {
                d5 = bWidget.getX() + bWidget.getWidth() + bInsets2.right;
                break;
            }
        }
        this.paintTabBackground(graphics, bTabbedPane, bLabel, bAlign, d, d2, d3, d4, d5, d6, bl);
    }

    protected void paintTabBackground(Graphics graphics, BTabbedPane bTabbedPane, BLabel bLabel, BAlign bAlign, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        switch (bAlign.getOrdinal()) {
            case 0: {
                this.paintTabTop(graphics, bTabbedPane, d, d2, d3, d4, d5, d6, bl);
                break;
            }
            case 1: {
                this.paintTabLeft(graphics, bTabbedPane, d, d2, d3, d4, d5, d6, bl);
                break;
            }
            case 3: {
                this.paintTabRight(graphics, bTabbedPane, d, d2, d3, d4, d5, d6, bl);
                break;
            }
            case 2: {
                this.paintTabBottom(graphics, bTabbedPane, d, d2, d3, d4, d5, d6, bl);
                break;
            }
            default: {
                return;
            }
        }
        if (bTabbedPane.hasFocus() && bl) {
            this.paintFocus(graphics, new RectGeom(bLabel.getX() - 1.0, bLabel.getY() - 1.0, bLabel.getWidth() + 1.0, bLabel.getHeight() + 1.0));
        }
    }

    protected void paintTabTop(Graphics graphics, BTabbedPane bTabbedPane, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        BBrush bBrush = this.getHighlight(bl);
        BBrush bBrush2 = this.getBackground(bl);
        BBrush bBrush3 = this.getShadow(bl);
        BBrush bBrush4 = this.getOutline(bl);
        double[] dArray = new double[]{d, d, d + 7.0, d + d3, d + d3};
        double[] dArray2 = new double[]{d6, d2 + 7.0, d2, d2, d6};
        int n = 5;
        PolygonGeom polygonGeom = new PolygonGeom(dArray, dArray2, n);
        graphics.setBrush(bBrush2);
        graphics.fill((IGeom)polygonGeom);
        graphics.setBrush(bBrush4);
        graphics.strokeLine(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        graphics.strokeLine(dArray[1], dArray2[1], dArray[2], dArray2[2]);
        graphics.strokeLine(dArray[2], dArray2[2], dArray[3], dArray2[3]);
        graphics.strokeLine(dArray[3], dArray2[3], dArray[4], dArray2[4]);
        graphics.setBrush(bBrush);
        graphics.strokeLine(dArray[0] + 1.0, dArray2[0] - 1.0, dArray[1] + 1.0, dArray2[1]);
        graphics.strokeLine(dArray[1] + 1.0, dArray2[1], dArray[2], dArray2[2] + 1.0);
        graphics.strokeLine(dArray[2], dArray2[2] + 1.0, dArray[3] - 1.0, dArray2[3] + 1.0);
        graphics.setBrush(bBrush3);
        graphics.strokeLine(dArray[3] - 1.0, dArray2[3] + 1.0, dArray[4] - 1.0, dArray2[4] - 1.0);
        if (bl && d6 - d2 <= d4) {
            graphics.setBrush(bBrush2);
            graphics.strokeLine(dArray[0] + (double)2, dArray2[0], dArray[4] - 1.0, dArray2[4]);
            graphics.strokeLine(dArray[0] + (double)2, dArray2[0] + 1.0, dArray[4] - 1.0, dArray2[4] + 1.0);
            graphics.setBrush(bBrush);
            graphics.strokeLine(dArray[0] + 1.0, dArray2[0], dArray[0] + 1.0, dArray2[0] + 1.0);
            graphics.setBrush(bBrush3);
            graphics.strokeLine(dArray[4] - 1.0, dArray2[4], dArray[4] - 1.0, dArray2[4] + 1.0);
        }
    }

    protected void paintTabLeft(Graphics graphics, BTabbedPane bTabbedPane, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        BBrush bBrush = this.getHighlight(bl);
        BBrush bBrush2 = this.getBackground(bl);
        BBrush bBrush3 = this.getShadow(bl);
        BBrush bBrush4 = this.getOutline(bl);
        double[] dArray = new double[]{d5, d + 7.0, d, d, d5};
        double[] dArray2 = new double[]{d2 + d4, d2 + d4, d2 + d4 - 7.0, d2, d2};
        int n = 5;
        PolygonGeom polygonGeom = new PolygonGeom(dArray, dArray2, n);
        graphics.setBrush(bBrush2);
        graphics.fill((IGeom)polygonGeom);
        graphics.setBrush(bBrush4);
        graphics.strokeLine(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        graphics.strokeLine(dArray[1], dArray2[1], dArray[2], dArray2[2]);
        graphics.strokeLine(dArray[2], dArray2[2], dArray[3], dArray2[3]);
        graphics.strokeLine(dArray[3], dArray2[3], dArray[4], dArray2[4]);
        graphics.setBrush(this.getControlShadow(bTabbedPane));
        graphics.strokeLine(dArray[0] - 1.0, dArray2[0] - 1.0, dArray[1], dArray2[1] - 1.0);
        graphics.setBrush(bBrush);
        graphics.strokeLine(dArray[2] + 1.0, dArray2[2], dArray[3] + 1.0, dArray2[3] + 1.0);
        graphics.strokeLine(dArray[3] + 1.0, dArray2[3] + 1.0, dArray[4] - 1.0, dArray2[4] + 1.0);
        if (bl && d5 - d <= d3) {
            graphics.setBrush(bBrush2);
            graphics.strokeLine(dArray[0], dArray2[0] - 1.0, dArray[4], dArray2[4] + (double)2);
            graphics.strokeLine(dArray[0] + 1.0, dArray2[0] - 1.0, dArray[4] + 1.0, dArray2[4] + (double)2);
            graphics.setBrush(bBrush);
            graphics.strokeLine(dArray[4], dArray2[4] + 1.0, dArray[4] + 1.0, dArray2[4] + 1.0);
            graphics.setBrush(bBrush3);
            graphics.strokeLine(dArray[0], dArray2[0] - 1.0, dArray[0] + 1.0, dArray2[0] - 1.0);
        }
    }

    protected void paintTabRight(Graphics graphics, BTabbedPane bTabbedPane, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        BBrush bBrush = this.getHighlight(bl);
        BBrush bBrush2 = this.getBackground(bl);
        BBrush bBrush3 = this.getShadow(bl);
        BBrush bBrush4 = this.getOutline(bl);
        double[] dArray = new double[]{d5, d + d3 - 7.0, d + d3, d + d3, d5};
        double[] dArray2 = new double[]{d2 + d4, d2 + d4, d2 + d4 - 7.0, d2, d2};
        int n = 5;
        PolygonGeom polygonGeom = new PolygonGeom(dArray, dArray2, n);
        graphics.setBrush(bBrush2);
        graphics.fill((IGeom)polygonGeom);
        graphics.setBrush(bBrush4);
        graphics.strokeLine(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        graphics.strokeLine(dArray[1], dArray2[1], dArray[2], dArray2[2]);
        graphics.strokeLine(dArray[2], dArray2[2], dArray[3], dArray2[3]);
        graphics.strokeLine(dArray[3], dArray2[3], dArray[4], dArray2[4]);
        graphics.setBrush(bBrush3);
        graphics.strokeLine(dArray[0], dArray2[0] - 1.0, dArray[1] - 1.0, dArray2[1] - 1.0);
        graphics.strokeLine(dArray[1], dArray2[1] - 1.0, dArray[2] - 1.0, dArray2[2]);
        graphics.strokeLine(dArray[2] - 1.0, dArray2[2] - 1.0, dArray[3] - 1.0, dArray2[3] + 1.0);
        graphics.setBrush(bBrush);
        graphics.strokeLine(dArray[3] - (double)2, dArray2[3] + 1.0, dArray[4], dArray2[4] + 1.0);
        if (bl && d <= d5) {
            graphics.setBrush(bBrush2);
            graphics.strokeLine(dArray[0] - 1.0, dArray2[0] - (double)2, dArray[4] - 1.0, dArray2[4] + 1.0);
            graphics.strokeLine(dArray[0] - (double)2, dArray2[0] - (double)2, dArray[4] - (double)2, dArray2[4] + 1.0);
            graphics.setBrush(bBrush3);
            graphics.strokeLine(dArray[0], dArray2[0] - 1.0, dArray[0] - 1.0, dArray2[0] - 1.0);
            graphics.setBrush(bBrush);
            graphics.strokeLine(dArray[4], dArray2[4] + 1.0, dArray[4] - (double)2, dArray2[4] + 1.0);
        }
    }

    protected void paintTabBottom(Graphics graphics, BTabbedPane bTabbedPane, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        BBrush bBrush = this.getHighlight(bl);
        BBrush bBrush2 = this.getBackground(bl);
        BBrush bBrush3 = this.getShadow(bl);
        BBrush bBrush4 = this.getOutline(bl);
        double[] dArray = new double[]{d, d, d + 7.0, d + d3, d + d3};
        double[] dArray2 = new double[]{d6, d2 + d4 - 7.0, d2 + d4, d2 + d4, d6};
        int n = 5;
        PolygonGeom polygonGeom = new PolygonGeom(dArray, dArray2, n);
        graphics.setBrush(bBrush2);
        graphics.fill((IGeom)polygonGeom);
        graphics.setBrush(bBrush4);
        graphics.strokeLine(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        graphics.strokeLine(dArray[1], dArray2[1], dArray[2], dArray2[2]);
        graphics.strokeLine(dArray[2], dArray2[2], dArray[3], dArray2[3]);
        graphics.strokeLine(dArray[3], dArray2[3], dArray[4], dArray2[4]);
        graphics.setBrush(bBrush);
        graphics.strokeLine(dArray[0] + 1.0, dArray2[0], dArray[1] + 1.0, dArray2[1]);
        graphics.setBrush(bBrush3);
        graphics.strokeLine(dArray[2], dArray2[2] - 1.0, dArray[3] - 1.0, dArray2[3] - 1.0);
        graphics.strokeLine(dArray[3] - 1.0, dArray2[3] - 1.0, dArray[4] - 1.0, dArray2[4]);
        if (bl && d2 <= d6) {
            graphics.setBrush(bBrush2);
            graphics.strokeLine(dArray[0] + (double)2, dArray2[0] - 1.0, dArray[4] - 1.0, dArray2[4] - 1.0);
            graphics.strokeLine(dArray[0] + (double)2, dArray2[0] - (double)2, dArray[4] - 1.0, dArray2[4] - (double)2);
            graphics.setBrush(bBrush);
            graphics.strokeLine(dArray[0] + 1.0, dArray2[0], dArray[0] + 1.0, dArray2[0] - (double)2);
            graphics.setBrush(bBrush3);
            graphics.strokeLine(dArray[4] - 1.0, dArray2[4], dArray[4] - 1.0, dArray2[4] - (double)2);
        }
    }
}

