/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.SeparatorTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.Graphics;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.enums.BOrientation;

public class CustomSeparatorTheme
extends CustomWidgetTheme
implements SeparatorTheme {
    private double menuFixedWidth;
    private double toolbarFixedWidth;
    private double defaultFixedWidth;

    String getNSSSelector() {
        return "separator";
    }

    public double getMenuFixedWidth() {
        return this.menuFixedWidth;
    }

    public void setMenuFixedWidth(double d) {
        this.menuFixedWidth = d;
    }

    public double getToolbarFixedWidth() {
        return this.toolbarFixedWidth;
    }

    public void setToolbarFixedWidth(double d) {
        this.toolbarFixedWidth = d;
    }

    public double getDefaultFixedWidth() {
        return this.defaultFixedWidth;
    }

    public void setDefaultFixedWidth(double d) {
        this.defaultFixedWidth = d;
    }

    public double getFixedWidth(BSeparator bSeparator) {
        if (bSeparator.getParent() instanceof BMenu) {
            return this.menuFixedWidth;
        }
        if (bSeparator.getParent() instanceof BToolBar) {
            return this.toolbarFixedWidth;
        }
        return this.defaultFixedWidth;
    }

    public void paintSeparator(Graphics graphics, BSeparator bSeparator) {
        double d = bSeparator.getWidth();
        double d2 = bSeparator.getHeight();
        double d3 = d / (double)2 - 1.0;
        double d4 = d2 / (double)2 - 1.0;
        if (bSeparator.getOrientation() == BOrientation.horizontal) {
            graphics.setBrush(this.getControlShadow(bSeparator));
            graphics.strokeLine(0.0, d4, d, d4);
            graphics.setBrush(this.getControlHighlight(bSeparator));
            graphics.strokeLine(0.0, d4 + 1.0, d, d4 + 1.0);
        } else {
            graphics.setBrush(this.getControlShadow(bSeparator));
            graphics.strokeLine(d3, 0.0, d3, d2);
            graphics.setBrush(this.getControlHighlight(bSeparator));
            graphics.strokeLine(d3 + 1.0, 0.0, d3 + 1.0, d2);
        }
    }

    public CustomSeparatorTheme() {
        NSS nSS = CustomSeparatorTheme.getNSS();
        NSS nSS2 = nSS.selectNode("separator");
        this.regFallbackValue(nSS2, "menuFixedWidth", "width-menu", "8");
        this.regFallbackValue(nSS2, "toolbarFixedWidth", "width-toolbar", "8");
        this.regFallbackValue(nSS2, "defaultFixedWidth", "width", "2");
    }
}

