/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.style.IStylable;

public class CustomMenuItemTheme
extends CustomWidgetTheme
implements MenuItemTheme {
    private BInsets insets;
    private BFont acceleratorFont;
    private BBrush acceleratorBrush;
    private double iconIndent;

    String getNSSSelector() {
        return "menu-item";
    }

    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets bInsets) {
        this.insets = bInsets;
    }

    public double getIconIndent() {
        return this.iconIndent;
    }

    public void setIconIndent(double d) {
        this.iconIndent = d;
    }

    public BFont getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public void setAcceleratorFont(BFont bFont) {
        this.acceleratorFont = bFont;
    }

    public BBrush getAcceleratorBrush() {
        return this.acceleratorBrush;
    }

    public void setAcceleratorBrush(BBrush bBrush) {
        this.acceleratorBrush = bBrush;
    }

    public void paintDisabledText(Graphics graphics, IStylable iStylable, String string, double d, double d2) {
        graphics.setBrush(this.getControlHighlight(iStylable));
        graphics.drawString(string, d + 1.0, d2 + 1.0);
        graphics.setBrush(this.getControlShadow(iStylable));
        graphics.drawString(string, d, d2);
    }

    public void paintBackground(Graphics graphics, BMenuItem bMenuItem, boolean bl) {
        if (bl) {
            graphics.setBrush(this.getSelectionBackground(bMenuItem));
        } else {
            graphics.setBrush(this.getControlBackground(bMenuItem));
        }
        graphics.fillRect(0.0, 0.0, bMenuItem.getWidth(), bMenuItem.getHeight());
    }

    public void paintSubMenuArrow(Graphics graphics, BMenuItem bMenuItem, boolean bl) {
        double d = bMenuItem.getWidth();
        double d2 = bMenuItem.getHeight();
        double d3 = d2 / (double)2;
        double d4 = d - (double)4;
        if (bMenuItem.getEnabled()) {
            if (bl) {
                graphics.setBrush(this.getSelectionForeground());
            } else {
                graphics.setBrush(this.getControlForeground());
            }
        } else {
            graphics.setBrush(this.getTextDisabled());
        }
        graphics.strokeLine(d4, d3, d4, d3 + 0.0);
        graphics.strokeLine(d4 -= 1.0, d3 - 1.0, d4, d3 + 1.0);
        graphics.strokeLine(d4 -= 1.0, d3 - (double)2, d4, d3 + (double)2);
        graphics.strokeLine(d4 -= 1.0, d3 - (double)3, d4, d3 + (double)3);
        graphics.strokeLine(d4 -= 1.0, d3 - (double)4, d4, d3 + (double)4);
        d4 -= 1.0;
    }

    public void paintCheckBox(Graphics graphics, BCheckBoxMenuItem bCheckBoxMenuItem, boolean bl) {
        if (bCheckBoxMenuItem.getSelected()) {
            double d = bCheckBoxMenuItem.getHeight();
            double d2 = this.insets.left / (double)2 - (double)4;
            double d3 = d / (double)2 + (double)2;
            if (bCheckBoxMenuItem.getEnabled()) {
                graphics.setBrush(this.getControlForeground());
            } else {
                graphics.setBrush(this.getControlShadow());
            }
            graphics.strokeLine(d2, d3, d2 + 1.0, d3 - 1.0);
            graphics.strokeLine(d2 + 1.0, d3 + 1.0, d2 + 6.0, d3 - (double)4);
            graphics.strokeLine(d2 + (double)2, d3 + (double)2, d2 + 7.0, d3 - (double)3);
            graphics.strokeLine(d2 + 1.0, d3, d2 + (double)2, d3 + 1.0);
            graphics.strokeLine(d2 + (double)2, d3 + 1.0, d2 + 6.0, d3 - (double)3);
        }
    }

    public void paintRadioBox(Graphics graphics, BRadioButtonMenuItem bRadioButtonMenuItem, boolean bl) {
        if (bRadioButtonMenuItem.getSelected()) {
            double d = 4;
            double d2 = 4;
            double d3 = this.insets.left / (double)2 - d / (double)2;
            double d4 = bRadioButtonMenuItem.getHeight() / (double)2 - d2 / (double)2 + 1.0;
            if (bRadioButtonMenuItem.getEnabled()) {
                graphics.setBrush(this.getControlForeground());
            } else {
                graphics.setBrush(this.getControlShadow());
            }
            graphics.strokeLine(d3, d4 + d2 / (double)2, d3 + d / (double)2, d4);
            graphics.strokeLine(d3 + 1.0, d4 + d2 / (double)2 + 1.0, d3 + d / (double)2 + 1.0, d4 + 1.0);
            graphics.strokeLine(d3 + (double)2, d4 + d2 / (double)2 + (double)2, d3 + d / (double)2 + (double)2, d4 + (double)2);
            graphics.strokeLine(d3 + 1.0, d4 + d2 / (double)2, d3 + d / (double)2, d4 + 1.0);
            graphics.strokeLine(d3 + (double)2, d4 + d2 / (double)2 + 1.0, d3 + d / (double)2 + 1.0, d4 + (double)2);
        }
    }

    public CustomMenuItemTheme() {
        NSS nSS = CustomMenuItemTheme.getNSS();
        NSS nSS2 = nSS.selectNode("menu-item");
        this.regFallbackValue(nSS2, "insets", "padding", "2 14 2 22");
        this.regFallbackValue(nSS2, "iconIndent", "icon-indent", "2");
        this.regFallbackSelector(nSS, "acceleratorBrush", "menu-item accelerator color", "selection-background-color");
        BFont bFont = (BFont)nSS2.selectProperty("accelerator font");
        if (bFont == null) {
            BFont bFont2 = this.getTextFont();
            bFont = BFont.make((String)bFont2.getName(), (double)(bFont2.getSize() - 1.0), (int)bFont2.getStyle());
        }
        this.setAcceleratorFont(bFont);
    }
}

