/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.DropDownTheme;
import com.tridium.ui.theme.custom.CustomThemeUtils;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;

public class CustomDropDownTheme
extends CustomWidgetTheme
implements DropDownTheme {
    private BInsets insets;

    String getNSSSelector() {
        return "drop-down";
    }

    public BInsets getBorderInsets() {
        return this.insets;
    }

    public void setBorderInsets(BInsets bInsets) {
        this.insets = bInsets;
    }

    public void paintBorder(Graphics graphics, BWidget bWidget) {
        this.paintBorder(graphics, bWidget, 0.0, 0.0, bWidget.getWidth(), bWidget.getHeight());
    }

    public void paintBorder(Graphics graphics, BWidget bWidget, double d, double d2, double d3, double d4) {
        if (d != 0.0 || d2 != 0.0) {
            graphics.translate(d, d2);
        }
        graphics.setBrush(this.getControlForeground(bWidget));
        graphics.strokeRect(1.0, 1.0, d3 - (double)3, d4 - (double)3);
        graphics.setBrush(this.getControlShadow(bWidget));
        graphics.strokeLine(0.0, 0.0, d3 - 1.0, 0.0);
        graphics.strokeLine(0.0, 0.0, 0.0, d4 - 1.0);
        graphics.setBrush(this.getControlHighlight(bWidget));
        graphics.strokeLine(d3 - 1.0, 1.0, d3 - 1.0, d4 - 1.0);
        graphics.strokeLine(1.0, d4 - 1.0, d3 - 1.0, d4 - 1.0);
        if (d != 0.0 || d2 != 0.0) {
            graphics.translate(-d, -d2);
        }
    }

    public void paintButton(Graphics graphics, BWidget bWidget, RectGeom rectGeom, boolean bl) {
        double d = rectGeom.x - 1.0;
        double d2 = rectGeom.y - 1.0;
        double d3 = rectGeom.width + 1.0;
        double d4 = rectGeom.height + 1.0;
        graphics.setBrush((BBrush)this.select(bWidget, "button background-color"));
        graphics.fillRect(d, d2, d3, d4);
        graphics.setBrush((BBrush)this.select(bWidget, "button outline"));
        graphics.strokeRect(d, d2, d3, d4);
        if (bl) {
            graphics.setBrush((BBrush)this.select(bWidget, "button shadow"));
        } else {
            graphics.setBrush((BBrush)this.select(bWidget, "button highlight"));
        }
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + d3 - (double)2, d2 + 1.0);
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + 1.0, d2 + d4 - 1.0);
        graphics.setBrush((BBrush)this.select(bWidget, "button shadow"));
        graphics.strokeLine(d + d3 - 1.0, d2 + 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
        graphics.strokeLine(d + 1.0, d2 + d4 - 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
        graphics.setBrush((BBrush)this.select(bWidget, "button color"));
        boolean bl2 = bl;
        int n = 1;
        CustomThemeUtils.paintArrow(graphics, n, d + (double)bl2, d2 + (double)bl2, d3, d4);
    }

    public void paintBackground(Graphics graphics, BWidget bWidget) {
        graphics.setBrush(this.getControlBackground(bWidget));
        graphics.fillRect(0.0, 0.0, bWidget.getWidth(), bWidget.getHeight());
    }

    public BBrush getDisabledBackgroundBrush(BWidget bWidget) {
        return this.getControlBackground(bWidget);
    }

    public CustomDropDownTheme() {
        NSS nSS = CustomDropDownTheme.getNSS();
        this.regFallbackValue(nSS, "borderInsets", "drop-down padding", "2");
    }
}

