/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.CheckBoxTheme;
import com.tridium.ui.theme.custom.CustomToggleButtonTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class CustomCheckBoxTheme
extends CustomToggleButtonTheme
implements CheckBoxTheme {
    private int checkBoxSize;

    String getNSSSelector() {
        return "button checkbox";
    }

    public BFont getTextFont() {
        return this.getPlainText();
    }

    public IPoint getLabelOffset(BAbstractButton bAbstractButton) {
        return this.noOffset;
    }

    public int getCheckBoxSize() {
        return this.checkBoxSize;
    }

    public void setCheckBoxSize(int n) {
        this.checkBoxSize = n;
    }

    public void paintBackground(Graphics graphics, BAbstractButton bAbstractButton) {
        boolean bl = bAbstractButton.isMouseOver();
        boolean bl2 = bAbstractButton.isPressed();
        boolean bl3 = ((BToggleButton)bAbstractButton).isSelected();
        BBrush bBrush = bAbstractButton.getBackground();
        if (!bBrush.isNull()) {
            graphics.setBrush(bBrush);
            graphics.fillRect(0.0, 0.0, bAbstractButton.getWidth(), bAbstractButton.getHeight());
        }
        double d = 0.0;
        double d2 = bAbstractButton.getHeight() / (double)2 - (double)(this.checkBoxSize / 2);
        double d3 = this.checkBoxSize - 1;
        double d4 = this.checkBoxSize - 1;
        graphics.setBrush(this.getControlBackground(bAbstractButton));
        graphics.fillRect(d, d2, d3, d4);
        graphics.setBrush(this.getControlForeground(bAbstractButton));
        graphics.strokeRect(d, d2, d3, d4);
        if (bl2 && bl) {
            graphics.setBrush(this.getControlShadow(bAbstractButton));
        } else {
            graphics.setBrush(this.getControlHighlight(bAbstractButton));
        }
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + d3 - (double)2, d2 + 1.0);
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + 1.0, d2 + d4 - (double)2);
        graphics.setBrush(this.getControlShadow(bAbstractButton));
        graphics.strokeLine(d + d3 - 1.0, d2 + 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
        graphics.strokeLine(d + 1.0, d2 + d4 - 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
        if (bl3) {
            d = d3 / (double)2 - (double)4;
            d2 = bAbstractButton.getHeight() / (double)2;
            graphics.setBrush(this.getControlForeground(bAbstractButton));
            graphics.strokeLine(d, d2, d + 1.0, d2 - 1.0);
            graphics.strokeLine(d + 1.0, d2 + 1.0, d + 6.0, d2 - (double)4);
            graphics.strokeLine(d + (double)2, d2 + (double)2, d + 7.0, d2 - (double)3);
            graphics.strokeLine(d + 1.0, d2, d + (double)2, d2 + 1.0);
            graphics.strokeLine(d + (double)2, d2 + 1.0, d + 6.0, d2 - (double)3);
            graphics.setBrush(this.getControlShadow(bAbstractButton));
            graphics.strokeLine(d + (double)3, d2 + (double)2, d + 7.0, d2 - (double)2);
            graphics.strokeLine(d + (double)3, d2 + (double)3, d + 8.0, d2 - (double)2);
        }
        if (bAbstractButton.hasFocus() && bAbstractButton.isFocusTraversable() && bAbstractButton.getText() != null && bAbstractButton.getText().length() > 0) {
            BInsets bInsets = this.getNormalPadding();
            d = bInsets.left - (double)2;
            d2 = bInsets.top;
            d3 = bAbstractButton.getWidth() - (d + bInsets.right);
            d4 = bAbstractButton.getHeight() - (d2 + bInsets.bottom);
            this.paintFocus(graphics, new RectGeom(d, d2, d3, d4));
        }
    }

    public CustomCheckBoxTheme() {
        NSS nSS = CustomCheckBoxTheme.getNSS();
        NSS nSS2 = nSS.selectNode("button checkbox");
        this.regFallbackValue(nSS2, "normalPadding", "padding", "2 2 2 18");
        this.regFallbackValue(nSS2, "checkBoxSize", "size", "13");
    }
}

