/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.TableTheme;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.util.UiLexicon;

public class CuriumTableTheme
extends CuriumWidgetTheme
implements TableTheme {
    static BBrush gridBrush = BColor.make((int)0xCCCCCC).toBrush();
    static BBrush bandBrush = BColor.make((int)220, (int)220, (int)220).toBrush();
    static BBrush categoryBrowserBandBrush = BColor.make((int)255, (int)255, (int)187).toBrush();
    static BBrush cellTableSelectionBackground = BColor.make((int)192, (int)192, (int)255).toBrush();
    static double cellHeight;
    private static final String CATEGORY_BROWSER_CLASS = "category-browser";
    private static final String CELL_TABLE_CLASS = "cell-table";

    public BFont getHeaderFont() {
        return boldText;
    }

    public BBrush getHeaderTextBrush() {
        return controlForeground;
    }

    public double getCellHeight() {
        return cellHeight;
    }

    public BFont getCellFont() {
        return plainText;
    }

    public BFont getCellFont(IStylable iStylable) {
        return this.getCellFont();
    }

    public BBrush getCellTextBrush() {
        return this.getTextBrush();
    }

    public void paintBackground(Graphics graphics, BWidget bWidget) {
        graphics.setBrush(this.getWindowBackground());
        graphics.fillRect(0.0, 0.0, bWidget.getWidth(), bWidget.getHeight());
    }

    public void paintHeaderBackground(Graphics graphics, TableHeaderRenderer.Header header, BBrush bBrush) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = header.width;
        double d4 = header.height;
        if (bBrush != null) {
            graphics.setBrush(bBrush);
        } else {
            graphics.setBrush(this.getControlBackground());
        }
        graphics.fillRect(d, d2, d3, d4);
        graphics.setBrush(this.getControlHighlight());
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + d3 - (double)2, d2 + 1.0);
        graphics.strokeLine(d + 1.0, d2 + 1.0, d + 1.0, d2 + d4 - (double)2);
        graphics.setBrush(this.getControlShadow());
        graphics.strokeLine(d + d3 - 1.0, d2 + 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
        graphics.strokeLine(d + 1.0, d2 + d4 - (double)2, d + d3 - 1.0, d2 + d4 - (double)2);
        graphics.setBrush(this.getControlForeground());
        graphics.strokeRect(d, d2, d3, d4 - 1.0);
    }

    public double getSortIconWidth() {
        return 8.0;
    }

    public void paintSortIcon(Graphics graphics, TableHeaderRenderer.Header header, boolean bl) {
        int n = 3;
        double d = header.width - 8.0;
        double d2 = (header.height - (double)n) / (double)2;
        graphics.setBrush(this.getControlShadow());
        int n2 = 0;
        while (n2 <= n) {
            if (bl) {
                graphics.strokeLine(d - (double)n2, d2 + (double)n2, d + (double)n2, d2 + (double)n2);
            } else {
                graphics.strokeLine(d - (double)n2, d2 + (double)n - (double)n2, d + (double)n2, d2 + (double)n - (double)n2);
            }
            ++n2;
        }
    }

    public BBrush getGridBrush() {
        return gridBrush;
    }

    public BBrush getGridBrush(IStylable iStylable) {
        return gridBrush;
    }

    public BBrush getBandBrush() {
        return bandBrush;
    }

    public BBrush getBandBrush(IStylable iStylable) {
        if (StyleUtils.hasStyle(iStylable, CATEGORY_BROWSER_CLASS)) {
            return categoryBrowserBandBrush;
        }
        return bandBrush;
    }

    public BBrush getSelectionForeground(IStylable iStylable) {
        if (StyleUtils.hasStyle(iStylable, CELL_TABLE_CLASS)) {
            return this.getTextBrush();
        }
        return super.getSelectionForeground(iStylable);
    }

    public BBrush getSelectionBackground(IStylable iStylable) {
        if (StyleUtils.hasStyle(iStylable, CELL_TABLE_CLASS)) {
            return cellTableSelectionBackground;
        }
        return super.getSelectionBackground(iStylable);
    }

    static {
        UiLexicon uiLexicon = UiLexicon.bajaui;
        cellHeight = uiLexicon.get("curium.table.cellheight") != null ? Double.parseDouble(uiLexicon.get("curium.table.cellheight")) : plainText.getHeight() + (double)3;
    }
}

