/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.ScrollBarTheme;
import com.tridium.ui.theme.curium.CuriumThemeUtils;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.enums.BOrientation;

public class CuriumScrollBarTheme
extends CuriumWidgetTheme
implements ScrollBarTheme {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;

    public double getFixedWidth() {
        return 30.0;
    }

    public void paintButton(Graphics graphics, BScrollBar bScrollBar, RectGeom rectGeom, int n, boolean bl) {
        graphics.setBrush(this.getControlForeground());
        graphics.strokeRect(rectGeom.x, rectGeom.y, rectGeom.width - 1.0, rectGeom.height - 1.0);
        graphics.setBrush(this.getControlBackground());
        graphics.fillRect(rectGeom.x + (double)2, rectGeom.y + (double)2, rectGeom.width - (double)4, rectGeom.height - (double)4);
        if (bl) {
            graphics.setBrush(this.getControlShadow());
        } else {
            graphics.setBrush(this.getControlHighlight());
        }
        graphics.strokeLine(rectGeom.x + 1.0, rectGeom.y + 1.0, rectGeom.x + rectGeom.width - (double)3, rectGeom.y + 1.0);
        graphics.strokeLine(rectGeom.x + 1.0, rectGeom.y + 1.0, rectGeom.x + 1.0, rectGeom.y + rectGeom.height - (double)3);
        if (bScrollBar.getEnabled()) {
            graphics.setBrush(this.getControlShadow());
        } else {
            graphics.setBrush(this.getControlAuxiliary());
        }
        graphics.strokeLine(rectGeom.x + rectGeom.width - (double)2, rectGeom.y + 1.0, rectGeom.x + rectGeom.width - (double)2, rectGeom.y + rectGeom.height - (double)2);
        graphics.strokeLine(rectGeom.x + 1.0, rectGeom.y + rectGeom.height - (double)2, rectGeom.x + rectGeom.width - (double)2, rectGeom.y + rectGeom.height - (double)2);
        if (bScrollBar.getEnabled()) {
            graphics.setBrush(this.getControlForeground());
        } else {
            graphics.setBrush(this.getControlShadow());
        }
        int n2 = bl;
        CuriumThemeUtils.paintArrow(graphics, n, (int)rectGeom.x + n2, (int)rectGeom.y + n2, (int)rectGeom.width, (int)rectGeom.height);
    }

    public void paintTrack(Graphics graphics, BScrollBar bScrollBar, RectGeom rectGeom) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (bScrollBar.getOrientation() == BOrientation.vertical) {
            n7 = n8 = (int)rectGeom.x;
            n5 = n6 = (int)rectGeom.x + (int)rectGeom.width - 1;
            n3 = n4 = (int)rectGeom.y;
            n = n2 = (int)rectGeom.y + (int)rectGeom.height - 1;
        } else {
            n7 = n5 = (int)rectGeom.x;
            n8 = n6 = (int)rectGeom.x + (int)rectGeom.width - 1;
            n3 = n = (int)rectGeom.y;
            n4 = n2 = (int)rectGeom.y + (int)rectGeom.height - 1;
        }
        graphics.setBrush(this.getControlAuxiliary());
        graphics.fillRect(rectGeom.x, rectGeom.y, rectGeom.width, rectGeom.height);
        graphics.setBrush(this.getControlForeground());
        graphics.strokeLine((double)n7, (double)n3, (double)n8, (double)n);
        graphics.strokeLine((double)n5, (double)n4, (double)n6, (double)n2);
        if (bScrollBar.getOrientation() == BOrientation.vertical) {
            ++n7;
            ++n8;
            --n5;
            --n6;
        } else {
            ++n3;
            ++n;
            --n4;
            --n2;
        }
        graphics.setBrush(this.getControlBackground());
        graphics.strokeLine((double)n5, (double)n4, (double)n6, (double)n2);
        graphics.strokeLine((double)n8, (double)n, (double)n6, (double)n2);
        graphics.setBrush(this.getControlShadow());
        graphics.strokeLine((double)n7, (double)n3, (double)n8, (double)n);
        graphics.strokeLine((double)n5, (double)n4, (double)n7, (double)n3);
    }

    public void paintThumb(Graphics graphics, BScrollBar bScrollBar, RectGeom rectGeom) {
        if (bScrollBar.getEnabled()) {
            CuriumThemeUtils.paintThumb(this, graphics, bScrollBar.getOrientation(), rectGeom);
        }
    }
}

