/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.table;

import javax.baja.gx.BImage;
import javax.baja.sys.BObject;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;

public class PagedTableModel
extends DynamicTableModel {
    private int currentPage;
    private int minRowsPerPage;
    private TableModel root;

    public int getRowCount() {
        int n = this.getVisibleRows();
        return Math.min(this.root.getRowCount() - n * (this.currentPage - 1), n);
    }

    public Object getValueAt(int n, int n2) {
        return this.root.getValueAt(this.translateRow(n), n2);
    }

    public Object getSubject(int n) {
        return this.root.getSubject(this.translateRow(n));
    }

    public BImage getRowIcon(int n) {
        return this.root.getRowIcon(this.translateRow(n));
    }

    public Object[] getRowValues(int n) {
        return this.root.getRowValues(this.translateRow(n));
    }

    public BObject export(int n, int n2) {
        return this.root.export(this.translateRow(n), n2);
    }

    public void sortByColumn(int n, boolean bl) {
        this.root.sortByColumn(n, bl);
        this.gotoPage(1);
    }

    private final int translateRow(int n) {
        return (this.currentPage - 1) * this.getVisibleRows() + n;
    }

    private final int getVisibleRows() {
        int n = Math.max(0, this.root.getTable().getVisibleRowCount());
        return this.minRowsPerPage > 0 ? Math.max(n, this.minRowsPerPage) : n;
    }

    public int getPageCount() {
        int n = Math.min(this.root.getRowCount(), this.getVisibleRows());
        if (n == 0) {
            return 1;
        }
        return (this.root.getRowCount() - 1) / n + 1;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void gotoPage(int n) {
        this.currentPage = n < 1 ? 1 : (n > this.getPageCount() ? this.getPageCount() : n);
        this.root.getSelection().deselectAll();
        this.updateTable();
    }

    public void flipPages(int n) {
        this.gotoPage(this.currentPage + n);
    }

    public int[] getRowRange() {
        if (this.root.getRowCount() == 0) {
            return new int[2];
        }
        int n = this.getVisibleRows();
        int n2 = (this.currentPage - 1) * n + 1;
        int n3 = n2 + this.getRowCount() - 1;
        return new int[]{n2, n3};
    }

    public PagedTableModel(TableModel tableModel) {
        this(tableModel, -1);
    }

    public PagedTableModel(TableModel tableModel, int n) {
        super(tableModel);
        this.root = tableModel;
        this.currentPage = 1;
        this.minRowsPerPage = n;
    }
}

