/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.BFilePathBar;
import com.tridium.ui.file.BFilePreview;
import com.tridium.ui.file.BFileSpaceList;
import com.tridium.ui.file.BListView;
import com.tridium.ui.file.FileChooserModel;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNFileChooser
extends BFileChooser {
    public static final Action changeFilter = BNFileChooser.newAction((int)0, null);
    public static final Action actionPerformed = BNFileChooser.newAction((int)0, null);
    public static final Type TYPE;
    BOrd tempOrd;
    final UiLexicon lex;
    FileChooserModel model;
    boolean confirmOverwrite;
    boolean createOnSave;
    BOrd savedFileOrd;
    BEdgePane content;
    BListView listView;
    BFilePreview preview;
    BFilePathBar pathBar;
    BTextField filename;
    BListDropDown filterList;
    BFileSpaceList spaceList;
    Hashtable filterMap;
    ConfirmCommand confirmCommand;
    CancelCommand cancelCommand;
    Stack history;
    BackCommand backCommand;
    UpLevelCommand upLevelCommand;
    CreateDirCommand createDirCommand;
    HomeCommand homeCommand;
    ListCommand listCommand;
    DetailsCommand detailsCommand;
    TogglePreviewCommand togglePreviewCommand;
    BookmarkCommand bookmarkCommand;
    BTree bookmarks;
    BMruButton recentDirs;
    Size lastSize;
    Point lastLocation;
    static /* synthetic */ Class class$com$tridium$ui$file$BNFileChooser;

    public void changeFilter() {
        this.invoke(changeFilter, null, null);
    }

    public void actionPerformed() {
        this.invoke(actionPerformed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BFileChooser makeOpen(BWidget bWidget) {
        return new BNFileChooser(bWidget, UiLexicon.bajaui().getText("fileChooser.open"));
    }

    public static BFileChooser makeSave(BWidget bWidget) {
        return new BNFileChooser(bWidget, UiLexicon.bajaui().getText("fileChooser.save"), false);
    }

    public static BOrd showOpen(BWidget bWidget) {
        BFileChooser bFileChooser = BNFileChooser.makeOpen(bWidget);
        return bFileChooser.show();
    }

    public static BOrd showSave(BWidget bWidget) {
        BFileChooser bFileChooser = BNFileChooser.makeSave(bWidget);
        return bFileChooser.show();
    }

    private final BWidget buildPreview() {
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setDividerPosition(55.0);
        bSplitPane.setWidget1(new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bSplitPane.setWidget2(new BBorderPane((BWidget)this.preview, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return bSplitPane;
    }

    private final BWidget buildNoPreview() {
        return new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    public BOrd[] show(boolean bl) {
        this.bookmarks.setModel(new BookmarkModel());
        this.bookmarks.relayout();
        this.model.setDirectory(this.model.getDirectory());
        if (this.tempOrd != null) {
            try {
                this.xSetCurrentDirectory(this.tempOrd);
            }
            catch (Exception exception) {}
            this.tempOrd = null;
        }
        if (this.lastLocation == null) {
            this.setBoundsCenteredOnOwner();
        } else {
            this.setScreenBounds(this.lastLocation.x, this.lastLocation.y, this.lastSize.width, this.lastSize.height);
        }
        if (!this.getCurrentSpace().isMounted()) {
            this.setCurrentSpace((BSpace)BFileSystem.INSTANCE);
            this.setCurrentNavDirectory(null);
        }
        this.listView.setMultipleSelection(bl);
        this.open();
        if (!this.createOnSave) {
            return new BOrd[]{this.savedFileOrd};
        }
        BIFile[] bIFileArray = this.model.getSelectedFiles();
        BOrd[] bOrdArray = new BOrd[bIFileArray.length];
        int n = 0;
        while (n < bIFileArray.length) {
            bOrdArray[n] = bIFileArray[n].getAbsoluteOrd();
            ++n;
        }
        return bOrdArray;
    }

    public BOrd getCurrentDirectory() {
        BINavNode bINavNode = this.model.getDirectory();
        return bINavNode == null ? null : bINavNode.getNavOrd();
    }

    public void setCurrentDirectory(BOrd bOrd) {
        this.tempOrd = bOrd;
    }

    void xSetCurrentDirectory(BOrd bOrd) {
        if (bOrd.isNull()) {
            return;
        }
        BINavNode bINavNode = (BINavNode)bOrd.resolve((BObject)this.spaceList.getSpaces()[0]).get();
        if (bINavNode instanceof BIDirectory) {
            this.model.setSpace(BOrd.toSpace((BObject)((BObject)bINavNode)));
            this.model.setDirectory(bINavNode);
        } else if (bINavNode instanceof BIFile) {
            this.model.setSpace(BOrd.toSpace((BObject)((BObject)bINavNode)));
            this.model.setDirectory(bINavNode.getNavParent());
            this.model.select((BIFile)bINavNode);
        } else {
            this.model.setSpace(this.spaceList.getSpaces()[0]);
            this.model.setDirectory(null);
        }
    }

    void findCurrentDirectory() {
        if (this.model.getDirectory() != null) {
            return;
        }
        BObject bObject = null;
        try {
            bObject = this.model.getSpace().getNavOrd().resolve().get();
        }
        catch (Exception exception) {}
        if (bObject instanceof BIDirectory) {
            this.model.setDirectory((BINavNode)bObject);
        } else if (bObject instanceof BIFile) {
            this.model.setDirectory(((BINavNode)bObject).getNavParent());
        }
    }

    public void setDefaultFileName(String string) {
        this.filename.setText(string);
    }

    public void setCreateFileOnSave(boolean bl) {
        this.createOnSave = bl;
    }

    public void setConfirmOverwrite(boolean bl) {
        this.confirmOverwrite = bl;
    }

    public void addFilter(IFileFilter iFileFilter) {
        String string = iFileFilter.getDescription(null);
        this.filterList.getList().addItem(string);
        this.filterMap.put(string, iFileFilter);
        this.setCurrentFilter(iFileFilter);
    }

    public void addFilters(IFileFilter[] iFileFilterArray) {
        int n = 0;
        while (n < iFileFilterArray.length) {
            this.addFilter(iFileFilterArray[n]);
            ++n;
        }
    }

    public BSpace[] getSpaces() {
        return this.spaceList.getSpaces();
    }

    public void setSpaces(BSpace[] bSpaceArray) {
        this.spaceList.setSpaces(bSpaceArray);
    }

    public FileChooserModel getModel() {
        return this.model;
    }

    public BSpace getCurrentSpace() {
        return this.model.getSpace();
    }

    public void setCurrentSpace(BSpace bSpace) {
        this.model.setSpace(bSpace);
    }

    public BINavNode getCurrentNavDirectory() {
        return this.model.getDirectory();
    }

    public void setCurrentNavDirectory(BINavNode bINavNode) {
        this.model.setDirectory(bINavNode);
    }

    public void setCurrentDirectory(File file) {
        BIFile bIFile = (BIFile)BFileSystem.INSTANCE.localFileToOrd(file).get();
        this.model.setDirectory((BINavNode)bIFile);
    }

    public IFileFilter getCurrentFilter() {
        return this.model.getFilter();
    }

    public void setCurrentFilter(IFileFilter iFileFilter) {
        String string = iFileFilter.getDescription(null);
        if (this.filterMap.get(string) == null) {
            this.addFilter(iFileFilter);
        }
        int n = this.filterList.getList().indexOfItem(string);
        this.filterList.getList().setSelectedIndex(n);
        this.doChangeFilter();
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.lastSize.width, this.lastSize.height);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            if (this.lastLocation == null) {
                this.lastLocation = new Point(0.0, 0.0);
            }
            IRectGeom iRectGeom = this.getScreenBounds();
            this.lastLocation.x = iRectGeom.x();
            this.lastLocation.y = iRectGeom.y();
            this.lastSize.width = iRectGeom.width();
            this.lastSize.height = iRectGeom.height();
        }
        catch (Exception exception) {}
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.cancelCommand.invoke();
    }

    public void doChangeFilter() {
        String string = (String)this.filterList.getList().getSelectedItem();
        if (string != null) {
            this.model.setFilter((IFileFilter)this.filterMap.get(string));
        }
    }

    public void doActionPerformed() {
        this.getModel().chooseSelectedFiles();
    }

    void openBookmark(BBookmark bBookmark) {
        try {
            BINavNode bINavNode = (BINavNode)bBookmark.getBookmarkOrd().resolve().get();
            BSpace bSpace = BOrd.toSpace((BObject)((BObject)bINavNode));
            if (!(bSpace instanceof BFileSpace)) {
                throw new Exception("Space not instance of BFileSpace");
            }
            this.model.setSpace(bSpace);
            this.model.setDirectory(bINavNode);
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, this.lex.getText("fileChooser.error"), (Object)this.lex.getText("fileChooser.bookmarkResolveError"), exception);
        }
    }

    BBookmark makeForCurrentContext() {
        BSpace bSpace = this.model.getSpace();
        BINavNode bINavNode = this.model.getDirectory();
        String string = bINavNode.getNavDisplayName(null);
        if (bSpace instanceof BModule && bINavNode.getNavParent() == null) {
            string = ((BModule)bSpace).getModuleName();
            bSpace = BModuleSpace.INSTANCE;
            bINavNode = ((BModuleSpace)bSpace).getNavChild(string);
        }
        return new BBookmark(string, bINavNode.getNavOrd(), bINavNode.getNavIcon());
    }

    static BBookmarkFolder getFileBookmarks() {
        BBookmarkOptions bBookmarkOptions = BBookmarkOptions.make();
        BBookmarkFolder bBookmarkFolder = (BBookmarkFolder)bBookmarkOptions.getRootFolder().get("file");
        if (bBookmarkFolder == null) {
            bBookmarkFolder = new BBookmarkFolder("File");
            bBookmarkOptions.getRootFolder().add("file", (BValue)bBookmarkFolder);
        }
        return bBookmarkFolder;
    }

    public static void main(String[] stringArray) {
        BFrame bFrame = new BFrame();
        ExtFileFilter extFileFilter = new ExtFileFilter("Image files (*.gif, *.jpeg, *.png)", "gif,jpg,png");
        IFileFilter[] iFileFilterArray = new IFileFilter[]{new ExtFileFilter("Print files (*.print)", "print"), new ExtFileFilter("XML files (*.xml, *.bog)", new String[]{"xml", "bog"})};
        BFileChooser bFileChooser = BNFileChooser.makeOpen(bFrame);
        bFileChooser.addFilters(iFileFilterArray);
        BOrd[] bOrdArray = bFileChooser.show(true);
        int n = 0;
        while (n < bOrdArray.length) {
            System.out.println("  " + bOrdArray[n]);
            ++n;
        }
        System.exit(0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tempOrd = null;
        this.lex = UiLexicon.bajaui();
        this.confirmOverwrite = true;
        this.createOnSave = true;
        this.savedFileOrd = null;
        this.lastSize = new Size(630.0, 430.0);
        this.lastLocation = null;
    }

    private BNFileChooser(BWidget bWidget) {
        this(bWidget, UiLexicon.bajaui().getText("fileChooser.open"));
    }

    private BNFileChooser(BWidget bWidget, BFileSpace bFileSpace) {
        this(bWidget, bFileSpace, UiLexicon.bajaui().getText("fileChooser.open"), true);
    }

    private BNFileChooser(BWidget bWidget, String string) {
        this(bWidget, (BFileSpace)BFileSystem.INSTANCE, string, true);
    }

    private BNFileChooser(BWidget bWidget, String string, boolean bl) {
        this(bWidget, (BFileSpace)BFileSystem.INSTANCE, string, bl);
    }

    private BNFileChooser(BWidget bWidget, BFileSpace bFileSpace, String string, boolean bl) {
        super(bWidget, UiLexicon.bajaui().getText("fileChooser.title"));
        this.this();
        this.model = new FileChooserModel((BSpace)bFileSpace);
        this.model.setSupport(new FileChooserSupport(2 - bl));
        this.filename = new BTextField();
        this.filterList = new BListDropDown();
        this.listView = new BListView(this.model);
        this.preview = new BFilePreview(this.model);
        this.pathBar = new BFilePathBar(this.model);
        this.recentDirs = new BMruButton("fileChooserRecentDir");
        this.recentDirs.setMruController(new MruController());
        this.bookmarks = new BTree(new BookmarkModel());
        this.bookmarks.setController(new BookmarkController());
        this.linkTo(null, this.filename, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.filename.setEditable(bl ^ true);
        String string2 = this.lex.getText("fileChooser.allFiles") + " (*.*)";
        this.filterList.getList().addItem(string2);
        this.filterList.getList().setSelectedIndex(0);
        this.filterMap = new Hashtable();
        this.filterMap.put(string2, IFileFilter.all);
        this.linkTo(null, this.filterList, (Slot)BListDropDown.listActionPerformed, (Slot)changeFilter);
        this.confirmCommand = new ConfirmCommand(string);
        this.cancelCommand = new CancelCommand(this.lex.getText("fileChooser.cancel"));
        this.history = new Stack();
        this.history.push(new HistoryArtifact(this.model.getSpace(), this.model.getDirectory()));
        this.backCommand = new BackCommand();
        this.backCommand.setEnabled(false);
        this.upLevelCommand = new UpLevelCommand();
        boolean bl2 = false;
        if (this.model.getDirectory() != null) {
            bl2 = true;
        }
        this.upLevelCommand.setEnabled(bl2);
        this.createDirCommand = new CreateDirCommand();
        this.createDirCommand.setEnabled(this.model.getSpace() instanceof BFileSpace);
        this.homeCommand = new HomeCommand();
        this.listCommand = new ListCommand();
        this.detailsCommand = new DetailsCommand();
        this.listCommand.setSelected(true);
        this.bookmarkCommand = new BookmarkCommand();
        this.togglePreviewCommand = new TogglePreviewCommand();
        this.togglePreviewCommand.setSelected(true);
        ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
        toggleCommandGroup.add(this.listCommand);
        toggleCommandGroup.add(this.detailsCommand);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, this.backCommand);
        bToolBar.add(null, this.upLevelCommand);
        bToolBar.add(null, this.homeCommand);
        bToolBar.add(null, this.createDirCommand);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, this.listCommand);
        bToolBar.add(null, this.detailsCommand);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, (BValue)this.recentDirs);
        bToolBar.add(null, this.bookmarkCommand);
        bToolBar.add(null, this.togglePreviewCommand);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop(new BBorderPane((BWidget)this.pathBar, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setBottom(bToolBar);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setStretchColumn(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)new BLabel(this.lex.getText("fileChooser.fileName"), BHalign.left));
        bGridPane.add(null, (BValue)this.filename);
        bGridPane.add(null, (BValue)new BLabel(this.lex.getText("fileChooser.fileType"), BHalign.left));
        bGridPane.add(null, (BValue)this.filterList);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setColumnAlign(BHalign.fill);
        bGridPane2.add(null, (BValue)new BButton(this.confirmCommand));
        bGridPane2.add(null, (BValue)new BButton(this.cancelCommand));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter(new BBorderPane(bGridPane, 0.0, 10.0, 0.0, 0.0));
        bEdgePane2.setRight(bGridPane2);
        this.content = new BEdgePane();
        this.content.setTop(bEdgePane);
        this.content.setCenter(this.buildPreview());
        this.content.setBottom(new BBorderPane(bEdgePane2, 5, 0.0, 0.0, 0.0));
        BImage bImage = BImage.make((String)"module://icons/x16/computer.png");
        BImage bImage2 = BImage.make((String)"module://icons/x16/bookmark.png");
        BLabel bLabel = new BLabel(bImage, this.lex.getText("fileChooser.spaces"));
        BLabel bLabel2 = new BLabel(bImage2, this.lex.getText("fileChooser.bookmarks"));
        BToolPane bToolPane = new BToolPane();
        this.spaceList = new BFileSpaceList(this.model, bl ^ true);
        bToolPane.addPane(bLabel, (BWidget)this.spaceList);
        bToolPane.addPane(bLabel2, (BWidget)this.bookmarks);
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setDividerPosition(25.0);
        bSplitPane.setWidget1(new BBorderPane((BWidget)bToolPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bSplitPane.setWidget2(this.content);
        this.setContent(new BBorderPane(bSplitPane, 5, 5, 5, 5));
    }

    public BNFileChooser() {
        super(null, "");
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ui$file$BNFileChooser;
        if (clazz == null) {
            clazz = class$com$tridium$ui$file$BNFileChooser = BNFileChooser.class("[Lcom.tridium.ui.file.BNFileChooser;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class BookmarkModel
    extends TreeModel {
        Node[] roots;
        static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkItem;

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeNode getRoot(int n) {
            return this.roots[n];
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public BookmarkModel() {
            BBookmarkFolder bBookmarkFolder = BNFileChooser.getFileBookmarks();
            Class clazz = class$javax$baja$ui$bookmark$BBookmarkItem;
            if (clazz == null) {
                clazz = class$javax$baja$ui$bookmark$BBookmarkItem = BookmarkModel.class("[Ljavax.baja.ui.bookmark.BBookmarkItem;", false);
            }
            BBookmarkItem[] bBookmarkItemArray = (BBookmarkItem[])bBookmarkFolder.getChildren(clazz);
            this.roots = new Node[bBookmarkItemArray.length];
            int n = 0;
            while (n < bBookmarkItemArray.length) {
                this.roots[n] = new Node((TreeModel)this, bBookmarkItemArray[n]);
                ++n;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CancelCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.deselectAll();
            BNFileChooser.this.close();
            return null;
        }

        CancelCommand(String string) {
            super(BNFileChooser.this, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FileChooserSupport
    extends FileChooserModel.Support {
        static final int OPEN = 1;
        static final int SAVE = 2;
        int type;

        public void pathModified() {
            BNFileChooser.this.model.deselectAll();
            if (BNFileChooser.this.model.getDirectory() == null) {
                BNFileChooser.this.findCurrentDirectory();
            }
            UpLevelCommand upLevelCommand = BNFileChooser.this.upLevelCommand;
            boolean bl = false;
            if (BNFileChooser.this.model.getDirectory() != null) {
                bl = true;
            }
            upLevelCommand.setEnabled(bl);
            if (BNFileChooser.this.history.size() > 0) {
                BINavNode bINavNode = BNFileChooser.this.model.getDirectory();
                HistoryArtifact historyArtifact = (HistoryArtifact)BNFileChooser.this.history.peek();
                if (historyArtifact.space != BNFileChooser.this.model.getSpace()) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), bINavNode));
                } else if (historyArtifact.dir == null && bINavNode != null) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), bINavNode));
                } else if (historyArtifact.dir != null && bINavNode == null) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), bINavNode));
                } else if (historyArtifact.dir != null && bINavNode != null && !historyArtifact.dir.getNavName().equals(bINavNode.getNavName())) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), BNFileChooser.this.model.getDirectory()));
                }
            } else {
                BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), BNFileChooser.this.model.getDirectory()));
            }
            BackCommand backCommand = BNFileChooser.this.backCommand;
            boolean bl2 = false;
            if (BNFileChooser.this.history.size() > 1) {
                bl2 = true;
            }
            backCommand.setEnabled(bl2);
            BNFileChooser.this.createDirCommand.setEnabled(BNFileChooser.this.model.getSpace() instanceof BFileSpace);
            BNFileChooser.this.spaceList.relayout();
            BNFileChooser.this.listView.getSelection().deselectAll();
            BNFileChooser.this.listView.populateChildren();
            BNFileChooser.this.listView.relayout();
            BNFileChooser.this.pathBar.relayout();
        }

        public void selectionModified() {
            BIFile[] bIFileArray = BNFileChooser.this.model.getSelectedFiles();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = 0;
            while (n2 < bIFileArray.length) {
                BNFileChooser.this.listView.select(bIFileArray[n2]);
                if (!(bIFileArray[n2] instanceof BIDirectory)) {
                    if (n > 0) {
                        stringBuffer.append(";");
                    }
                    stringBuffer.append(bIFileArray[n2].getNavDisplayName(null));
                    ++n;
                }
                ++n2;
            }
            if (BNFileChooser.this.preview.isVisible()) {
                BNFileChooser.this.preview.relayout();
            }
            BookmarkCommand bookmarkCommand = BNFileChooser.this.bookmarkCommand;
            boolean bl = false;
            if (BNFileChooser.this.model.getDirectory() != null) {
                bl = true;
            }
            bookmarkCommand.setEnabled(bl);
            if (this.type == 1) {
                BNFileChooser.this.filename.setText(stringBuffer.toString());
            } else if (n > 0) {
                BNFileChooser.this.filename.setText(stringBuffer.toString());
            }
            BNFileChooser.this.filename.repaint();
        }

        /*
         * Unable to fully structure code
         */
        public void chooseSelectedFiles() {
            block18: {
                block17: {
                    block19: {
                        if (this.type != 1) break block19;
                        var1_1 = BNFileChooser.this.model.getSelectedFiles();
                        if (var1_1.length == 0) {
                            return;
                        }
                        var2_2 = 0;
                        while (var2_2 < var1_1.length) {
                            if (var1_1[var2_2] instanceof BIDirectory) {
                                BNFileChooser.this.model.setDirectory((BINavNode)var1_1[var2_2]);
                                return;
                            }
                            ++var2_2;
                        }
                        break block18;
                    }
                    if (this.type != 2) break block18;
                    var1_1 = null;
                    try {
                        var1_1 = ((BIFile)BNFileChooser.this.model.getDirectory()).getFilePath().merge(BNFileChooser.this.filename.getText());
                    }
                    catch (Exception var2_3) {
                        BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.noDirectoryError"), var2_3);
                        return;
                    }
                    if (!BNFileChooser.this.confirmOverwrite) ** GOTO lbl-1000
                    BOrd.make((OrdQuery)var1_1).resolve((BObject)BNFileChooser.this.model.getSpace()).get();
                    if (4 == BDialog.open(BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.fileExists"), BNFileChooser.this.lex.getText("fileChooser.fileExistsPrompt"), 14, BDialog.WARNING_ICON)) break block17;
                    return;
                }
                try {
                    ** GOTO lbl-1000
                }
                catch (UnresolvedException v0) {
                    try lbl-1000:
                    // 3 sources

                    {
                        if (BNFileChooser.this.createOnSave) {
                            var2_4 = null;
                            try {
                                var2_4 = ((BFileSpace)BNFileChooser.this.model.getSpace()).makeFile((FilePath)var1_1);
                            }
                            catch (Exception var3_6) {
                                BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.cannotCreateFile"), var3_6);
                                return;
                            }
                            BNFileChooser.this.model.deselectAll();
                            BNFileChooser.this.model.select(var2_4);
                            break block18;
                        }
                        BNFileChooser.this.savedFileOrd = BOrd.make((BOrd)BNFileChooser.this.model.getSpace().getNavOrd(), (OrdQuery)var1_1).normalize();
                    }
                    catch (Exception var2_5) {
                        var2_5.printStackTrace();
                    }
                }
            }
            if (BNFileChooser.this.createOnSave) {
                var1_1 = BNFileChooser.this.model.getSelectedFiles();
                if (var1_1.length > 0) {
                    BNFileChooser.this.recentDirs.getMruOptions().save(var1_1[0].getNavParent().getNavOrd().toString());
                }
            } else {
                BNFileChooser.this.recentDirs.getMruOptions().save(BNFileChooser.this.model.getDirectory().getNavOrd().toString());
            }
            BNFileChooser.this.close();
        }

        public FileChooserSupport(int n) {
            this.type = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MruController
    extends BMruButton.MruController {
        public void select(String string) {
            try {
                BIFile bIFile = (BIFile)BOrd.make((String)string).resolve().get();
                BNFileChooser.this.setCurrentSpace((BSpace)bIFile.getFileSpace());
                BNFileChooser.this.setCurrentNavDirectory((BINavNode)bIFile);
            }
            catch (Exception exception) {
                BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.noDirectoryError"), exception);
            }
        }

        MruController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BookmarkController
    extends TreeController {
        protected void doSelectAction(TreeNode treeNode, double d, double d2) {
            Node node = (Node)treeNode;
            if (node.item instanceof BBookmark) {
                BNFileChooser.this.openBookmark((BBookmark)node.item);
            }
        }

        BookmarkController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ConfirmCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.chooseSelectedFiles();
            return null;
        }

        ConfirmCommand(String string) {
            super(BNFileChooser.this, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HistoryArtifact {
        BSpace space;
        BINavNode dir;

        HistoryArtifact(BSpace bSpace, BINavNode bINavNode) {
            this.space = bSpace;
            this.dir = bINavNode;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BackCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.history.pop();
            HistoryArtifact historyArtifact = (HistoryArtifact)BNFileChooser.this.history.pop();
            BNFileChooser.this.model.setSpace(historyArtifact.space);
            BNFileChooser.this.model.setDirectory(historyArtifact.dir);
            return null;
        }

        BackCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.back");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UpLevelCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.moveUpDirectory();
            return null;
        }

        UpLevelCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.upLevel");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CreateDirCommand
    extends Command {
        public CommandArtifact doInvoke() {
            String string = BNFileChooser.this.lex.getText("fileChooser.title");
            try {
                BFileSpace bFileSpace = (BFileSpace)BNFileChooser.this.model.getSpace();
                BIFile bIFile = (BIFile)BNFileChooser.this.model.getDirectory();
                String string2 = BNFileChooser.this.lex.getText("fileChooser.newFolder");
                string2 = BDialog.prompt(BNFileChooser.this, string, string2, 20);
                if (string2 != null) {
                    BDirectory bDirectory = bFileSpace.makeDir(bIFile.getFilePath().merge(string2));
                    BNFileChooser.this.model.setDirectory((BINavNode)bDirectory);
                }
            }
            catch (Exception exception) {
                BDialog.error((BWidget)BNFileChooser.this, string, (Object)BNFileChooser.this.lex.getText("fileChooser.createDirFailed"), exception);
            }
            return null;
        }

        CreateDirCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.createDir");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HomeCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.setSpace((BSpace)BFileSystem.INSTANCE);
            BNFileChooser.this.model.setDirectory((BINavNode)BFileSystem.INSTANCE.findFile(new FilePath("!")));
            return null;
        }

        HomeCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.home");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ListCommand
    extends ToggleCommand {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.listView.setListView();
            return null;
        }

        ListCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.list");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DetailsCommand
    extends ToggleCommand {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.listView.setDetailsView();
            return null;
        }

        DetailsCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.details");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BookmarkCommand
    extends Command {
        public CommandArtifact doInvoke() {
            Object object;
            try {
                object = BNFileChooser.this.makeForCurrentContext();
                BNFileChooser.getFileBookmarks().add(null, (BValue)object);
                BBookmarkOptions.make().save();
                BNFileChooser.this.bookmarks.setModel(new BookmarkModel());
                BNFileChooser.this.bookmarks.relayout();
            }
            catch (Exception exception) {
                BDialog.error(this.getOwner(), "Error", (Object)"Add failed", exception);
                return null;
            }
            try {
                object = Sys.loadClass((String)"workbench", (String)"com.tridium.workbench.bookmark.BookmarkEvents");
                Object t = ((Class)object).newInstance();
                Method method = ((Class)object).getDeclaredMethod("fireBookmarkChanged", null);
                method.invoke(t, null);
            }
            catch (Exception exception) {}
            return null;
        }

        BookmarkCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.bookmarks");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TogglePreviewCommand
    extends ToggleCommand {
        public CommandArtifact doInvoke() {
            BBorderPane bBorderPane = (BBorderPane)BNFileChooser.this.listView.getParentWidget();
            if (bBorderPane != null) {
                bBorderPane.setContent(new BNullWidget());
            }
            if ((bBorderPane = (BBorderPane)BNFileChooser.this.preview.getParentWidget()) != null) {
                bBorderPane.setContent(new BNullWidget());
            }
            BNFileChooser.this.content.setCenter(this.isSelected() ? BNFileChooser.this.buildPreview() : BNFileChooser.this.buildNoPreview());
            BNFileChooser.this.content.relayout();
            return null;
        }

        TogglePreviewCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.togglePreview");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Node
    extends TreeNode {
        BBookmarkItem item;
        Node[] kids;
        static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkItem;

        public void load() {
            Class clazz = class$javax$baja$ui$bookmark$BBookmarkItem;
            if (clazz == null) {
                clazz = class$javax$baja$ui$bookmark$BBookmarkItem = Node.class("[Ljavax.baja.ui.bookmark.BBookmarkItem;", false);
            }
            BBookmarkItem[] bBookmarkItemArray = (BBookmarkItem[])this.item.getChildren(clazz);
            this.kids = new Node[bBookmarkItemArray.length];
            int n = 0;
            while (n < bBookmarkItemArray.length) {
                this.kids[n] = new Node(this, bBookmarkItemArray[n]);
                ++n;
            }
        }

        public String getText() {
            return this.item.getText();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.item.getIcon());
        }

        public Object getSubject() {
            return this.item;
        }

        public int getChildCount() {
            return this.kids.length;
        }

        public TreeNode getChild(int n) {
            return this.kids[n];
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public Node(TreeModel treeModel, BBookmarkItem bBookmarkItem) {
            super(treeModel);
            this.item = bBookmarkItem;
            this.load();
        }

        public Node(TreeNode treeNode, BBookmarkItem bBookmarkItem) {
            super(treeNode);
            this.item = bBookmarkItem;
            this.load();
        }
    }
}

