/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.BFileSpaceList;
import com.tridium.ui.file.BNFileChooser;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import java.io.File;
import java.lang.reflect.Method;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNDirectoryChooser
extends BDirectoryChooser {
    public static final Type TYPE;
    final UiLexicon lex;
    FileChooserModel model;
    BTreeView treeView;
    BTree bookmarks;
    BFileSpaceList spaceList;
    BToolPane toolPane;
    BSplitPane split;
    BLabelPane spaceListPane;
    BLabelPane bookmarksPane;
    ConfirmCommand confirmCommand;
    CancelCommand cancelCommand;
    CreateDirCommand createDirCommand;
    BookmarkCommand bookmarkCommand;
    Point lastLocation;
    Size lastSize;
    static /* synthetic */ Class class$com$tridium$ui$file$BNDirectoryChooser;

    public Type getType() {
        return TYPE;
    }

    public BOrd show() {
        this.bookmarks.setModel(new BNFileChooser.BookmarkModel());
        this.bookmarks.relayout();
        this.model.setDirectory(this.model.getDirectory());
        if (this.lastLocation == null) {
            this.setBoundsCenteredOnOwner();
        } else {
            this.setScreenBounds(this.lastLocation.x, this.lastLocation.y, this.lastSize.width, this.lastSize.height);
        }
        if (!this.getSpaceListVisible() && !this.getBookmarksVisible()) {
            this.split.setDividerPosition(0.0);
        }
        this.bookmarkCommand.setEnabled(this.getBookmarksVisible());
        this.treeView.getSelection().updateTree();
        this.open();
        BIFile[] bIFileArray = this.model.getSelectedFiles();
        return bIFileArray.length == 0 ? null : bIFileArray[0].getNavOrd();
    }

    public BOrd getCurrentDirectory() {
        return this.model.getDirectory().getNavOrd();
    }

    public void setCurrentDirectory(BOrd bOrd) {
        if (bOrd.isNull()) {
            return;
        }
        BINavNode bINavNode = (BINavNode)bOrd.resolve().get();
        this.model.setSpace(BOrd.toSpace((BObject)((BObject)bINavNode)));
        if (bINavNode instanceof BIFile) {
            this.model.setDirectory(bINavNode);
            this.model.select((BIFile)bINavNode);
        } else {
            this.model.setDirectory(bINavNode);
        }
    }

    public BSpace[] getSpaces() {
        return this.spaceList.getSpaces();
    }

    public void setSpaces(BSpace[] bSpaceArray) {
        this.spaceList.setSpaces(bSpaceArray);
    }

    public FileChooserModel getModel() {
        return this.model;
    }

    public BSpace getCurrentSpace() {
        return this.model.getSpace();
    }

    public void setCurrentSpace(BSpace bSpace) {
        this.model.setSpace(bSpace);
    }

    public BINavNode getCurrentNavDirectory() {
        return this.model.getDirectory();
    }

    public void setCurrentNavDirectory(BINavNode bINavNode) {
        this.model.setDirectory(bINavNode);
    }

    public void setCurrentDirectory(File file) {
        BIFile bIFile = (BIFile)BFileSystem.INSTANCE.localFileToOrd(file).get();
        this.model.setDirectory((BINavNode)bIFile);
    }

    public boolean getSpaceListVisible() {
        boolean bl = false;
        if (this.toolPane.get("spaceList") != null) {
            bl = true;
        }
        return bl;
    }

    public void setSpaceListVisible(boolean bl) {
        if (bl && this.toolPane.get("spaceList") == null) {
            this.toolPane.add("spaceList", (BValue)this.spaceListPane);
        } else if (!bl && this.toolPane.get("spaceList") != null) {
            this.toolPane.remove("spaceList");
        }
        this.toolPane.relayout();
    }

    public boolean getBookmarksVisible() {
        boolean bl = false;
        if (this.toolPane.get("bookmarks") != null) {
            bl = true;
        }
        return bl;
    }

    public void setBookmarksVisible(boolean bl) {
        if (bl && this.toolPane.get("bookmarks") == null) {
            this.toolPane.add("bookmarks", (BValue)this.bookmarksPane);
        } else if (!bl && this.toolPane.get("bookmarks") != null) {
            this.toolPane.remove("bookmarks");
        }
        this.toolPane.relayout();
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.lastSize.width, this.lastSize.height);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.lastSize.width = this.getWidth();
        this.lastSize.height = this.getHeight();
        try {
            this.lastLocation = this.translateToScreen(new Point(0.0, 0.0));
        }
        catch (Exception exception) {}
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.cancelCommand.invoke();
    }

    void openBookmark(BBookmark bBookmark) {
        try {
            BINavNode bINavNode = (BINavNode)bBookmark.getBookmarkOrd().resolve().get();
            BSpace bSpace = BOrd.toSpace((BObject)((BObject)bINavNode));
            if (!(bSpace instanceof BFileSpace)) {
                throw new Exception("Space not instance of BFileSpace");
            }
            this.model.setSpace(bSpace);
            this.model.setDirectory(bINavNode);
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, this.lex.getText("fileChooser.error"), (Object)this.lex.getText("fileChooser.bookmarkResolveError"), exception);
        }
    }

    BBookmark makeForCurrentContext() {
        BSpace bSpace = this.model.getSpace();
        BINavNode bINavNode = this.model.getDirectory();
        String string = bINavNode.getNavDisplayName(null);
        if (bSpace instanceof BModule && bINavNode.getNavParent() == null) {
            string = ((BModule)bSpace).getModuleName();
            bSpace = BModuleSpace.INSTANCE;
            bINavNode = ((BModuleSpace)bSpace).getNavChild(string);
        }
        return new BBookmark(string, bINavNode.getNavOrd(), bINavNode.getNavIcon());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lex = UiLexicon.bajaui();
        this.lastSize = new Size(450.0, 430.0);
    }

    public BNDirectoryChooser(BWidget bWidget) {
        this(bWidget, UiLexicon.bajaui().getText("dirChooser.confirm"));
    }

    public BNDirectoryChooser(BWidget bWidget, BFileSpace bFileSpace) {
        this(bWidget, bFileSpace, UiLexicon.bajaui().getText("dirChooser.confirm"));
    }

    public BNDirectoryChooser(BWidget bWidget, String string) {
        this(bWidget, (BFileSpace)BFileSystem.INSTANCE, string);
    }

    public BNDirectoryChooser(BWidget bWidget, BFileSpace bFileSpace, String string) {
        super(bWidget, UiLexicon.bajaui().getText("dirChooser.title"));
        this.this();
        this.model = new FileChooserModel((BSpace)bFileSpace);
        this.model.setSupport(new DirChooserSupport());
        this.treeView = new BTreeView(this.model);
        this.treeView.setSelector(true);
        this.treeView.setSelection(new Selection());
        this.spaceList = new BFileSpaceList(this.model);
        this.bookmarks = new BTree(new BNFileChooser.BookmarkModel());
        this.bookmarks.setController(new BookmarkController());
        this.confirmCommand = new ConfirmCommand(string);
        this.cancelCommand = new CancelCommand(this.lex.getText("fileChooser.cancel"));
        this.createDirCommand = new CreateDirCommand();
        boolean bl = false;
        if (this.model.getSpace() instanceof BFileSpace && this.model.getDirectory() instanceof BIFile) {
            bl = true;
        }
        this.createDirCommand.setEnabled(bl);
        this.bookmarkCommand = new BookmarkCommand();
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, this.createDirCommand);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, this.bookmarkCommand);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add(null, (BValue)new BButton(this.confirmCommand));
        bGridPane.add(null, (BValue)new BButton(this.cancelCommand));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop(bToolBar);
        bEdgePane.setCenter(new BBorderPane((BWidget)new BScrollPane(this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setBottom(new BBorderPane(bGridPane, 5, 0.0, 0.0, 0.0));
        BImage bImage = BImage.make((String)"module://icons/x16/computer.png");
        BImage bImage2 = BImage.make((String)"module://icons/x16/bookmark.png");
        BLabel bLabel = new BLabel(bImage, this.lex.getText("fileChooser.spaces"));
        BLabel bLabel2 = new BLabel(bImage2, this.lex.getText("fileChooser.bookmarks"));
        this.spaceListPane = new BLabelPane(bLabel, (BWidget)this.spaceList);
        this.bookmarksPane = new BLabelPane(bLabel2, (BWidget)this.bookmarks);
        this.toolPane = new BToolPane();
        this.toolPane.add("spaceList", (BValue)this.spaceListPane);
        this.toolPane.add("bookmarks", (BValue)this.bookmarksPane);
        this.split = new BSplitPane();
        this.split.setDividerPosition(40.0);
        this.split.setWidget1(new BBorderPane((BWidget)this.toolPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.split.setWidget2(bEdgePane);
        this.setContent(new BBorderPane(this.split, 5, 5, 5, 5));
    }

    public BNDirectoryChooser() {
        super(null, "");
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ui$file$BNDirectoryChooser;
        if (clazz == null) {
            clazz = class$com$tridium$ui$file$BNDirectoryChooser = BNDirectoryChooser.class("[Lcom.tridium.ui.file.BNDirectoryChooser;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BookmarkCommand
    extends Command {
        public CommandArtifact doInvoke() {
            Object object;
            try {
                object = BNDirectoryChooser.this.makeForCurrentContext();
                BNFileChooser.getFileBookmarks().add(null, (BValue)object);
                BBookmarkOptions.make().save();
                BNDirectoryChooser.this.bookmarks.setModel(new BNFileChooser.BookmarkModel());
                BNDirectoryChooser.this.bookmarks.relayout();
            }
            catch (Exception exception) {
                BDialog.error(this.getOwner(), "Error", (Object)"Add failed", exception);
                return null;
            }
            try {
                object = Sys.loadClass((String)"workbench", (String)"com.tridium.workbench.bookmark.BookmarkEvents");
                Object t = ((Class)object).newInstance();
                Method method = ((Class)object).getDeclaredMethod("fireBookmarkChanged", null);
                method.invoke(t, null);
            }
            catch (Exception exception) {}
            return null;
        }

        BookmarkCommand() {
            super((BWidget)BNDirectoryChooser.this, BNDirectoryChooser.this.lex.module, "fileChooser.bookmarks");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CancelCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNDirectoryChooser.this.model.deselectAll();
            BNDirectoryChooser.this.close();
            return null;
        }

        CancelCommand(String string) {
            super(BNDirectoryChooser.this, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DirChooserSupport
    extends FileChooserModel.Support {
        public void pathModified() {
            BNDirectoryChooser.this.treeView.scrollToVisible(BNDirectoryChooser.this.model.getDirectory());
            TreeNode treeNode = BNDirectoryChooser.this.treeView.getSelection().getNode();
            if (treeNode != null && treeNode.getSubject() != BNDirectoryChooser.this.model.getDirectory() && treeNode.getSubject() != BNDirectoryChooser.this.model.getSpace()) {
                BNDirectoryChooser.this.treeView.getSelection().deselectAll();
            }
            CreateDirCommand createDirCommand = BNDirectoryChooser.this.createDirCommand;
            boolean bl = false;
            if (BNDirectoryChooser.this.model.getSpace() instanceof BFileSpace && BNDirectoryChooser.this.model.getDirectory() instanceof BIFile) {
                bl = true;
            }
            createDirCommand.setEnabled(bl);
            BNDirectoryChooser.this.spaceList.relayout();
        }

        public void selectionModified() {
            BIFile[] bIFileArray = BNDirectoryChooser.this.model.getSelectedFiles();
            if (bIFileArray.length > 0) {
                BNDirectoryChooser.this.model.setDirectory((BINavNode)bIFileArray[0]);
            }
        }

        public void chooseSelectedFiles() {
            BIFile[] bIFileArray = BNDirectoryChooser.this.model.getSelectedFiles();
            if (bIFileArray.length == 0) {
                return;
            }
            BNDirectoryChooser.this.close();
        }

        DirChooserSupport() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Selection
    extends TreeSelection {
        public void updateTree() {
            super.updateTree();
            boolean bl = false;
            if (this.getNode() != null) {
                bl = true;
            }
            boolean bl2 = bl;
            CreateDirCommand createDirCommand = BNDirectoryChooser.this.createDirCommand;
            boolean bl3 = false;
            if (bl2 && BNDirectoryChooser.this.model.getSpace() instanceof BFileSpace && BNDirectoryChooser.this.model.getDirectory() instanceof BIFile) {
                bl3 = true;
            }
            createDirCommand.setEnabled(bl3);
            BookmarkCommand bookmarkCommand = BNDirectoryChooser.this.bookmarkCommand;
            boolean bl4 = false;
            if (bl2 && BNDirectoryChooser.this.getBookmarksVisible()) {
                bl4 = true;
            }
            bookmarkCommand.setEnabled(bl4);
        }

        Selection() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BookmarkController
    extends TreeController {
        protected void doSelectAction(TreeNode treeNode, double d, double d2) {
            BNFileChooser.Node node = (BNFileChooser.Node)treeNode;
            if (node.item instanceof BBookmark) {
                BNDirectoryChooser.this.openBookmark((BBookmark)node.item);
            }
        }

        BookmarkController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ConfirmCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNDirectoryChooser.this.model.chooseSelectedFiles();
            return null;
        }

        ConfirmCommand(String string) {
            super(BNDirectoryChooser.this, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CreateDirCommand
    extends Command {
        public CommandArtifact doInvoke() {
            String string = BNDirectoryChooser.this.lex.getText("fileChooser.title");
            try {
                BFileSpace bFileSpace = (BFileSpace)BNDirectoryChooser.this.model.getSpace();
                BIFile bIFile = (BIFile)BNDirectoryChooser.this.model.getDirectory();
                String string2 = BNDirectoryChooser.this.lex.getText("fileChooser.newFolder");
                string2 = BDialog.prompt(BNDirectoryChooser.this, string, string2, 20);
                if (string2 != null) {
                    BDirectory bDirectory = bFileSpace.makeDir(bIFile.getFilePath().merge(string2));
                    TreeNode treeNode = BNDirectoryChooser.this.treeView.getSelection().getNode();
                    if (treeNode instanceof BTreeView.Root) {
                        ((BTreeView.Root)treeNode).kids = null;
                    } else {
                        ((BTreeView.Node)treeNode).kids = null;
                    }
                    BNDirectoryChooser.this.treeView.relayout();
                }
            }
            catch (Exception exception) {
                BDialog.error((BWidget)BNDirectoryChooser.this, string, (Object)BNDirectoryChooser.this.lex.getText("fileChooser.createDirFailed"), exception);
            }
            return null;
        }

        CreateDirCommand() {
            super((BWidget)BNDirectoryChooser.this, BNDirectoryChooser.this.lex.module, "fileChooser.createDir");
        }
    }
}

