/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.sys.module.BModuleNavNode;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.file.FileChooserModel;
import java.util.ArrayList;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BListView
extends BTable {
    public static final Type TYPE;
    FileChooserModel fileModel;
    ListModel model;
    boolean showDirs;
    boolean showFiles;
    static /* synthetic */ Class class$com$tridium$ui$file$BListView;

    public Type getType() {
        return TYPE;
    }

    public boolean getShowDirectories() {
        return this.showDirs;
    }

    public void setShowDirectories(boolean bl) {
        this.showDirs = bl;
    }

    public boolean getShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean bl) {
        this.showFiles = bl;
    }

    public void populateChildren() {
        BINavNode[] bINavNodeArray = this.fileModel.getChildren();
        this.model.kids = this.sort(this.filter(bINavNodeArray));
    }

    private final BINavNode[] filter(BINavNode[] bINavNodeArray) {
        if (!(this.fileModel.getSpace() instanceof BFileSpace)) {
            return bINavNodeArray;
        }
        ArrayList<BIFile> arrayList = new ArrayList<BIFile>();
        int n = 0;
        while (n < bINavNodeArray.length) {
            BIFile bIFile = (BIFile)bINavNodeArray[n];
            if (this.showDirs && bIFile instanceof BIDirectory || this.showFiles && !(bIFile instanceof BIDirectory)) {
                arrayList.add(bIFile);
            }
            ++n;
        }
        BIFile[] bIFileArray = new BIFile[arrayList.size()];
        return (BINavNode[])arrayList.toArray(bIFileArray);
    }

    private final BINavNode[] sort(BINavNode[] bINavNodeArray) {
        if (!this.showDirs || !this.showFiles) {
            return bINavNodeArray;
        }
        int n = 1;
        while (n < bINavNodeArray.length) {
            if (bINavNodeArray[n] instanceof BIDirectory) {
                int n2 = n;
                while (n2 > 0 && !(bINavNodeArray[n2 - 1] instanceof BIDirectory)) {
                    BINavNode bINavNode = bINavNodeArray[n2 - 1];
                    bINavNodeArray[n2 - 1] = bINavNodeArray[n2];
                    bINavNodeArray[n2] = bINavNode;
                    --n2;
                }
            }
            ++n;
        }
        return bINavNodeArray;
    }

    public void select(BIFile bIFile) {
        int n = 0;
        while (n < this.model.kids.length) {
            if (bIFile.getNavName().equals(this.model.kids[n].getNavName())) {
                if (this.getSelection().isSelected(n)) break;
                this.getSelection().select(n);
                break;
            }
            ++n;
        }
    }

    public void setListView() {
        this.model = new ListModel();
        this.setModel(this.model);
        this.setHeaderVisible(false);
        this.populateChildren();
    }

    public void setDetailsView() {
        this.model = new DetailsModel();
        this.setModel(this.model);
        this.setHeaderVisible(true);
        this.populateChildren();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BListView(FileChooserModel fileChooserModel) {
        this.model = new ListModel();
        this.fileModel = fileChooserModel;
        this.setShowDirectories(true);
        this.setShowFiles(true);
        this.populateChildren();
        this.setModel(this.model);
        this.setController(new Controller());
        this.setSelection(new Selection());
        this.setHeaderVisible(false);
        this.setHgridVisible(false);
        this.setVgridVisible(false);
    }

    public BListView() {
    }

    static {
        Class clazz = class$com$tridium$ui$file$BListView;
        if (clazz == null) {
            clazz = class$com$tridium$ui$file$BListView = BListView.class("[Lcom.tridium.ui.file.BListView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ListModel
    extends TableModel {
        BINavNode[] kids;

        public int getRowCount() {
            return this.kids.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            return this.kids[n].getNavDisplayName(null);
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)this.kids[n].getNavIcon());
        }

        public Object getSubject(int n) {
            return this.kids[n];
        }

        public BINavNode get(int n) {
            return this.kids[n];
        }

        ListModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DetailsModel
    extends ListModel {
        public int getColumnCount() {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                return 3;
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                return 4;
            }
            return 1;
        }

        public String getColumnName(int n) {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                switch (n) {
                    case 0: {
                        return UiLexicon.bajaui().getText("fileChooser.name");
                    }
                    case 1: {
                        return UiLexicon.bajaui().getText("fileChooser.size");
                    }
                    case 2: {
                        return UiLexicon.bajaui().getText("fileChooser.lastModified");
                    }
                }
                return "";
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                switch (n) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Vender";
                    }
                    case 2: {
                        return "Version";
                    }
                    case 3: {
                        return "Description";
                    }
                }
                return "";
            }
            return UiLexicon.bajaui().getText("fileChooser.name");
        }

        public Object getValueAt(int n, int n2) {
            if (this.kids[n] instanceof BIFile) {
                return this.getFileDetail(n, n2);
            }
            if (this.kids[n] instanceof BModuleNavNode) {
                return this.getModuleDetail(n, n2);
            }
            return super.getValueAt(n, n2);
        }

        private final Object getFileDetail(int n, int n2) {
            BIFile bIFile = (BIFile)this.kids[n];
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    if (bIFile instanceof BIDirectory) {
                        return "";
                    }
                    long l = bIFile.getSize();
                    String string = l < 1024L ? "1 KB" : String.valueOf(l / 1024L) + " KB";
                    return string;
                }
                case 2: {
                    if (bIFile.getLastModified().getMillis() == 0L) {
                        return "";
                    }
                    return String.valueOf(bIFile.getLastModified());
                }
            }
            return null;
        }

        private final Object getModuleDetail(int n, int n2) {
            BModuleNavNode bModuleNavNode = (BModuleNavNode)this.kids[n];
            NModuleInfo nModuleInfo = bModuleNavNode.info;
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    return nModuleInfo.getVendor();
                }
                case 2: {
                    return nModuleInfo.getVendorVersion();
                }
                case 3: {
                    return nModuleInfo.getDescription();
                }
            }
            return null;
        }

        DetailsModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TableController {
        public void handleEnter(BKeyEvent bKeyEvent) {
            int n = this.getTable().getSelection().getRow();
            if (n >= 0) {
                this.handleSelection(BListView.this.model.kids[n]);
            }
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            this.handleSelection(BListView.this.model.kids[n]);
        }

        void handleSelection(BINavNode bINavNode) {
            if (bINavNode instanceof BIDirectory || bINavNode instanceof BNavContainer) {
                BListView.this.fileModel.setDirectory(bINavNode);
            } else {
                BListView.this.fileModel.chooseSelectedFiles();
            }
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            super.keyPressed(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 38 && bKeyEvent.isAltDown()) {
                BListView.this.fileModel.moveUpDirectory();
            }
        }

        public int getTextSearchColumn() {
            return 0;
        }

        Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Selection
    extends TableSelection {
        public void select(int n, boolean bl) {
            super.select(n, bl);
            if (bl) {
                BListView.this.fileModel.deselectAll();
            }
            if (n < BListView.this.model.getRowCount()) {
                this.handleSelect(n);
            }
        }

        public void select(int n, int n2, boolean bl) {
            int n3;
            int n4;
            int n5;
            super.select(n, n2, bl);
            if (bl) {
                BListView.this.fileModel.deselectAll();
            }
            if ((n5 = n2) < (n4 = n)) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
            n3 = n4;
            while (n3 <= n5) {
                this.handleSelect(n3);
                ++n3;
            }
        }

        public void select(int[] nArray) {
            super.select(nArray);
            int n = 0;
            while (n < nArray.length) {
                this.handleSelect(n);
                ++n;
            }
        }

        public void deselect(int n) {
            super.deselect(n);
            BINavNode bINavNode = BListView.this.model.get(n);
            if (bINavNode instanceof BIFile) {
                BListView.this.fileModel.deselect((BIFile)bINavNode);
            }
        }

        public void deselectAll() {
            super.deselectAll();
            BListView.this.fileModel.deselectAll();
        }

        private final void handleSelect(int n) {
            BINavNode bINavNode = BListView.this.model.get(n);
            if (bINavNode instanceof BIFile) {
                BListView.this.fileModel.select((BIFile)bINavNode);
            }
        }

        Selection() {
        }
    }
}

