/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.FileChooserModel;
import com.tridium.ui.theme.Theme;
import javax.baja.file.FilePath;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFilePathBar
extends BWidget {
    public static final Type TYPE;
    static BInsets insets;
    static final char separatorChar = '/';
    FileChooserModel model;
    RectGeom[] bounds;
    int buttonSize;
    RectGeom leftButton;
    RectGeom rightButton;
    boolean leftButtonEnabled;
    boolean rightButtonEnabled;
    int offset;
    int armed;
    int pressed;
    MouseCursor origCursor;
    static /* synthetic */ Class class$com$tridium$ui$file$BFilePathBar;

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        BFont bFont = Theme.widget().getTextFont();
        int n = 200;
        double d = (bFont.getHeight() + BFilePathBar.insets.top + BFilePathBar.insets.bottom) * (double)2;
        this.setPreferredSize(n, d);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        BSpace bSpace = this.model.getSpace();
        BINavNode[] bINavNodeArray = this.model.getPath();
        this.bounds = new RectGeom[bINavNodeArray.length];
        BFont bFont = Theme.widget().getTextFont();
        double d = BFilePathBar.insets.left;
        double d2 = bFont.getHeight() + BFilePathBar.insets.top * (double)2 + BFilePathBar.insets.bottom;
        int n = this.offset;
        while (n < bINavNodeArray.length) {
            String string = "";
            if (n > 0) {
                string = string + ' ';
                if (!this.isLeadingChar(bINavNodeArray[n - 1].getNavName())) {
                    string = string + "/ ";
                }
            }
            if (n == 0 && (this.model.getSpace() instanceof BModuleSpace || this.model.getSpace() instanceof BModule)) {
                OrdQuery[] ordQueryArray = this.model.getDirectory().getNavOrd().parse();
                BModule bModule = Sys.loadModule((String)((FilePath)ordQueryArray[ordQueryArray.length - 1]).getAuthority());
                string = string + bModule.getModuleName();
            } else {
                string = string + bINavNodeArray[n].getNavName();
            }
            this.bounds[n] = new RectGeom(d, d2, bFont.width(string), bFont.getHeight());
            d += this.bounds[n].width;
            ++n;
        }
    }

    private final boolean isLeadingChar(String string) {
        boolean bl = false;
        if (string.equals("!") || string.equals("^")) {
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics graphics) {
        graphics.setBrush(Theme.widget().getWindowBackground());
        graphics.fillRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
        BINavNode[] bINavNodeArray = this.model.getPath();
        BFont bFont = Theme.widget().getBoldText();
        double d = bFont.getAscent();
        double d2 = 0.0;
        double d3 = bFont.getHeight() + BFilePathBar.insets.top * (double)2 + BFilePathBar.insets.bottom;
        graphics.setFont(bFont);
        graphics.setBrush(Theme.pathBar().getControlBackground());
        graphics.fillRect(0.0, 0.0, this.getWidth() - 1.0, d3 - BFilePathBar.insets.bottom);
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, d3 - BFilePathBar.insets.bottom, this.getWidth() - 1.0, d3 - BFilePathBar.insets.bottom);
        graphics.setBrush(BColor.white);
        graphics.drawString(UiLexicon.bajaui().getText("fileChooser.currentPath"), BFilePathBar.insets.left, BFilePathBar.insets.top + bFont.getAscent());
        bFont = Theme.widget().getTextFont();
        graphics.setFont(bFont);
        int n = this.offset;
        while (n < this.bounds.length) {
            String string = "";
            if (n > 0) {
                string = string + ' ';
                if (!this.isLeadingChar(bINavNodeArray[n - 1].getNavName())) {
                    string = string + "/ ";
                }
            }
            String string2 = bINavNodeArray[n].getNavName();
            if (n == 0 && (this.model.getSpace() instanceof BModuleSpace || this.model.getSpace() instanceof BModule)) {
                OrdQuery[] ordQueryArray = this.model.getDirectory().getNavOrd().parse();
                BModule bModule = Sys.loadModule((String)((FilePath)ordQueryArray[ordQueryArray.length - 1]).getAuthority());
                string2 = bModule.getModuleName();
            }
            double d4 = d2 + this.bounds[n].x;
            double d5 = d3 + d;
            graphics.setBrush(BColor.black);
            graphics.drawString(string, d4, d5);
            if (this.armed == n) {
                graphics.setBrush(BColor.blue);
            }
            graphics.drawString(string2, d4 += bFont.width(string), d5);
            if (this.armed == n) {
                graphics.strokeLine(d4, d5 + 1.0, d4 + bFont.width(string2) - 1.0, d5 + 1.0);
            }
            ++n;
        }
        if (this.leftButtonEnabled) {
            this.paintLeftButton(graphics);
        }
        if (this.rightButtonEnabled) {
            this.paintRightButton(graphics);
        }
        graphics.setBrush(BColor.black);
        graphics.strokeRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
    }

    public void paintLeftButton(Graphics graphics) {
        graphics.setBrush(BColor.white);
        graphics.translate(this.leftButton.x, this.leftButton.y);
        int n = 4;
        double d = this.leftButton.height / (double)2;
        double d2 = (this.leftButton.width - (double)n) / (double)2;
        graphics.strokeLine(d2, d, d2 + (double)n, d);
        int n2 = 1;
        while (n2 <= n) {
            graphics.strokeLine(d2 + (double)n2, d - (double)n2, d2 + (double)n, d - (double)n2);
            ++n2;
        }
        n2 = 1;
        while (n2 <= n) {
            graphics.strokeLine(d2 + (double)n2, d + (double)n2, d2 + (double)n, d + (double)n2);
            ++n2;
        }
        graphics.translate(-this.leftButton.x, -this.leftButton.y);
    }

    public void paintRightButton(Graphics graphics) {
        graphics.setBrush(BColor.white);
        graphics.translate(this.rightButton.x, this.rightButton.y);
        double d = this.rightButton.height / (double)2;
        double d2 = 4;
        double d3 = (this.rightButton.width - d2) / (double)2;
        graphics.strokeLine(d3, d, d3 + d2, d);
        int n = 1;
        while ((double)n <= d2) {
            graphics.strokeLine(d3, d - (double)n, d3 + d2 - (double)n, d - (double)n);
            ++n;
        }
        n = 1;
        while ((double)n <= d2) {
            graphics.strokeLine(d3, d + (double)n, d3 + d2 - (double)n, d + (double)n);
            ++n;
        }
        graphics.translate(-this.rightButton.x, -this.rightButton.y);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        int n = this.armed;
        int n2 = this.offset;
        while (n2 < this.bounds.length) {
            if (this.bounds[n2] != null && this.bounds[n2].contains(bMouseEvent.getX(), bMouseEvent.getY())) {
                if (this.origCursor == null) {
                    this.origCursor = this.getMouseCursor();
                    this.setMouseCursor(MouseCursor.hand);
                }
                this.armed = this.pressed != -1 ? (this.pressed == n2 ? n2 : -1) : n2;
                this.repaint();
                return;
            }
            ++n2;
        }
        this.setMouseCursor(this.origCursor);
        this.origCursor = null;
        this.armed = -1;
        if (n != this.armed) {
            this.repaint();
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.mouseMoved(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.mouseMoved(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.mouseMoved(bMouseEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.leftButtonEnabled && this.leftButton.contains(bMouseEvent.getX(), bMouseEvent.getY())) {
            --this.offset;
            if (this.offset < 0) {
                this.offset = 0;
            }
            this.relayout();
        } else if (this.rightButtonEnabled && this.rightButton.contains(bMouseEvent.getX(), bMouseEvent.getY())) {
            ++this.offset;
            if (this.offset > this.bounds.length - 1) {
                this.offset = this.bounds.length - 1;
            }
            this.relayout();
        } else {
            int n = this.offset;
            while (n < this.bounds.length) {
                if (this.bounds[n].contains(bMouseEvent.getX(), bMouseEvent.getY())) {
                    this.pressed = n;
                    this.repaint();
                    return;
                }
                ++n;
            }
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        int n = this.offset;
        while (n < this.bounds.length) {
            if (this.bounds[n] != null && this.bounds[n].contains(bMouseEvent.getX(), bMouseEvent.getY())) {
                if (this.pressed != n) break;
                BINavNode[] bINavNodeArray = this.model.getPath();
                this.model.setDirectory(bINavNodeArray[n]);
                break;
            }
            ++n;
        }
        this.pressed = -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.buttonSize = 16;
        this.leftButton = new RectGeom();
        this.rightButton = new RectGeom();
        this.leftButtonEnabled = false;
        this.rightButtonEnabled = false;
        this.offset = 0;
        this.armed = -1;
        this.pressed = -1;
    }

    public BFilePathBar(FileChooserModel fileChooserModel) {
        this.this();
        this.model = fileChooserModel;
    }

    public BFilePathBar() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ui$file$BFilePathBar;
        if (clazz == null) {
            clazz = class$com$tridium$ui$file$BFilePathBar = BFilePathBar.class("[Lcom.tridium.ui.file.BFilePathBar;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        insets = BInsets.make((double)3, (double)6.0, (double)3, (double)6.0);
    }
}

