/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt.se;

import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.awt.AwtShellManager;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.baja.log.Log;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.text.BTextEditor;

public class InputMethodManager
implements InputMethodRequests {
    private static final AttributedCharacterIterator EMPTY_TEXT = new AttributedString("").getIterator();
    static final Log log = Log.getLog((String)"ui.inputmethod");
    private AwtShellManager shellManager;
    private BWidget focus;

    InputMethodManager(AwtShellManager awtShellManager) {
        this.shellManager = awtShellManager;
    }

    final void process(InputMethodEvent inputMethodEvent) {
        BNiagaraWidgetApplication.inputActivity();
        this.focus = this.shellManager.getCurrentFocus();
        if (this.focus != null && this.focus instanceof BTextEditor) {
            BTextEditor bTextEditor = (BTextEditor)this.focus;
            BInputMethodEvent bInputMethodEvent = new BInputMethodEvent(inputMethodEvent.getID(), this.focus, inputMethodEvent.getText(), inputMethodEvent.getCaret(), inputMethodEvent.getVisiblePosition(), inputMethodEvent.getCommittedCharacterCount());
            bTextEditor.fireInputMethodEvent(bInputMethodEvent);
        }
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().cancelLatestCommittedText(attributeArray);
        }
        return EMPTY_TEXT;
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getCommittedText(n, n2, attributeArray);
        }
        return EMPTY_TEXT;
    }

    public int getCommittedTextLength() {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getCommittedTextLength();
        }
        return 0;
    }

    public int getInsertPositionOffset() {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getInsertPositionOffset();
        }
        return 0;
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return (TextHitInfo)((BTextEditor)this.focus).getController().getLocationOffset(n, n2);
        }
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getSelectedText(attributeArray);
        }
        return null;
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return (Rectangle)((BTextEditor)this.focus).getController().getTextLocation(textHitInfo);
        }
        return null;
    }

    void trace(String string, int n, TextHitInfo textHitInfo, AttributedCharacterIterator attributedCharacterIterator, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append(' ');
        switch (n) {
            case 1101: {
                stringBuffer.append("CaretChanged");
                break;
            }
            case 1100: {
                stringBuffer.append("IMTextChanged");
                break;
            }
            default: {
                stringBuffer.append("InputMethodEvent");
            }
        }
        stringBuffer.append("[Char=").append(c);
        if (textHitInfo != null) {
            stringBuffer.append(" TextHitInfo=[").append(textHitInfo.getCharIndex()).append(",");
            if (textHitInfo.isLeadingEdge()) {
                stringBuffer.append("TRUE]");
            } else {
                stringBuffer.append("FALSE]");
            }
        }
        if (attributedCharacterIterator != null && attributedCharacterIterator.getAttributes() != null) {
            stringBuffer.append(" Attributes=").append(attributedCharacterIterator.getAttributes());
        }
        stringBuffer.append(" CommittedCount=").append(n2);
        stringBuffer.append("]");
        log.trace(stringBuffer.toString());
    }
}

