/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt.se;

import com.tridium.ui.NiagaraWbShell;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.se.AwtSeDragOperation;
import com.tridium.ui.awt.se.InputMethodManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.im.InputMethodRequests;
import java.io.File;
import java.util.List;
import javax.baja.file.BFileSystem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;

public class AwtSeShellManager
extends AwtShellManager
implements DropTargetListener {
    private DropTarget dropTarget;
    public final InputMethodManager methodManager;

    public AwtSeShellManager(BWidget bWidget, ShellPeer shellPeer) {
        super(bWidget, shellPeer);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.enableInputMethods(true);
        this.enableEvents(133180L);
        this.dropTarget = new DropTarget(this, 3, this);
        this.methodManager = new InputMethodManager(this);
    }

    public void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.wheel(mouseWheelEvent);
        super.processMouseWheelEvent(mouseWheelEvent);
    }

    void wheel(MouseWheelEvent mouseWheelEvent) {
        BComplex bComplex;
        BWidget bWidget = this.mouseManager.over();
        if (bWidget == null) {
            return;
        }
        BMouseEvent bMouseEvent = this.mouseManager.fire(507, mouseWheelEvent, bWidget);
        while (!bMouseEvent.isConsumed() && (bComplex = bWidget.getParent()) instanceof BWidget) {
            bWidget = (BWidget)bComplex;
            try {
                bWidget.fireMouseEvent(bMouseEvent);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void startDragOperation(BTransferWidget bTransferWidget, BMouseEvent bMouseEvent, TransferContext transferContext, DragRenderer dragRenderer) {
        dragOperation = new AwtSeDragOperation(this, bTransferWidget, bMouseEvent, transferContext, dragRenderer);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(1);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                File file = (File)list.get(0);
                if (this.shell instanceof NiagaraWbShell) {
                    BOrd bOrd = BFileSystem.INSTANCE.localFileToOrd(file);
                    ((NiagaraWbShell)((Object)this.shell)).hyperlink(bOrd);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        dropTargetDropEvent.dropComplete(true);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public InputMethodRequests getInputMethodRequests() {
        return this.methodManager;
    }

    public void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        this.methodManager.process(inputMethodEvent);
        super.processInputMethodEvent(inputMethodEvent);
    }
}

