/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt.se;

import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.DragOperation;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.util.UiLexicon;

public class AwtSeDragOperation
extends DragOperation {
    BTransferWidget source;
    BMouseEvent gestureEvent;
    TransferContext context;
    DragRenderer dragRenderer;
    int actions;
    AwtShellManager dragManager;
    AwtShellManager curManager;
    AwtShellManager exitManager;
    int mx;
    int my;
    int lastx;
    int lasty;
    boolean pulse;
    BTransferWidget dragOver;
    int overActions;

    public AwtSeDragOperation(AwtShellManager awtShellManager, BTransferWidget bTransferWidget, BMouseEvent bMouseEvent, TransferContext transferContext, DragRenderer dragRenderer) {
        this.dragManager = awtShellManager;
        this.curManager = awtShellManager;
        this.mx = this.lastx = awtShellManager.mouseManager.lastX();
        this.my = this.lasty = awtShellManager.mouseManager.lastY();
        this.source = bTransferWidget;
        this.gestureEvent = bMouseEvent;
        this.context = transferContext;
        this.dragRenderer = dragRenderer;
        this.actions = 16;
        this.updateMouse(this.mx, this.my, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDragEffect(AwtShellManager awtShellManager, Graphics graphics) {
        if (awtShellManager != this.curManager) {
            return;
        }
        graphics.push();
        try {
            RectGeom rectGeom = this.dragRenderer.getDragEffectRectGeom();
            graphics.translate((double)this.mx, (double)this.my);
            graphics.clip(rectGeom.x, rectGeom.y, rectGeom.width, rectGeom.height);
            this.dragRenderer.paintDragEffect(graphics);
        }
        finally {
            graphics.pop();
        }
    }

    public void process(AwtShellManager awtShellManager, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getID() == 504) {
            this.curManager = awtShellManager;
            this.updateMouse(n, n2, false);
        } else if (mouseEvent.getID() == 505) {
            this.fireDragEnterExit(null);
            this.exitManager = this.curManager;
            this.curManager = null;
            this.exitManager.repaint();
            this.exitManager.setCursor(Cursor.getPredefinedCursor(0));
        } else if (mouseEvent.getID() == 506) {
            if (this.curManager != null) {
                Point point = this.translateDragToCur(n, n2);
                this.updateMouse(point.x, point.y, false);
            }
        } else if (mouseEvent.getID() == 502) {
            AwtShellManager.dragOperation = null;
            if (this.curManager != null) {
                Point point = this.translateDragToCur(n, n2);
                this.updateMouse(point.x, point.y, false);
                this.curManager.setCursor(Cursor.getPredefinedCursor(0));
                this.drop(mouseEvent);
            }
        }
    }

    public void pulse() {
        this.updateMouse(this.mx, this.my, true);
    }

    public void process(AwtShellManager awtShellManager, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancel();
        }
    }

    private void updateMouse(int n, int n2, boolean bl) {
        this.lastx = this.mx;
        this.lasty = this.my;
        this.mx = n;
        this.my = n2;
        this.pulse = bl;
        this.repaintDirty();
        this.checkDropZone();
    }

    private void repaintDirty() {
        AwtShellManager awtShellManager = this.curManager;
        if (awtShellManager == null) {
            return;
        }
        RectGeom rectGeom = this.dragRenderer.getDragEffectRectGeom();
        RectGeom rectGeom2 = new RectGeom((IRectGeom)rectGeom);
        RectGeom rectGeom3 = new RectGeom((IRectGeom)rectGeom);
        rectGeom2.translate((double)this.lastx, (double)this.lasty);
        rectGeom3.translate((double)this.mx, (double)this.my);
        RectGeom rectGeom4 = RectGeom.bounds((IRectGeom)rectGeom2, (IRectGeom)rectGeom3, null);
        if (rectGeom4.x < 0.0) {
            rectGeom4.x = 0.0;
        }
        if (rectGeom4.y < 0.0) {
            rectGeom4.y = 0.0;
        }
        awtShellManager.repaint((int)rectGeom4.x, (int)rectGeom4.y, (int)rectGeom4.width, (int)rectGeom4.height);
    }

    private void checkDropZone() {
        AwtShellManager awtShellManager = this.curManager;
        if (awtShellManager == null) {
            return;
        }
        Cursor cursor = DragSource.DefaultCopyNoDrop;
        try {
            BTransferWidget bTransferWidget = null;
            BWidget bWidget = awtShellManager.widgetAt(new javax.baja.gx.Point((double)this.mx, (double)this.my), true);
            if (bWidget instanceof BTransferWidget) {
                bTransferWidget = (BTransferWidget)bWidget;
            }
            this.fireDragEnterExit(bTransferWidget);
            if (bTransferWidget != null) {
                this.overActions = bTransferWidget.dragOver(this.dragContext(bTransferWidget, this.actions));
                if (this.overActions != 0) {
                    cursor = DragSource.DefaultCopyDrop;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        awtShellManager.setCursor(cursor);
    }

    private void fireDragEnterExit(BTransferWidget bTransferWidget) {
        BTransferWidget bTransferWidget2 = this.dragOver;
        if (bTransferWidget2 != bTransferWidget) {
            this.dragOver = bTransferWidget;
            try {
                if (bTransferWidget2 != null) {
                    bTransferWidget2.dragExit(this.dragContext(bTransferWidget2, this.actions));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                if (bTransferWidget != null) {
                    bTransferWidget.dragEnter(this.dragContext(bTransferWidget, this.actions));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void cancel() {
        AwtShellManager.dragOperation = null;
        this.fireDragEnterExit(null);
        if (this.curManager != null) {
            this.curManager.repaint();
            this.curManager.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void drop(MouseEvent mouseEvent) {
        this.dragManager.mouseManager.holdRelease = true;
        if (this.dragOver == null) {
            return;
        }
        if (this.overActions == 0) {
            this.dragOver.dragExit(this.dragContext(this.dragOver, 0));
            return;
        }
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.popupForAction();
        } else {
            this.fireDrop(this.dragOver, this.dragContext(this.dragOver, 16));
        }
    }

    private void popupForAction() {
        UiLexicon uiLexicon = UiLexicon.bajaui();
        DragOperation.PopupCommand popupCommand = new DragOperation.PopupCommand(this.dragOver, uiLexicon.getText("commands.copy.label"), 16);
        DragOperation.PopupCommand popupCommand2 = new DragOperation.PopupCommand(this.dragOver, uiLexicon.getText("commands.move.label"), 32);
        DragOperation.PopupCommand popupCommand3 = new DragOperation.PopupCommand(this.dragOver, uiLexicon.getText("action.cancel"), -1);
        if ((this.overActions & 0x10) == 0) {
            popupCommand.setEnabled(false);
        }
        if ((this.overActions & 0x20) == 0) {
            popupCommand2.setEnabled(false);
        }
        BMenu bMenu = new BMenu();
        bMenu.add("copy", popupCommand);
        bMenu.add("move", popupCommand2);
        bMenu.add("sep", (BValue)new BSeparator());
        bMenu.add("cancel", popupCommand3);
        javax.baja.gx.Point point = new javax.baja.gx.Point((double)this.mx, (double)this.my);
        this.curManager.shellToWidget(this.dragOver, point);
        bMenu.open(this.dragOver, point.x, point.y);
    }

    public void fireDrop(BTransferWidget bTransferWidget, int n) {
        this.fireDrop(bTransferWidget, this.dragContext(bTransferWidget, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDrop(BTransferWidget bTransferWidget, TransferContext transferContext) {
        this.curManager.enterBusy(null);
        try {
            UndoManager undoManager;
            CommandArtifact commandArtifact = bTransferWidget.drop(transferContext);
            if (commandArtifact != null && (undoManager = bTransferWidget.getUndoManager()) != null) {
                undoManager.addArtifact(commandArtifact);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string = UiLexicon.bajaui().getText("dialog.error");
            String string2 = UiLexicon.bajaui().getText("drop.error");
            BDialog.error((BWidget)bTransferWidget, string, (Object)string2, throwable);
        }
        finally {
            this.curManager.exitBusy(null);
            this.curManager.repaint();
        }
    }

    private TransferContext dragContext(BTransferWidget bTransferWidget, int n) {
        javax.baja.gx.Point point = new javax.baja.gx.Point((double)this.mx, (double)this.my);
        this.curManager.shellToWidget(bTransferWidget, point);
        this.context.setAction(n);
        this.context.setPosition(point.x, point.y);
        this.context.setPulse(this.pulse);
        return this.context;
    }

    private Point translateDragToCur(int n, int n2) {
        Point point = new Point(n, n2);
        Point point2 = this.dragManager.getLocationOnScreen();
        Point point3 = this.curManager.getLocationOnScreen();
        point.translate(point2.x, point2.y);
        point.translate(-point3.x, -point3.y);
        return point;
    }
}

