/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.MarkTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.baja.space.Mark;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;

public class TransferManager {
    public static final ClipboardManager defaultClipboardManager = new ClipboardManager(Toolkit.getDefaultToolkit().getSystemClipboard());
    static final String emptyString = "!_empty_*&^";
    static final StringSelection empty = new StringSelection("!_empty_*&^");

    public static Transferable toAwt(TransferEnvelope transferEnvelope) {
        if (transferEnvelope == null) {
            return empty;
        }
        TransferFormat[] transferFormatArray = transferEnvelope.getFormats();
        if (transferFormatArray[0].equals(TransferFormat.string)) {
            String string = (String)transferEnvelope.getData(TransferFormat.string);
            return new StringSelection(string);
        }
        if (transferFormatArray[0].equals(TransferFormat.mark)) {
            Mark mark = (Mark)transferEnvelope.getData(TransferFormat.mark);
            return MarkTransferable.make(mark);
        }
        throw new IllegalStateException("Unknown transfer envelope");
    }

    public static TransferEnvelope fromAwt(Transferable transferable) {
        if (transferable == null) {
            return null;
        }
        try {
            if (transferable.isDataFlavorSupported(MarkTransferable.markFlavor)) {
                Mark mark = (Mark)transferable.getTransferData(MarkTransferable.markFlavor);
                return TransferEnvelope.make(mark);
            }
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (string.equals(emptyString)) {
                return null;
            }
            return TransferEnvelope.make(string);
        }
        catch (Exception exception) {
            throw new UnsupportedFormatException(exception);
        }
    }

    public static class ClipboardManager
    implements UiEnv.ClipboardManager {
        Clipboard awtClipboard;

        public TransferEnvelope getContents() {
            Transferable transferable = this.awtClipboard.getContents(null);
            TransferEnvelope transferEnvelope = TransferManager.fromAwt(transferable);
            return transferEnvelope;
        }

        public void setContents(TransferEnvelope transferEnvelope) {
            Transferable transferable = TransferManager.toAwt(transferEnvelope);
            this.awtClipboard.setContents(transferable, null);
        }

        public ClipboardManager(Clipboard clipboard) {
            this.awtClipboard = clipboard;
        }
    }
}

