/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.Binder;
import com.tridium.ui.awt.AwtShellManager;
import java.io.PrintWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;

public class Perf {
    public static final boolean enabled = true;
    public AwtShellManager mgr;
    public int numShellPaint;
    public long durTotalPaint;
    public long durWidgetLayout;
    public long durCreateBuffer;
    public long durClearClip;
    public long durWidgetPaint;
    public long durDrawBuffer;

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        if (this.numShellPaint == 0) {
            return;
        }
        printWriter.println("numShellPaint:     " + this.numShellPaint);
        printWriter.println("durTotalPaint:     " + this.ns(this.durTotalPaint));
        printWriter.println("durWidgetLayout:   " + this.percent(this.durWidgetLayout));
        printWriter.println("durCreateBuffer:   " + this.percent(this.durCreateBuffer));
        printWriter.println("durClearClip:      " + this.percent(this.durClearClip));
        printWriter.println("durWidgetPaint:    " + this.percent(this.durWidgetPaint));
        printWriter.println("durDrawBuffer:     " + this.percent(this.durDrawBuffer));
        printWriter.println("avgTotalPaint:     " + this.ns(this.durTotalPaint / (long)this.numShellPaint));
        printWriter.println("avgWidgetLayout:   " + this.ns(this.durWidgetLayout / (long)this.numShellPaint));
        printWriter.println("avgWidgetPaint:    " + this.ns(this.durWidgetPaint / (long)this.numShellPaint));
        printWriter.println("checkItemDelay:    " + Binder.checkItemsDelay);
        printWriter.println("animateDelay:      " + BNiagaraWidgetApplication.animateDelay);
        printWriter.println("runGc:             " + BNiagaraWidgetApplication.runGc);
    }

    public String percent(long l) {
        String string = this.ns(l);
        double d = (double)l / (double)this.durTotalPaint * 100.0;
        return TextUtil.pad((String)string, (int)8) + "  " + (int)d + '%';
    }

    public String ns(long l) {
        if (l < 2000000L) {
            return l + "ns";
        }
        return l / 1000000L + "ms";
    }

    public static long now() {
        return Clock.nanoTicks();
    }

    Perf(AwtShellManager awtShellManager) {
        this.mgr = awtShellManager;
    }
}

