/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.awt.DragOperation;
import com.tridium.ui.awt.PanelPeer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Stack;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.sys.BComplex;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;

public class NPopup
extends Window {
    private static Stack stack = new Stack();
    private static boolean consumeUntilRelease;
    private AwtShellManager shellManager;
    private AwtShellManager masterShellManager;
    private BWidget widget;

    public static NPopup open(BWidget bWidget, BWidget bWidget2, double d, double d2) {
        return NPopup.open(bWidget, bWidget2, d, d2, -1.0, -1.0);
    }

    public static NPopup open(BWidget bWidget, BWidget bWidget2, double d, double d2, double d3, double d4) {
        AwtShellManager awtShellManager = null;
        awtShellManager = stack.size() == 0 ? (AwtShellManager)bWidget2.widgetSupport(null) : ((PopupEntry)NPopup.stack.elementAt((int)0)).popup.masterShellManager;
        NPopup nPopup = (NPopup)AccessController.doPrivileged(new PrivilegedPopupFactory(awtShellManager, bWidget, bWidget2, d, d2, d3, d4));
        PopupEntry popupEntry = new PopupEntry(nPopup, bWidget, bWidget2);
        stack.push(popupEntry);
        bWidget.setVisible(true);
        nPopup.setVisible(true);
        nPopup.takeTempFocus();
        return nPopup;
    }

    /*
     * Unable to fully structure code
     */
    public static void close(BWidget var0) {
        if (var0 == null || NPopup.isOpen(var0)) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (PopupEntry)NPopup.stack.pop();
            if (NPopup.stack.isEmpty() && var1_1.owner instanceof BMenu.MenuCloseListener && var1_1.widget instanceof BMenu) {
                try {
                    ((BMenu.MenuCloseListener)var1_1.owner).menuClosed((BMenu)var1_1.widget);
                }
                catch (Throwable var2_2) {
                    var2_2.printStackTrace();
                }
            }
            var1_1.close();
            if (NPopup.stack.size() > 0) {
                ((PopupEntry)NPopup.stack.peek()).popup.takeTempFocus();
            }
            var1_1.popup.shellManager.disposeBuffer();
            if (var1_1.widget != var0) continue;
            return;
lbl16:
            // 2 sources

            ** while (!NPopup.stack.isEmpty())
        }
lbl17:
        // 1 sources

    }

    public static boolean isOpen(BWidget bWidget) {
        int n = 0;
        while (n < stack.size()) {
            if (((PopupEntry)NPopup.stack.elementAt((int)n)).widget == bWidget) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean cancel(KeyEvent keyEvent) {
        if (consumeUntilRelease) {
            if (keyEvent.getID() == 402) {
                consumeUntilRelease = false;
            }
            return true;
        }
        if (stack.size() == 0) {
            return false;
        }
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            return NPopup.doCancel();
        }
        return false;
    }

    public static boolean cancel(MouseEvent mouseEvent) {
        if (consumeUntilRelease) {
            if (mouseEvent.getID() == 502) {
                consumeUntilRelease = false;
            }
            return true;
        }
        if (stack.size() == 0) {
            return false;
        }
        if (mouseEvent.getID() == 501 && !(mouseEvent.getComponent().getParent() instanceof NPopup)) {
            return NPopup.doCancel();
        }
        return false;
    }

    static boolean doCancel() {
        try {
            Command command;
            BMenuItem[] bMenuItemArray;
            PopupEntry popupEntry = (PopupEntry)stack.get(0);
            if (popupEntry.widget instanceof BMenu && (bMenuItemArray = ((BMenu)popupEntry.widget).getMenuItems()).length > 0 && (command = bMenuItemArray[0].getCommand()) instanceof DragOperation.PopupCommand) {
                ((DragOperation.PopupCommand)command).popupCanceled();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        NPopup.close(null);
        consumeUntilRelease = true;
        return true;
    }

    public void takeTempFocus() {
        this.shellManager.takeTempFocus(this.masterShellManager);
    }

    public void releaseTempFocus() {
        this.shellManager.releaseTempFocus(this.masterShellManager);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private final void insureOnScreen(BWidget bWidget, int n, int n2, int n3, int n4) {
        IRectGeom iRectGeom = UiEnv.get().getScreenBounds(bWidget);
        int n5 = (int)iRectGeom.x();
        int n6 = (int)iRectGeom.y();
        int n7 = (int)iRectGeom.width();
        int n8 = (int)iRectGeom.height();
        if (n + n3 > n5 + n7) {
            n = this.fitX(n, n3, n5, n7);
        }
        if (n2 + n4 > n6 + n8) {
            n2 = this.fitY(n2, n4, n6, n8);
        }
        if (n < n5) {
            n = n5;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        this.setLocation(n, n2);
    }

    private final int fitX(int n, int n2, int n3, int n4) {
        NPopup nPopup = this.parentOnStack();
        if (nPopup == null) {
            return n3 + n4 - n2;
        }
        return nPopup.getX() - n2;
    }

    private final int fitY(int n, int n2, int n3, int n4) {
        NPopup nPopup = this.parentOnStack();
        if (nPopup == null) {
            return n3 + n4 - n2;
        }
        return n - n2 + 14;
    }

    private final NPopup parentOnStack() {
        int n = 1;
        while (n < stack.size()) {
            PopupEntry popupEntry = (PopupEntry)stack.elementAt(n);
            if (popupEntry.popup == this) {
                return ((PopupEntry)NPopup.stack.elementAt((int)(n - 1))).popup;
            }
            ++n;
        }
        return null;
    }

    private NPopup(AwtShellManager awtShellManager, BWidget bWidget, BWidget bWidget2, double d, double d2, double d3, double d4) {
        super(awtShellManager.getWindow());
        this.masterShellManager = awtShellManager;
        this.shellManager = ((AwtUiEnv)AwtUiEnv.get()).makeAwtShellManager(bWidget, new PanelPeer());
        this.widget = bWidget;
        bWidget.widgetSupport(this.shellManager);
        this.setLayout(new BorderLayout());
        this.add((Component)this.shellManager, "Center");
        Point point = bWidget2.translateToScreen(new Point(d, d2));
        d = point.x;
        d2 = point.y;
        if (d3 == -1.0 || d4 == -1.0) {
            bWidget.computePreferredSize();
            if (d3 == -1.0) {
                d3 = bWidget.getPreferredWidth();
            }
            if (d4 == -1.0) {
                d4 = bWidget.getPreferredHeight();
            }
        }
        this.setBounds((int)d, (int)d2, (int)d3, (int)d4);
        this.insureOnScreen(bWidget2, (int)d, (int)d2, (int)d3, (int)d4);
    }

    static class PopupEntry {
        NPopup popup;
        BWidget widget;
        BWidget owner;

        void close() {
            this.popup.releaseTempFocus();
            this.widget.setVisible(false);
            this.popup.setVisible(false);
            try {
                BComplex bComplex = this.popup.widget.getParent();
                if (this.owner instanceof BDropDown) {
                    ((BDropDown)this.owner).doCloseDropDown();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.popup.dispose();
        }

        PopupEntry(NPopup nPopup, BWidget bWidget, BWidget bWidget2) {
            this.popup = nPopup;
            this.widget = bWidget;
            this.owner = bWidget2;
        }
    }

    static class PrivilegedPopupFactory
    implements PrivilegedAction {
        AwtShellManager masterShellManager;
        BWidget widget;
        BWidget owner;
        double x;
        double y;
        double w;
        double h;

        public Object run() {
            return new NPopup(this.masterShellManager, this.widget, this.owner, this.x, this.y, this.w, this.h);
        }

        PrivilegedPopupFactory(AwtShellManager awtShellManager, BWidget bWidget, BWidget bWidget2, double d, double d2, double d3, double d4) {
            this.masterShellManager = awtShellManager;
            this.widget = bWidget;
            this.owner = bWidget2;
            this.x = d;
            this.y = d2;
            this.w = d3;
            this.h = d4;
        }
    }
}

