/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.sys.Nre;
import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.awt.DragOperation;
import com.tridium.ui.awt.NPopup;
import java.awt.event.MouseEvent;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class MouseManager {
    public static final int PRESSED = 501;
    public static final int RELEASED = 502;
    public static final int ENTERED = 504;
    public static final int EXITED = 505;
    public static final int MOVED = 503;
    public static final int DRAGGED = 506;
    public static final int WHEEL = 507;
    public static final int PULSED = 510;
    public static final int DRAG_STARTED = 511;
    public static final int HOVER = 512;
    static final int FIRST_PULSE_MILLIS = 700;
    static final int PULSE_MILLIS = 150;
    static final int DRAG_TOLERANCE = 10;
    static final int HOVER_MILLIS = 700;
    static MouseManager hoverManager = null;
    static final HoverThread hoverThread = new HoverThread();
    static MouseManager pulseManager;
    static final PulseThread pulseThread;
    AwtShellManager shellManager;
    BWidget over;
    BWidget active;
    int lastX;
    int lastY;
    int lastModifiers;
    int pressX;
    int pressY;
    boolean firedDragStarted;
    IMouseOverride override;
    public boolean holdRelease;

    public BWidget over() {
        return this.over;
    }

    public int lastX() {
        return this.lastX;
    }

    public int lastY() {
        return this.lastY;
    }

    public void setMouseOverride(IMouseOverride iMouseOverride) {
        this.override = iMouseOverride;
    }

    final void process(MouseEvent mouseEvent) {
        BNiagaraWidgetApplication.inputActivity();
        if (NPopup.cancel(mouseEvent)) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.pressed(mouseEvent);
                return;
            }
            case 502: {
                this.released(mouseEvent);
                return;
            }
            case 505: {
                this.exited(mouseEvent);
                return;
            }
            case 503: {
                this.moved(mouseEvent);
                return;
            }
            case 506: {
                this.dragged(mouseEvent);
                return;
            }
        }
    }

    private final void pressed(MouseEvent mouseEvent) {
        BWidget bWidget;
        this.active = bWidget = this.getTarget(mouseEvent);
        this.pressX = mouseEvent.getX();
        this.pressY = mouseEvent.getY();
        this.firedDragStarted = false;
        this.fire(501, mouseEvent, bWidget);
        this.startPulse();
    }

    private final void released(MouseEvent mouseEvent) {
        this.stopPulse();
        if (this.holdRelease) {
            this.holdRelease = false;
        } else {
            this.fire(502, mouseEvent, this.active);
        }
        BWidget bWidget = this.getTarget(mouseEvent);
        if (bWidget != this.active) {
            if (bWidget != null) {
                this.fire(504, mouseEvent, bWidget);
            }
            if (this.over != bWidget && this.over != null) {
                this.fire(505, mouseEvent, this.over);
            }
            this.over = bWidget;
        }
        this.active = null;
    }

    private final void exited(MouseEvent mouseEvent) {
        if (this.over != null) {
            this.fire(505, mouseEvent, this.over);
        }
        this.over = null;
    }

    void checkOver() {
        if (this.active != null && this.active.isEnabled() && this.active.widgetSupport(null) != null) {
            return;
        }
        this.moved(new MouseEvent(this.shellManager, 503, System.currentTimeMillis(), this.lastModifiers, this.lastX, this.lastY, 0, false));
    }

    private final void moved(MouseEvent mouseEvent) {
        BWidget bWidget = this.getTarget(mouseEvent);
        if (bWidget != this.over) {
            if (this.over != null) {
                this.fire(505, mouseEvent, this.over);
            }
            if (bWidget != null) {
                this.fire(504, mouseEvent, bWidget);
            }
            this.over = bWidget;
            this.shellManager.updateMouseCursor();
        } else if (bWidget != null) {
            this.fire(503, mouseEvent, bWidget);
        }
    }

    private final void dragged(MouseEvent mouseEvent) {
        BWidget bWidget = this.getTarget(mouseEvent);
        if (bWidget != this.over) {
            if (bWidget == this.active) {
                this.fire(504, mouseEvent, this.active);
            } else {
                this.fire(505, mouseEvent, this.active);
            }
            this.over = bWidget;
        }
        this.fire(506, mouseEvent, this.active);
        if (!this.firedDragStarted) {
            int n;
            int n2;
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            int n5 = n3 - this.pressX;
            if (n5 < 0) {
                n5 = -n5;
            }
            if ((n2 = n4 - this.pressY) < 0) {
                n2 = -n2;
            }
            if ((n = Math.max(n5, n2)) > 10) {
                this.firedDragStarted = true;
                BWidget bWidget2 = this.active;
                if (bWidget2 != null) {
                    Point point = new Point((double)this.pressX, (double)this.pressY);
                    this.shellManager.shellToWidget(bWidget2, point);
                    this.fire(new BMouseEvent(511, bWidget2, mouseEvent.getWhen(), this.lastModifiers, point.x, point.y, -1, false));
                }
            }
        }
    }

    private final void hover() {
        BWidget bWidget = this.over;
        if (bWidget != null) {
            Point point = new Point((double)this.lastX, (double)this.lastY);
            this.shellManager.shellToWidget(bWidget, point);
            this.fire(new BMouseEvent(512, bWidget, this.lastModifiers, point.x, point.y, -1, false));
        }
    }

    private final void pulse() {
        BWidget bWidget = this.active;
        if (bWidget != null) {
            Point point = new Point((double)this.lastX, (double)this.lastY);
            this.shellManager.shellToWidget(bWidget, point);
            this.fire(new BMouseEvent(510, bWidget, this.lastModifiers, point.x, point.y, -1, false));
            DragOperation dragOperation = AwtShellManager.dragOperation;
            if (dragOperation != null) {
                dragOperation.pulse();
            }
        }
    }

    public BMouseEvent fire(int n, MouseEvent mouseEvent, BWidget bWidget) {
        if (bWidget == null) {
            return null;
        }
        try {
            BMouseEvent bMouseEvent;
            if (!UiEnv.get().hasMouse() && n == 501) {
                this.fire(504, mouseEvent, bWidget);
                this.fire(503, mouseEvent, bWidget);
            }
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
            this.lastModifiers = mouseEvent.getModifiers();
            Point point = new Point((double)mouseEvent.getX(), (double)mouseEvent.getY());
            this.shellManager.shellToWidget(bWidget, point);
            if (n == 507) {
                bMouseEvent = ((AwtUiEnv)AwtUiEnv.get()).makeMouseWheelEvent(n, mouseEvent, bWidget, point);
            } else {
                boolean bl = mouseEvent.isPopupTrigger();
                if (this.override != null && this.override.isPopupTrigger()) {
                    if (n == 502) {
                        bl = true;
                        this.override.mouseReleased();
                    }
                    this.lastModifiers &= 0xFFFFFFEF;
                    this.lastModifiers |= 4;
                }
                bMouseEvent = new BMouseEvent(n, bWidget, mouseEvent.getWhen(), this.lastModifiers, point.x, point.y, mouseEvent.getClickCount(), bl);
            }
            this.fire(bMouseEvent);
            if (n == 504) {
                this.startHover();
            }
            if (!UiEnv.get().hasMouse() && n == 502) {
                this.fire(505, mouseEvent, bWidget);
            }
            return bMouseEvent;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private final void fire(BMouseEvent bMouseEvent) {
        try {
            bMouseEvent.getWidget().fireMouseEvent(bMouseEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final BWidget getTarget(MouseEvent mouseEvent) {
        Point point = new Point((double)mouseEvent.getX(), (double)mouseEvent.getY());
        BWidget bWidget = this.shellManager.widgetAt(point, true);
        while (bWidget != null && !bWidget.receiveInputEvents()) {
            bWidget = bWidget.getParentWidget();
        }
        return bWidget;
    }

    private final String eventIdToString(int n) {
        switch (n) {
            case 501: {
                return "Pressed";
            }
            case 502: {
                return "Released";
            }
            case 504: {
                return "Entered";
            }
            case 505: {
                return "Exited";
            }
            case 503: {
                return "Moved";
            }
            case 506: {
                return "Dragged";
            }
        }
        return "????";
    }

    private final String toString(BMouseEvent bMouseEvent, BWidget bWidget) {
        switch (bMouseEvent.getId()) {
            case 501: {
                return "Pressed:  " + bWidget;
            }
            case 502: {
                return "Released: " + bWidget;
            }
            case 504: {
                return "Entered:  " + bWidget;
            }
            case 505: {
                return "Exited:   " + bWidget;
            }
            case 503: {
                return "Moved:    " + bWidget;
            }
            case 506: {
                return "Dragged:  " + bWidget;
            }
        }
        return "????";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startHover() {
        hoverThread.interrupt();
        hoverManager = this;
        HoverThread hoverThread = MouseManager.hoverThread;
        synchronized (hoverThread) {
            MouseManager.hoverThread.notifyAll();
            return;
        }
    }

    private final void stopHover() {
        hoverManager = null;
    }

    void resetHover(BWidget bWidget) {
        this.startHover();
    }

    private final void startPulse() {
        pulseThread.interrupt();
        pulseManager = this;
    }

    private final void stopPulse() {
        pulseManager = null;
    }

    MouseManager(AwtShellManager awtShellManager) {
        this.shellManager = awtShellManager;
    }

    static {
        hoverThread.start();
        pulseManager = null;
        pulseThread = new PulseThread();
        pulseThread.start();
    }

    public static interface IMouseOverride {
        public boolean isPopupTrigger();

        public void mouseReleased();
    }

    private static class HoverThread
    extends Thread {
        int pulseTime;

        public void run() {
            while (true) {
                try {
                    HoverThread.sleep(700L);
                    if (hoverManager != null) {
                        try {
                            hoverManager.hover();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    Thread.sleep(Long.MAX_VALUE);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }

        HoverThread() {
            super(Nre.mainThreadGroup, "Ui:HoverThread");
            this.setDaemon(true);
        }
    }

    private static class PulseThread
    extends Thread {
        int pulseTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        block13: {
                            PulseThread pulseThread = this;
                            synchronized (pulseThread) {
                                while (true) {
                                    if (pulseManager != null) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 3, 8, 9, 10, 12] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                                        if (pulseManager != null) {
                                            break;
                                        }
                                        break block13;
                                    }
                                    this.pulseTime = 700;
                                    this.wait();
                                }
                            }
                            try {
                                pulseManager.pulse();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        Thread.sleep(this.pulseTime);
                        this.pulseTime = 150;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.pulseTime = 700;
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }

        PulseThread() {
            super(Nre.mainThreadGroup, "Ui:PulseThread");
            this.setDaemon(true);
        }
    }
}

