/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.awt.NPopup;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.baja.log.Log;
import javax.baja.nre.util.TextUtil;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;

final class FocusManager {
    static final int PRESSED = 401;
    static final int RELEASED = 402;
    static final int TYPED = 400;
    static final int GAINED = 1004;
    static final int LOST = 1005;
    static final Log log = Log.getLog((String)"ui.focus");
    private AwtShellManager shellManager;
    private BWidget shell;
    private boolean inFocus;
    private BWidget focus;
    private BWidget focusBeforeLoss;
    private boolean ignoreUntilTabRelease;
    private boolean onlyAltPressed;
    private BWidget focusBeforeTemp;
    private BWidget inPress;
    BKeyEvent lastKeyEvent;
    boolean takeBack;

    final void process(FocusEvent focusEvent) {
        BNiagaraWidgetApplication.inputActivity();
        switch (focusEvent.getID()) {
            case 1004: {
                this.inFocus = true;
                if (this.focusBeforeLoss == null) {
                    this.focusBeforeLoss = this.traverse(true);
                }
                this.changed(this.focusBeforeLoss, true);
                return;
            }
            case 1005: {
                this.inFocus = false;
                this.focusBeforeLoss = this.focus;
                this.inPress = null;
                if (this.takeBack && ((AwtUiEnv)AwtUiEnv.get()).getOpposite(focusEvent) == null) {
                    this.takeBack = false;
                    this.shellManager.requestFocus();
                    break;
                }
                this.changed(null, true);
                return;
            }
        }
    }

    final void process(KeyEvent keyEvent) {
        BWidget bWidget;
        BNiagaraWidgetApplication.inputActivity();
        if (log.isTraceOn()) {
            this.trace("process", keyEvent);
        }
        int n = keyEvent.getID();
        int n2 = keyEvent.getKeyCode();
        if (NPopup.cancel(keyEvent)) {
            return;
        }
        BWidget bWidget2 = this.inPress;
        if (n == 401) {
            this.inPress = bWidget2 = this.focus;
        } else if (n == 402) {
            this.inPress = null;
        }
        if (n == 401 && keyEvent.getKeyCode() == 123) {
            this.shellManager.debug();
        }
        if (n == 401 && n2 == 27 && this.shell instanceof BWidgetShell) {
            ((BWidgetShell)this.shell).handleEscape();
            return;
        }
        if (bWidget2 != null && !this.ignoreUntilTabRelease && this.fireKeyEvent(bWidget2, keyEvent)) {
            return;
        }
        if (n2 == 9) {
            if (n == 401) {
                if (keyEvent.isShiftDown()) {
                    this.changed(this.traverse(false), false);
                } else {
                    this.changed(this.traverse(true), false);
                }
                this.ignoreUntilTabRelease = true;
            } else if (n == 402) {
                this.ignoreUntilTabRelease = false;
            }
        }
        if (n == 401 && n2 == 10 && this.shell instanceof BWidgetShell) {
            ((BWidgetShell)this.shell).handleEnter();
            return;
        }
        if (n == 401 && this.shell instanceof BWidgetShell) {
            bWidget = this.getAccelerator(this.convert(null, keyEvent));
            if (bWidget != null) {
                ((BActionMenuItem)bWidget).invokeAction();
            }
            boolean bl = false;
            if (n2 == 18) {
                bl = true;
            }
            this.onlyAltPressed = bl;
        }
        boolean bl = false;
        if (this.onlyAltPressed && n2 == 18) {
            bl = this.onlyAltPressed = true;
        }
        if (n == 402 && n2 == 18 && this.shell instanceof BWidgetShell && this.onlyAltPressed && (bWidget = ((BWidgetShell)this.shell).getMenuBar()) instanceof BMenuBar) {
            BWidget[] bWidgetArray = bWidget.getChildWidgets();
            if (bWidgetArray.length > 0) {
                ((BMenuBar)bWidget).focus((BMenu)bWidgetArray[0]);
            }
            return;
        }
        if (this.focus != null && n2 != 10) {
            this.fireKeyEvent(this.focus, keyEvent);
        }
    }

    final BActionMenuItem getAccelerator(BKeyEvent bKeyEvent) {
        BWidget bWidget = ((BWidgetShell)this.shell).getMenuBar();
        if (bWidget == null) {
            return null;
        }
        return this.getAccelerator(bKeyEvent, bWidget);
    }

    final BActionMenuItem getAccelerator(BKeyEvent bKeyEvent, BWidget bWidget) {
        BWidget[] bWidgetArray;
        BAccelerator bAccelerator;
        if (bWidget instanceof BActionMenuItem && !(bAccelerator = (bWidgetArray = (BWidget[])bWidget).getAccelerator()).isNull() && bAccelerator.isMatch(bKeyEvent) && bWidgetArray.isEnabled()) {
            return bWidgetArray;
        }
        bWidgetArray = bWidget.getChildWidgets();
        int n = 0;
        while (n < bWidgetArray.length) {
            BActionMenuItem bActionMenuItem = this.getAccelerator(bKeyEvent, bWidgetArray[n]);
            if (bActionMenuItem != null) {
                return bActionMenuItem;
            }
            ++n;
        }
        return null;
    }

    final boolean hasFocus(BWidget bWidget) {
        boolean bl = false;
        if (bWidget == this.focus) {
            bl = true;
        }
        return bl;
    }

    final BWidget getCurrentFocus() {
        return this.focus;
    }

    final void requestFocus(BWidget bWidget) {
        if (bWidget != this.focus) {
            if (this.inFocus) {
                this.changed(bWidget, false);
            } else {
                this.focusBeforeLoss = bWidget;
            }
        }
    }

    final void takeTempFocus(AwtShellManager awtShellManager) {
        if (this.focusBeforeTemp == null) {
            this.focusBeforeTemp = this.focus;
        }
        if (log.isTraceOn()) {
            log.trace(this + " takeTempFocus beforeTemp=" + FocusManager.toString(this.focusBeforeTemp));
        }
        this.shellManager = awtShellManager;
        this.shell = awtShellManager.getShell();
        this.changed(this.traverse(true), true);
    }

    final void releaseTempFocus(AwtShellManager awtShellManager) {
        if (log.isTraceOn()) {
            log.trace(this + " releaseTempFocus beforeTemp=" + FocusManager.toString(this.focusBeforeTemp));
        }
        this.shellManager = awtShellManager;
        this.shell = awtShellManager.getShell();
        this.requestFocus(this.focusBeforeTemp);
        this.focusBeforeTemp = null;
        this.focusBeforeLoss = this.focus;
        this.takeBack = true;
        this.shellManager.requestFocus();
    }

    private final BKeyEvent convert(BWidget bWidget, KeyEvent keyEvent) {
        return new BKeyEvent(keyEvent.getID(), bWidget, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
    }

    private final boolean fireKeyEvent(BWidget bWidget, KeyEvent keyEvent) {
        BKeyEvent bKeyEvent;
        if (log.isTraceOn()) {
            log.trace(" fire on " + bWidget + " for event" + keyEvent);
        }
        this.lastKeyEvent = bKeyEvent = this.convert(bWidget, keyEvent);
        bWidget.fireKeyEvent(bKeyEvent);
        if (bKeyEvent.isConsumed()) {
            keyEvent.consume();
        }
        return bKeyEvent.isConsumed();
    }

    private final void changed(BWidget bWidget, boolean bl) {
        if (this.focus == bWidget) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace(this + " changed " + FocusManager.toString(this.focus) + " -> " + FocusManager.toString(bWidget));
        }
        this.lastKeyEvent = null;
        if (this.focus != null) {
            this.fireFocusEvent(1005, this.focus, bl);
        }
        if (bWidget != null) {
            this.fireFocusEvent(1004, bWidget, bl);
        }
        this.focus = bWidget;
    }

    private final void fireFocusEvent(int n, BWidget bWidget, boolean bl) {
        try {
            BFocusEvent bFocusEvent = new BFocusEvent(n, bWidget, bl);
            bWidget.fireFocusEvent(bFocusEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final BWidget traverse(boolean bl) {
        BWidget bWidget = this.focus != null ? this.focus : this.shell;
        Traversal traversal = FocusManager.traversal(this.shell, bWidget, new Traversal());
        if (bl) {
            if (traversal.next == null) {
                return traversal.first;
            }
            return traversal.next;
        }
        if (traversal.prev == null) {
            return traversal.last;
        }
        return traversal.prev;
    }

    private static final Traversal traversal(BWidget bWidget, BWidget bWidget2, Traversal traversal) {
        if (!bWidget.isVisible() || !bWidget.getEnabled()) {
            return traversal;
        }
        if (bWidget.isFocusTraversable()) {
            if (traversal.first == null) {
                traversal.first = bWidget;
            }
            if (traversal.saveNext) {
                traversal.next = bWidget;
                traversal.saveNext = false;
            }
            if (bWidget == bWidget2) {
                traversal.prev = traversal.last;
                traversal.saveNext = true;
            }
            traversal.last = bWidget;
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        int n = 0;
        while (n < bWidgetArray.length) {
            FocusManager.traversal(bWidgetArray[n], bWidget2, traversal);
            ++n;
        }
        return traversal;
    }

    public final String toString() {
        String string = "FocusManager";
        try {
            string = TextUtil.getClassName(this.shellManager.getWindow().getClass());
            int n = string.indexOf(36);
            if (n > 0) {
                string = string.substring(n + 1);
            }
        }
        catch (Exception exception) {}
        return string + " [" + Integer.toString(this.hashCode(), 36) + ']';
    }

    public static final String toString(BWidget bWidget) {
        if (bWidget == null) {
            return "null";
        }
        return bWidget.getType().getTypeName() + ':' + Integer.toString(bWidget.hashCode(), 36);
    }

    /*
     * Unable to fully structure code
     */
    final String str(Component var1_1) {
        if (var1_1 != null) ** GOTO lbl4
        return "null";
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getParent();
lbl4:
            // 2 sources

            ** while (!(var1_1 instanceof Window))
        }
lbl5:
        // 1 sources

        return TextUtil.getClassName(var1_1.getClass()) + ':' + Integer.toString(var1_1.hashCode(), 36);
    }

    final String str(FocusEvent focusEvent) {
        return (focusEvent.isTemporary() ? "temp" : "perm") + " src=" + this.str(focusEvent.getComponent()) + " opp=" + this.str(((AwtUiEnv)AwtUiEnv.get()).getOpposite(focusEvent));
    }

    final void trace(String string, KeyEvent keyEvent) {
        this.trace(string, keyEvent.getID(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getModifiers());
    }

    final void trace(String string, int n, int n2, char c, int n3) {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append(' ');
        switch (n) {
            case 401: {
                stringBuffer.append("KeyPressed");
                break;
            }
            case 402: {
                stringBuffer.append("KeyReleased");
                break;
            }
            case 400: {
                stringBuffer.append("KeyTyped");
                break;
            }
            default: {
                stringBuffer.append("KeyEvent");
            }
        }
        stringBuffer.append("[code=").append(n2);
        stringBuffer.append(" char=");
        if (c == '\n') {
            stringBuffer.append("'\\n'");
        } else if (c == '\r') {
            stringBuffer.append("'\\r'");
        } else if (c == '\t') {
            stringBuffer.append("'\\t'");
        } else if (c < ' ') {
            stringBuffer.append("'?'");
        } else {
            stringBuffer.append("'").append(c).append("'");
        }
        if ((n3 & 8) != 0) {
            stringBuffer.append(" Alt");
        }
        if ((n3 & 2) != 0) {
            stringBuffer.append(" Ctrl");
        }
        if ((n3 & 4) != 0) {
            stringBuffer.append(" Meta");
        }
        if ((n3 & 1) != 0) {
            stringBuffer.append(" Shift");
        }
        stringBuffer.append("]");
        log.trace(stringBuffer.toString());
    }

    FocusManager(AwtShellManager awtShellManager) {
        this.shellManager = awtShellManager;
        this.shell = awtShellManager.getShell();
    }

    static class Traversal {
        BWidget first;
        BWidget prev;
        BWidget next;
        BWidget last;
        boolean saveNext;

        void dump() {
            System.out.println("  first: " + this.first);
            System.out.println("  prev:  " + this.prev);
            System.out.println("  next:  " + this.next);
            System.out.println("  last:  " + this.last);
        }

        Traversal() {
        }
    }
}

