/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BubbleHelp
extends Window {
    private static BubbleHelp window = new BubbleHelp(new Frame());
    private String[] text;
    private int delta;
    private Color foreground;
    private Color background;
    private Font font;

    public static void open(int n, int n2, String string) {
        window.setLocation(n, n2);
        window.setText(string);
        window.checkLocation();
        window.pack();
        window.setVisible(true);
    }

    public static void update(int n, int n2, String string) {
        window.setLocation(n, n2);
        window.setText(string);
        window.checkLocation();
        window.pack();
        window.repaint();
    }

    public static void close() {
        window.setVisible(false);
    }

    private final void setText(String string) {
        int n;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.delta = fontMetrics.getHeight();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = BubbleHelp.wrap(fontMetrics, n2, string2);
            n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
        }
        this.text = arrayList.toArray(new String[arrayList.size()]);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.text.length) {
            n = fontMetrics.stringWidth(this.text[n4]);
            if (n > n3) {
                n3 = n;
            }
            ++n4;
        }
        n4 = n3 + 8;
        n = this.delta * this.text.length + 4;
        this.setSize(n4, n);
    }

    public static String[] wrap(FontMetrics fontMetrics, int n, String string) {
        if (fontMetrics.stringWidth(string) < n - 10) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: while (fontMetrics.stringWidth(string) > n - 10) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < string.length()) {
                if (fontMetrics.charsWidth(cArray, 0, n2) > n - 20) {
                    arrayList.add(stringBuffer.toString());
                    string = string.substring(n2);
                    continue block0;
                }
                stringBuffer.append(cArray[n2]);
                ++n2;
            }
        }
        arrayList.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void checkLocation() {
        int n = this.getLocation().x;
        int n2 = this.getLocation().y;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle = null;
        int n5 = 0;
        while (n5 < graphicsDeviceArray.length) {
            rectangle = graphicsDeviceArray[n5].getDefaultConfiguration().getBounds();
            if (rectangle.contains(this.getLocation())) break;
            ++n5;
        }
        if (rectangle != null) {
            int n6;
            n5 = this.getLocation().x + n3 + 5 - (rectangle.x + rectangle.width);
            if (n5 > 0) {
                n -= n5;
            }
            if ((n6 = this.getLocation().y + n4 + 5 - (rectangle.y + rectangle.height)) > 0) {
                n2 -= n6;
                n2 -= n4 * 2;
            }
        }
        this.setLocation(n, n2);
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(this.foreground);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(this.background);
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        graphics.setColor(this.foreground);
        graphics.setFont(this.font);
        int n3 = 0;
        while (n3 < this.text.length) {
            graphics.drawString(this.text[n3], 4, (n3 + 1) * this.delta);
            ++n3;
        }
    }

    private final /* synthetic */ void this() {
        this.text = new String[0];
    }

    private BubbleHelp(Frame frame) {
        super(frame);
        this.this();
        this.setLayout(null);
        this.foreground = Color.black;
        this.background = Color.white;
        this.font = new Font(Theme.widget().getTextFont().getName(), 0, 11);
    }
}

