/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.DialogPeer;
import com.tridium.ui.FramePeer;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.UiEnv;
import com.tridium.ui.WindowPeer;
import com.tridium.ui.awt.AwtDialogPeer;
import com.tridium.ui.awt.AwtFramePeer;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtWindowPeer;
import com.tridium.ui.awt.BubbleHelp;
import com.tridium.ui.awt.NMouseCursor;
import com.tridium.ui.awt.NPopup;
import com.tridium.ui.awt.PanelPeer;
import com.tridium.ui.awt.TransferManager;
import com.tridium.ui.file.BNDirectoryChooser;
import com.tridium.ui.file.BNFileChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.BWindow;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AwtUiEnv
extends UiEnv {
    private static Insets frameInsets;
    private static Insets dialogInsets;
    private static Insets windowInsets;
    public final Frame defaultFrame;

    private final GraphicsDevice getScreenDevice(BWidget bWidget) {
        Window window = this.ownerToWindow(bWidget);
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        return graphicsConfiguration.getDevice();
    }

    public IRectGeom getDefaultScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        java.awt.Insets insets = this.getScreenInsets(graphicsConfiguration);
        RectGeom rectGeom = new RectGeom((double)(rectangle.x + insets.left), (double)(rectangle.y + insets.top), (double)(rectangle.width - insets.left - insets.right), (double)(rectangle.height - insets.top - insets.bottom));
        return rectGeom;
    }

    public IRectGeom getScreenBounds(double d, double d2) {
        Rectangle rectangle;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        GraphicsDevice graphicsDevice = null;
        int n = 0;
        while (n < graphicsDeviceArray.length) {
            rectangle = graphicsDeviceArray[n].getDefaultConfiguration().getBounds();
            if (rectangle.contains((int)d, (int)d2)) {
                graphicsDevice = graphicsDeviceArray[n];
                break;
            }
            ++n;
        }
        if (graphicsDevice == null) {
            graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        }
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        rectangle = graphicsConfiguration.getBounds();
        java.awt.Insets insets = this.getScreenInsets(graphicsConfiguration);
        RectGeom rectGeom = new RectGeom((double)(rectangle.x + insets.left), (double)(rectangle.y + insets.top), (double)(rectangle.width - insets.left - insets.right), (double)(rectangle.height - insets.top - insets.bottom));
        return rectGeom;
    }

    public IRectGeom getScreenBounds(BWidget bWidget) {
        if (bWidget == null) {
            return this.getDefaultScreenBounds();
        }
        AwtShellManager awtShellManager = (AwtShellManager)bWidget.widgetSupport(null);
        if (awtShellManager.isShowing()) {
            GraphicsConfiguration graphicsConfiguration = awtShellManager.getGraphicsConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            java.awt.Insets insets = this.getScreenInsets(graphicsConfiguration);
            return new RectGeom((double)(rectangle.x + insets.left), (double)(rectangle.y + insets.top), (double)(rectangle.width - insets.left - insets.right), (double)(rectangle.height - insets.top - insets.bottom));
        }
        ShellPeer shellPeer = awtShellManager.getShellPeer();
        if (shellPeer instanceof Window) {
            java.awt.Point point = ((Window)((Object)shellPeer)).getLocation();
            return this.getScreenBounds(point.x, point.y);
        }
        return this.getDefaultScreenBounds();
    }

    protected abstract java.awt.Insets getScreenInsets(GraphicsConfiguration var1);

    public Insets getWindowInsets(BWindow bWindow) {
        AwtShellManager awtShellManager = (AwtShellManager)bWindow.widgetSupport(null);
        Container container = (Container)((Object)awtShellManager.getShellPeer());
        while (container != null) {
            if (container instanceof Frame) {
                if (frameInsets == null) {
                    Frame frame = new Frame();
                    frame.setBounds(new Rectangle(-200, -200, 100, 100));
                    frame.setVisible(true);
                    java.awt.Insets insets = frame.getInsets();
                    frame.setVisible(false);
                    frame.dispose();
                    frameInsets = AwtUiEnv.makeInsets(insets);
                }
                return frameInsets;
            }
            if (container instanceof Dialog) {
                if (dialogInsets == null) {
                    Frame frame = new Frame();
                    frame.setBounds(new Rectangle(-200, -200, 100, 100));
                    frame.setVisible(true);
                    Dialog dialog = new Dialog(frame, "Test");
                    dialog.setBounds(-200, -200, 100, 100);
                    dialog.setVisible(true);
                    java.awt.Insets insets = dialog.getInsets();
                    dialog.setVisible(false);
                    dialog.dispose();
                    frame.setVisible(false);
                    frame.dispose();
                    dialogInsets = AwtUiEnv.makeInsets(insets);
                }
                return dialogInsets;
            }
            if (container instanceof Window) {
                if (windowInsets == null) {
                    Window window = new Window(awtShellManager.getWindow());
                    window.setBounds(-200, -200, 100, 100);
                    window.setVisible(true);
                    java.awt.Insets insets = window.getInsets();
                    window.setVisible(false);
                    window.dispose();
                    windowInsets = AwtUiEnv.makeInsets(insets);
                }
                return windowInsets;
            }
            container = container.getParent();
        }
        return null;
    }

    private static final Insets makeInsets(java.awt.Insets insets) {
        Insets insets2 = new Insets();
        insets2.top = insets.top;
        insets2.bottom = insets.bottom;
        insets2.left = insets.left;
        insets2.right = insets.right;
        return insets2;
    }

    public abstract boolean isIconified(Frame var1);

    public abstract void setIconified(Frame var1, boolean var2);

    public abstract boolean isMaximized(Frame var1);

    public abstract void setMaximized(Frame var1, boolean var2);

    public final ShellManager makeShellManager(BWidgetShell bWidgetShell) {
        ShellPeer shellPeer = bWidgetShell instanceof ShellManager.ShellPeerFactory ? ((ShellManager.ShellPeerFactory)((Object)bWidgetShell)).newShellPeer() : new PanelPeer();
        return this.makeAwtShellManager(bWidgetShell, shellPeer);
    }

    public final ShellManager makeShellManager(BWidgetShell bWidgetShell, ShellPeer shellPeer) {
        return this.makeAwtShellManager(bWidgetShell, shellPeer);
    }

    public abstract AwtShellManager makeAwtShellManager(BWidget var1, ShellPeer var2);

    public final FramePeer makeFramePeer(String string) {
        return new AwtFramePeer(string);
    }

    public final DialogPeer makeDialogPeer(BWidget bWidget, String string, boolean bl) {
        Window window = this.ownerToWindow(bWidget);
        if (window instanceof Dialog) {
            return new AwtDialogPeer((Dialog)window, string, bl);
        }
        if (window instanceof Frame) {
            return new AwtDialogPeer((Frame)window, string, bl);
        }
        return new AwtDialogPeer(this.defaultFrame, string, bl);
    }

    public final WindowPeer makeWindowPeer(BWidget bWidget) {
        Window window = this.ownerToWindow(bWidget);
        if (window instanceof Frame) {
            return new AwtWindowPeer((Frame)window);
        }
        return new AwtWindowPeer(window);
    }

    public WindowPeer makeRoundedWindowPeer(BWidget bWidget, float f, float f2) {
        return this.makeWindowPeer(bWidget);
    }

    public FramePeer makeRoundedFramePeer(String string, float f, float f2) {
        return this.makeFramePeer(string);
    }

    public DialogPeer makeRoundedDialogPeer(BWidget bWidget, String string, boolean bl, float f, float f2) {
        return this.makeDialogPeer(bWidget, string, bl);
    }

    protected Window ownerToWindow(BWidget bWidget) {
        Window window = null;
        if (bWidget != null) {
            AwtShellManager awtShellManager = (AwtShellManager)bWidget.widgetSupport(null);
            if (awtShellManager == null) {
                throw new IllegalArgumentException("Not in windowing system");
            }
            window = awtShellManager.getWindow();
        }
        if (window == null) {
            return this.defaultFrame;
        }
        return window;
    }

    Frame ownerToFrame(BWidget bWidget) {
        Container container = this.ownerToWindow(bWidget);
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return ((AwtUiEnv)AwtUiEnv.get()).defaultFrame;
    }

    public MouseCursor makeCursor(int n) {
        switch (n) {
            case 0: {
                return AwtUiEnv.toCursor(Cursor.getDefaultCursor());
            }
            case 1: {
                return AwtUiEnv.toCursor(1);
            }
            case 2: {
                return AwtUiEnv.toCursor(12);
            }
            case 3: {
                return AwtUiEnv.toCursor(13);
            }
            case 4: {
                return AwtUiEnv.toCursor(2);
            }
            case 5: {
                return AwtUiEnv.toCursor(3);
            }
            case 6: {
                return AwtUiEnv.toCursor(11);
            }
            case 7: {
                return AwtUiEnv.toCursor(10);
            }
            case 8: {
                return AwtUiEnv.toCursor(8);
            }
            case 9: {
                return AwtUiEnv.toCursor(9);
            }
            case 10: {
                return AwtUiEnv.toCursor(7);
            }
            case 11: {
                return AwtUiEnv.toCursor(6);
            }
            case 12: {
                return AwtUiEnv.toCursor(5);
            }
            case 13: {
                return AwtUiEnv.toCursor(4);
            }
            case 14: {
                return this.toCursor("grabHand", 16, 16, 0);
            }
            case 15: {
                return this.toCursor("openHand", 16, 16, 0);
            }
            case 16: {
                return this.toCursor("doNotEnter", 16, 16, 0);
            }
            case 17: {
                return this.toCursor("stacked", 16, 16, 0);
            }
            case 18: {
                return this.toCursor("dropLeft", 9, 16, 0);
            }
            case 19: {
                return this.toCursor("dropRight", 22, 16, 0);
            }
            case 20: {
                return this.toCursor("dropTop", 16, 9, 0);
            }
            case 21: {
                return this.toCursor("dropBottom", 16, 22, 0);
            }
            case 22: {
                return this.toCursor("dropper", 8, 23, 0);
            }
            case 25: {
                return this.toCursor("magnify", 16, 16, 0);
            }
            case 23: {
                return this.toCursor("linkLeft", 9, 16, 10);
            }
            case 24: {
                return this.toCursor("linkRight", 22, 16, 11);
            }
        }
        throw new IllegalStateException();
    }

    private static final MouseCursor toCursor(Cursor cursor) {
        return new NMouseCursor(cursor);
    }

    private static final MouseCursor toCursor(int n) {
        return new NMouseCursor(Cursor.getPredefinedCursor(n));
    }

    protected abstract MouseCursor toCursor(String var1, int var2, int var3, int var4);

    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public abstract BMouseEvent makeMouseWheelEvent(int var1, MouseEvent var2, BWidget var3, Point var4);

    public abstract Component getOpposite(FocusEvent var1);

    public boolean isPopupOpen(BWidget bWidget) {
        return NPopup.isOpen(bWidget);
    }

    public void openPopup(BWidget bWidget, BWidget bWidget2, double d, double d2) {
        NPopup.open(bWidget, bWidget2, d, d2);
    }

    public void openPopup(BWidget bWidget, BWidget bWidget2, double d, double d2, double d3, double d4) {
        NPopup.open(bWidget, bWidget2, d, d2, d3, d4);
    }

    public void closePopup(BWidget bWidget) {
        NPopup.close(bWidget);
    }

    public void openBubbleHelp(BWidget bWidget, double d, double d2, String string) {
        try {
            Point point = new Point(d, d2);
            point = bWidget.translateToScreen(point);
            BubbleHelp.open((int)point.x, (int)point.y, string);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {}
    }

    public void updateBubbleHelp(BWidget bWidget, double d, double d2, String string) {
        try {
            Point point = new Point(d, d2);
            point = bWidget.translateToScreen(point);
            BubbleHelp.update((int)point.x, (int)point.y, string);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {}
    }

    public void closeBubbleHelp() {
        BubbleHelp.close();
    }

    public void setPopupOpacity(BWidget bWidget, float f) {
    }

    public BFileChooser makeOpenFileChooser(BWidget bWidget) {
        return BNFileChooser.makeOpen(bWidget);
    }

    public BFileChooser makeSaveFileChooser(BWidget bWidget) {
        return BNFileChooser.makeSave(bWidget);
    }

    public BDirectoryChooser makeDirectoryChooser(BWidget bWidget) {
        return new BNDirectoryChooser(bWidget);
    }

    public UiEnv.ClipboardManager makeDefaultClipboardManager() {
        return TransferManager.defaultClipboardManager;
    }

    public abstract DataFlavor makeMarkDataFlavor() throws Exception;

    private final /* synthetic */ void this() {
        this.defaultFrame = new Frame();
    }

    public AwtUiEnv() {
        this.this();
    }
}

