/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.ImageManager;
import com.tridium.sys.Nre;
import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.PxIncludeManager;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.awt.DragOperation;
import com.tridium.ui.awt.FocusManager;
import com.tridium.ui.awt.MouseManager;
import com.tridium.ui.awt.NMouseCursor;
import com.tridium.ui.awt.Perf;
import com.tridium.ui.awt.WindowManager;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ThrowableUtil;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AwtShellManager
extends Panel
implements ShellManager {
    static CoalesceThread coalesceThread = new CoalesceThread();
    static int dumpCounter;
    public static volatile DragOperation dragOperation;
    static Cursor busyCursor;
    private static final boolean disableDoubleBuff;
    long coalesceDeadline;
    AwtShellManager coalesceNext;
    public final MouseManager mouseManager;
    public final BWidget shell;
    public final FocusManager focusManager;
    public final WindowManager windowManager;
    private ShellPeer peer;
    private int lastWidth;
    private int lastHeight;
    private Image buffer;
    private HashMap relayoutQueue;
    private Thread layoutThread;
    private Property mountProperty;
    private Object busyLock;
    private int busyCount;
    private ArrayList busyStack;
    private boolean isActivated;
    public Perf perf;

    public void activate() {
        this.mountProperty = BWidget.getApplication().add(null, (BValue)this.shell, null);
        this.shell.start();
        Window window = this.getWindow();
        if (window != null) {
            window.addWindowListener(this.windowManager);
            window.addComponentListener(this.windowManager);
        }
        this.isActivated = true;
    }

    public void deactivate() {
        Window window;
        this.isActivated = false;
        this.shell.stop();
        this.disposeBuffer();
        if (this.mountProperty != null) {
            BWidget.getApplication().remove(this.mountProperty, null);
            this.mountProperty = null;
        }
        if ((window = this.getWindow()) != null) {
            window.removeWindowListener(this.windowManager);
            window.removeComponentListener(this.windowManager);
        }
    }

    void disposeBuffer() {
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
    }

    public final BWidget getShell() {
        return this.shell;
    }

    public final ShellPeer getShellPeer() {
        return this.peer;
    }

    public final void repaint(BWidget bWidget, int n, int n2, int n3, int n4) {
        Point point = this.widgetToShell(bWidget, new Point((double)n, (double)n2));
        Point point2 = this.widgetToShell(bWidget, new Point((double)(n + n3), (double)(n2 + n4)));
        if (point.x < 0.0) {
            point.x = 0.0;
        }
        if (point.y < 0.0) {
            point.y = 0.0;
        }
        if (point2.x < 0.0) {
            point2.x = 0.0;
        }
        if (point2.y < 0.0) {
            point2.y = 0.0;
        }
        this.repaint((int)point.x, (int)point.y, (int)(point2.x - point.x), (int)(point2.y - point.y));
    }

    public final boolean hasFocus(BWidget bWidget) {
        return this.focusManager.hasFocus(bWidget);
    }

    public final void requestFocus(BWidget bWidget) {
        this.requestFocus();
        this.focusManager.requestFocus(bWidget);
    }

    public final BWidget getCurrentFocus() {
        return this.focusManager.getCurrentFocus();
    }

    public void takeTempFocus(AwtShellManager awtShellManager) {
        awtShellManager.focusManager.takeTempFocus(this);
    }

    public void releaseTempFocus(AwtShellManager awtShellManager) {
        awtShellManager.focusManager.releaseTempFocus(awtShellManager);
    }

    public void clearTempFocus() {
        this.focusManager.takeBack = false;
    }

    public final Window getWindow() {
        Container container = this.getParent();
        while (!(container instanceof Window)) {
            if (container == null) {
                return null;
            }
            container = container.getParent();
        }
        return (Window)container;
    }

    public final Point translateToScreen(BWidget bWidget, Point point) {
        java.awt.Point point2 = this.getLocationOnScreen();
        this.widgetToShell(bWidget, point);
        point.translate((double)point2.x, (double)point2.y);
        return point;
    }

    public final BKeyEvent getLastKeyEvent() {
        return this.focusManager.lastKeyEvent;
    }

    public void update(java.awt.Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(java.awt.Graphics graphics) {
        long l;
        long l2 = Perf.now();
        if (!this.isActivated) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Dimension dimension = this.getSize();
        rectangle.width = Math.min(rectangle.width, dimension.width);
        rectangle.height = Math.min(rectangle.height, dimension.height);
        if (dimension.width != this.lastWidth || dimension.height != this.lastHeight) {
            this.shell.setSize(dimension.width, dimension.height);
            this.lastWidth = dimension.width;
            this.lastHeight = dimension.height;
            if (this.buffer != null) {
                this.buffer.flush();
            }
            this.buffer = null;
        }
        if (this.buffer == null) {
            if (dimension.width <= 0) {
                dimension.width = 1;
            }
            if (dimension.height <= 0) {
                dimension.height = 1;
            }
            long l3 = Perf.now();
            this.buffer = this.createImage(dimension.width, dimension.height);
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            long l4 = Perf.now();
            this.perf.durCreateBuffer += l4 - l3;
        }
        Graphics2D graphics2D = null;
        try {
            if (!disableDoubleBuff) {
                graphics2D = (Graphics2D)this.buffer.getGraphics();
            }
        }
        catch (Exception exception) {
            System.out.println("AwtShellManager.paint.getGraphics " + exception);
            return;
        }
        if (graphics2D != null) {
            graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        long l5 = Perf.now();
        this.layoutWidgets();
        long l6 = Perf.now();
        this.perf.durWidgetLayout += l6 - l5;
        long l7 = Perf.now();
        boolean bl = ((BNiagaraWidgetApplication)BWidget.getApplication()).useAntiAlias();
        Graphics graphics2 = ((AwtEnv)AwtEnv.get()).makeGraphics(graphics2D == null ? (Graphics2D)graphics : graphics2D);
        graphics2.useAntiAliasing(bl);
        graphics2.setBrush(Theme.widget().getControlBackground());
        graphics2.fillRect((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
        long l8 = Perf.now();
        this.perf.durClearClip += l8 - l7;
        long l9 = Perf.now();
        this.shell.paint(graphics2);
        long l10 = Perf.now();
        this.perf.durWidgetPaint += l10 - l9;
        DragOperation dragOperation = AwtShellManager.dragOperation;
        if (dragOperation != null) {
            dragOperation.paintDragEffect(this, graphics2);
        }
        if (graphics2D != null) {
            graphics2.dispose();
            graphics2 = null;
            graphics2D.dispose();
            graphics2D = null;
            try {
                l = Perf.now();
                graphics.drawImage(this.buffer, 0, 0, null);
                long l11 = Perf.now();
                this.perf.durDrawBuffer += l11 - l;
            }
            catch (Exception exception) {
                System.out.println("AwtShellManager.paint.drawImage: " + exception);
            }
        }
        l = Perf.now();
        ++this.perf.numShellPaint;
        this.perf.durTotalPaint += l - l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void layoutWidgets() {
        block5: {
            BWidget[] bWidgetArray = null;
            HashMap hashMap = this.relayoutQueue;
            synchronized (hashMap) {
                if (this.relayoutQueue.size() > 0) {
                    Collection collection = this.relayoutQueue.values();
                    bWidgetArray = collection.toArray(new BWidget[collection.size()]);
                    this.relayoutQueue.clear();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                if (bWidgetArray == null) break block5;
            }
            this.layoutThread = Thread.currentThread();
            int n = 0;
            while (n < bWidgetArray.length) {
                bWidgetArray[n].layout();
                ++n;
            }
            this.layoutThread = null;
            this.checkMouseOver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void relayout(BWidget bWidget, boolean bl) {
        block4: {
            HashMap hashMap = this.relayoutQueue;
            synchronized (hashMap) {
                if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(bWidget) == null) {
                    this.relayoutQueue.put(bWidget, bWidget);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                if (!bl) break block4;
                this.layoutWidgets();
            }
            this.repaint();
            return;
        }
        coalesceThread.repaint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enqueueRelayout(BWidget bWidget) {
        HashMap hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(bWidget) == null) {
                this.relayoutQueue.put(bWidget, bWidget);
                return true;
            }
            return false;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        DragOperation dragOperation = AwtShellManager.dragOperation;
        if (dragOperation != null) {
            dragOperation.process(this, mouseEvent);
        }
        this.mouseManager.process(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        DragOperation dragOperation = AwtShellManager.dragOperation;
        if (dragOperation != null) {
            dragOperation.process(this, mouseEvent);
        }
        this.mouseManager.process(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.focusManager.process(focusEvent);
        super.processFocusEvent(focusEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        DragOperation dragOperation = AwtShellManager.dragOperation;
        if (dragOperation != null) {
            dragOperation.process(this, keyEvent);
        }
        this.focusManager.process(keyEvent);
        super.processKeyEvent(keyEvent);
    }

    public void resetHover(BWidget bWidget) {
        this.mouseManager.resetHover(bWidget);
    }

    public final BWidget widgetAt(Point point, boolean bl) {
        if (!this.shell.isEnabled()) {
            return null;
        }
        return this.widgetAt(this.shell, point, bl);
    }

    public final BWidget widgetAt(BWidget bWidget, Point point, boolean bl) {
        BWidget bWidget2 = bWidget.childAt(point);
        if (bWidget2 != null && bWidget2.isEnabled()) {
            return this.widgetAt(bWidget2, bWidget.translateToChild(bWidget2, point), bl);
        }
        return bWidget;
    }

    public final Point widgetToShell(BWidget bWidget, Point point) {
        return bWidget.translateToAncestor(this.shell, point);
    }

    public final Point shellToWidget(BWidget bWidget, Point point) {
        try {
            return bWidget.translateFromAncestor(this.shell, point);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("WARNING: NWidgetContext.shellToWidget() NullPointerException");
            return new Point(0.0, 0.0);
        }
    }

    public void checkMouseOver() {
        this.mouseManager.checkOver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMouseCursor() {
        Object object = this.busyLock;
        synchronized (object) {
            if (this.busyCount == 0) {
                BWidget bWidget = this.mouseManager.over;
                MouseCursor mouseCursor = null;
                if (bWidget != null) {
                    mouseCursor = bWidget.getMouseCursor();
                }
                if (mouseCursor == null) {
                    mouseCursor = MouseCursor.normal;
                }
                this.setCursor(((NMouseCursor)mouseCursor).cursor);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enterBusy(BWidget bWidget) {
        Object object = this.busyLock;
        synchronized (object) {
            ++this.busyCount;
            if (this.busyCount == 1) {
                this.setCursor(busyCursor);
            }
            this.busyStack.add(ThrowableUtil.getStack());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exitBusy(BWidget bWidget) {
        Object object = this.busyLock;
        synchronized (object) {
            --this.busyCount;
            if (this.busyCount < 0) {
                this.busyCount = 0;
            }
            if (this.busyCount == 0) {
                this.updateMouseCursor();
            }
            if (this.busyStack.size() > 0) {
                this.busyStack.remove(this.busyStack.size() - 1);
            }
            return;
        }
    }

    public void debug() {
        BWidget bWidget = this.focusManager.getCurrentFocus();
        System.out.println("###########################################################################");
        System.out.println("# " + dumpCounter++ + "  [" + new Date() + ']');
        System.out.println("# Focus: " + bWidget == null ? "null" : bWidget.toDebugString());
        int n = 0;
        while (n < this.busyStack.size()) {
            System.out.println("----- busyStack[" + n + "] -----");
            System.out.println(this.busyStack.get(n));
            ++n;
        }
        if (this.shell instanceof DebugShell) {
            ((DebugShell)((Object)this.shell)).debug();
        }
        ImageManager.trimAll();
        PxIncludeManager.trimAll();
        this.perf.dump();
        System.gc();
        System.out.println("###########################################################################");
    }

    public boolean isDesignTime() {
        return false;
    }

    private final /* synthetic */ void this() {
        this.lastWidth = -1;
        this.lastHeight = -1;
        this.relayoutQueue = new HashMap();
        this.busyLock = new Object();
        this.busyStack = new ArrayList();
        this.isActivated = true;
        this.perf = new Perf(this);
    }

    public AwtShellManager(BWidget bWidget, ShellPeer shellPeer) {
        this.this();
        dragOperation = null;
        this.setLayout(null);
        this.shell = bWidget;
        this.peer = shellPeer;
        shellPeer.installShellManager(this);
        if (this.getParent() != shellPeer) {
            throw new IllegalStateException();
        }
        this.relayout(bWidget, false);
        this.enableEvents(60L);
        this.mouseManager = new MouseManager(this);
        this.focusManager = new FocusManager(this);
        this.windowManager = new WindowManager(this);
    }

    static {
        coalesceThread.start();
        dumpCounter = 0;
        busyCursor = Cursor.getPredefinedCursor(3);
        disableDoubleBuff = System.getProperty("bajaui.disableDoubleBuff", "false").equals("true");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class CoalesceThread
    extends Thread {
        Object lock;
        AwtShellManager head;
        AwtShellManager tail;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void repaint(AwtShellManager awtShellManager) {
            long l = Clock.ticks();
            Object object = this.lock;
            synchronized (object) {
                block3: {
                    block4: {
                        if (awtShellManager.coalesceDeadline != 0L) break block3;
                        if (this.head != null) break block4;
                        this.head = this.tail = awtShellManager;
                        break block3;
                    }
                    this.tail.coalesceNext = awtShellManager;
                    this.tail = awtShellManager;
                }
                awtShellManager.coalesceDeadline = l + 10L;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    block6: while (true) {
                        Thread.sleep(10L);
                        long l = Clock.ticks();
                        Object object = this.lock;
                        synchronized (object) {
                            AwtShellManager awtShellManager = null;
                            AwtShellManager awtShellManager2 = this.head;
                            while (true) {
                                if (awtShellManager2 == null) {
                                    continue block6;
                                }
                                AwtShellManager awtShellManager3 = awtShellManager2.coalesceNext;
                                if (awtShellManager2.coalesceDeadline <= l) {
                                    awtShellManager2.coalesceDeadline = 0L;
                                    if (awtShellManager == null) {
                                        this.head = awtShellManager3;
                                    } else {
                                        awtShellManager.coalesceNext = awtShellManager3;
                                    }
                                    if (awtShellManager3 == null) {
                                        this.tail = awtShellManager;
                                    }
                                    awtShellManager2.coalesceNext = null;
                                    awtShellManager2.repaint();
                                } else {
                                    awtShellManager = awtShellManager2;
                                }
                                awtShellManager2 = awtShellManager3;
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private final /* synthetic */ void this() {
            this.lock = new Object();
        }

        CoalesceThread() {
            super(Nre.mainThreadGroup, "Ui:CoalesceThread");
            this.this();
            this.setDaemon(true);
        }
    }

    public static interface DebugShell {
        public void debug();
    }

    public static interface ShellPeerFactory {
        public ShellPeer newShellPeer();
    }
}

