/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.ui.Binder;
import java.io.ByteArrayInputStream;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.user.BUser;

public class PxCache {
    static final BUser dummyUser = new BUser();
    static HashMap cache = new HashMap();
    static Log log = Log.getLog((String)"px.cache");

    public static synchronized Item get(OrdTarget ordTarget, BAbstractPxView bAbstractPxView) throws Exception {
        return PxCache.get(ordTarget, bAbstractPxView != null ? bAbstractPxView.getName() : "", bAbstractPxView);
    }

    public static synchronized Item get(OrdTarget ordTarget, String string, BAbstractPxView bAbstractPxView) throws Exception {
        BComponent bComponent;
        Key key;
        Item item;
        BObject bObject = ordTarget.get();
        BOrd bOrd = BOrd.NULL;
        String string2 = "";
        if (bObject instanceof BDataFile) {
            bOrd = ordTarget.getOrd();
        } else {
            if (bAbstractPxView == null) {
                throw new IllegalArgumentException("pxView cannot be null when using " + bObject.getType());
            }
            if (bAbstractPxView instanceof BPxView) {
                bOrd = ((BPxView)bAbstractPxView).getPxFile();
            } else if (bAbstractPxView instanceof BDynamicPxView) {
                string2 = ((BDynamicPxView)bAbstractPxView).getUniqueId(ordTarget);
            } else {
                throw new IllegalArgumentException("Don't know how to handle " + bAbstractPxView.getType());
            }
        }
        if (log.isTraceOn()) {
            log.trace(ordTarget.getOrd() + " [" + bObject.getType() + "] px=" + bOrd);
        }
        if ((item = (Item)cache.get(key = new Key(bObject, bOrd, string2, (Context)ordTarget))) != null) {
            if (item.hasFileBeenModified()) {
                if (log.isTraceOn()) {
                    log.trace("  cache out of date");
                }
                cache.remove(key);
            } else {
                if (log.isTraceOn()) {
                    log.trace("  cached");
                }
                PxCache.bindAll(bObject, item.widget, (Context)ordTarget);
                item.lastUsedTicks = Clock.ticks();
                return item;
            }
        }
        int n = PxCache.getMaxCacheSize();
        while (cache.size() > n - 1) {
            PxCache.removeLeastRecentlyUsed();
        }
        BasicContext basicContext = new BasicContext(ordTarget.getUser(), ordTarget.getLanguage());
        BIFile bIFile = null;
        if (log.isTraceOn()) {
            log.trace("  load");
        }
        BWidget bWidget = null;
        if (!bOrd.isNull()) {
            bIFile = (BIFile)bOrd.get(bObject);
            bWidget = new PxDecoder(bIFile, (Context)basicContext).decodeDocument();
        } else {
            String string3;
            bComponent = ordTarget.getComponent();
            if (bAbstractPxView != null && string != null && bAbstractPxView instanceof BDynamicPxView && Sys.getStation() == null && bComponent != null && bComponent.isMounted()) {
                try {
                    string3 = "reflectProperty:" + string + ":generateXml";
                    BString bString = (BString)bComponent.getComponentSpace().fw(109, (Object)bComponent, (Object)string3, null, (Object)ordTarget);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bString.toString().getBytes());
                    bWidget = new PxDecoder(bComponent.getNavOrd(), byteArrayInputStream, (Context)ordTarget).decodeDocument();
                }
                catch (Throwable throwable) {}
            }
            if (bWidget == null) {
                string3 = ((BDynamicPxView)bAbstractPxView).generateXml((Object)bObject, (Context)ordTarget);
                bWidget = new PxDecoder(ordTarget.getOrd(), new StringBufferInputStream(string3), (Context)basicContext).decodeDocument();
            }
        }
        bComponent = PxCache.load(bObject, bWidget, (Context)ordTarget);
        item = new Item(key, bIFile, (BComponentSpace)bComponent);
        item.lastUsedTicks = Clock.ticks();
        cache.put(key, item);
        return item;
    }

    static int getMaxCacheSize() {
        try {
            return Integer.parseInt(System.getProperty("niagara.ui.pxCache.max", "10"));
        }
        catch (Exception exception) {
            return 10;
        }
    }

    static void removeLeastRecentlyUsed() {
        Iterator iterator = cache.values().iterator();
        Item item = null;
        while (iterator.hasNext()) {
            Item item2 = (Item)iterator.next();
            if (item != null && item2.lastUsedTicks >= item.lastUsedTicks) continue;
            item = item2;
        }
        if (item != null) {
            if (log.isTraceOn()) {
                log.trace("  remove LRU " + item.key);
            }
            cache.remove(item.key);
        }
    }

    static BComponentSpace load(BObject bObject, BWidget bWidget, Context context) throws Exception {
        PxCache.bindAll(bObject, bWidget, context);
        BComponentSpace bComponentSpace = new BComponentSpace("foo", null, BOrd.make((String)"foo:"));
        bComponentSpace.setRootComponent((BComponent)bWidget);
        return bComponentSpace;
    }

    static void bindAll(BObject bObject, BComponent bComponent, Context context) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (bComponent2 instanceof BBinding) {
                PxCache.bind(bObject, (BBinding)bComponent2, context);
                continue;
            }
            PxCache.bindAll(bObject, bComponent2, context);
        }
    }

    static void bind(BObject bObject, BBinding bBinding, Context context) {
        block5: {
            BOrd bOrd = bBinding.getOrd();
            try {
                OrdTarget ordTarget = bOrd.resolve(bObject, context);
                if (!ordTarget.canRead()) {
                    throw new PermissionException();
                }
                Binder.updateBinding(bBinding, ordTarget);
            }
            catch (PermissionException permissionException) {
                if (bOrd != null && !bOrd.isNull()) {
                    Binder.log.warning("no read permission: " + bOrd);
                }
            }
            catch (Exception exception) {
                if (bOrd == null || bOrd.isNull()) break block5;
                Binder.log.warning("unresolved: " + bOrd);
            }
        }
    }

    static {
        Spy.ROOT.add("pxCache", (Spy)new PxCacheSpy());
    }

    static class Key {
        BObject target;
        BOrd pxFileOrd;
        String uid;
        BUser user;
        String lang;
        int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            boolean bl = false;
            if (this.target.equals((Object)key.target) && this.pxFileOrd.equals((Object)key.pxFileOrd) && this.uid.equals(key.uid) && this.lang.equals(key.lang) && this.user == key.user) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.targetToString() + ' ' + this.pxFileOrd + ' ' + this.uid;
        }

        public String targetToString() {
            if (this.target.isComponent()) {
                return this.target.asComponent().toPathString();
            }
            return this.target.toDebugString();
        }

        Key(BObject bObject, BOrd bOrd, String string, Context context) {
            this.target = bObject;
            this.pxFileOrd = bOrd;
            this.uid = string;
            if (context != null) {
                this.user = context.getUser();
                this.lang = context.getLanguage();
            }
            if (this.lang == null) {
                this.lang = Sys.getLanguage();
            }
            if (this.user == null) {
                this.user = dummyUser;
            }
            this.hashCode = bObject.hashCode() ^ bOrd.hashCode() ^ string.hashCode() ^ this.lang.hashCode() ^ this.user.hashCode();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Item {
        long lastUsedTicks;
        final Key key;
        final BIFile file;
        final BAbsTime fileTime;
        public final BComponentSpace space;
        public final BWidget widget;
        public final HashMap cache;

        boolean hasFileBeenModified() {
            if (this.file == null) {
                return false;
            }
            BIFile bIFile = (BIFile)this.file.getNavOrd().get();
            return bIFile.getLastModified().equals((Object)this.fileTime) ^ true;
        }

        private final /* synthetic */ void this() {
            this.cache = new HashMap();
        }

        Item(Key key, BIFile bIFile, BComponentSpace bComponentSpace) {
            this.this();
            this.key = key;
            this.file = bIFile;
            this.fileTime = bIFile == null ? BAbsTime.NULL : bIFile.getLastModified();
            this.space = bComponentSpace;
            this.widget = (BWidget)bComponentSpace.getRootComponent();
        }
    }

    static class PxCacheSpy
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            Object[] objectArray = cache.values().toArray(new Item[cache.size()]);
            long l = Clock.ticks();
            Object[] objectArray2 = new Long[objectArray.length];
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = new Long(l - ((Item)objectArray[n]).lastUsedTicks);
                ++n;
            }
            SortUtil.sort((Object[])objectArray2, (Object[])objectArray);
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("PxCache [max=" + PxCache.getMaxCacheSize() + ']'), 4);
            spyWriter.w((Object)"<tr>").th((Object)"Target").th((Object)"PxFile").th((Object)"UID").th((Object)"Age").w((Object)"</tr>\n");
            n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String string = BRelTime.toString((long)(l - ((Item)object).lastUsedTicks));
                spyWriter.tr((Object)((Item)object).key.targetToString(), (Object)((Item)object).key.pxFileOrd, (Object)((Item)object).key.uid, (Object)string);
                ++n;
            }
            spyWriter.endTable();
        }

        PxCacheSpy() {
        }
    }
}

