/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class KeyboardLayout {
    private static HashMap layouts = new HashMap();
    private static final BOrd defLayout = BOrd.make((String)"module://bajaui/com/tridium/ui/keyboard.xml");
    private ArrayList rows;

    public static KeyboardLayout make() throws Exception {
        String string = Sys.getLanguage();
        BOrd bOrd = null;
        bOrd = string.equals("en") ? defLayout : BOrd.make((String)("file:!lexicon/" + string + "/keyboard.xml"));
        return KeyboardLayout.make(bOrd);
    }

    public static KeyboardLayout make(BOrd bOrd) throws Exception {
        KeyboardLayout keyboardLayout = (KeyboardLayout)layouts.get(bOrd.toString(null));
        if (keyboardLayout == null) {
            keyboardLayout = new KeyboardLayout();
            try {
                BIFile bIFile = (BIFile)bOrd.resolve().get();
                InputStream inputStream = bIFile.getInputStream();
                keyboardLayout.parse(inputStream);
                layouts.put(bOrd.toString(null), keyboardLayout);
            }
            catch (Exception exception) {
                System.out.println("### Can't load keyboard for '" + bOrd.toString(null) + "', falling back to default.");
                BIFile bIFile = (BIFile)defLayout.resolve().get();
                InputStream inputStream = bIFile.getInputStream();
                keyboardLayout.parse(inputStream);
                layouts.put(bOrd.toString(null), keyboardLayout);
            }
        }
        return keyboardLayout;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getKeyCount(int n) {
        return ((Key[])this.rows.get(n)).length;
    }

    public Key getKey(int n, int n2) {
        Key[] keyArray = (Key[])this.rows.get(n);
        return keyArray[n2];
    }

    public void parse(InputStream inputStream) throws Exception {
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        if (!xElem.name().equals("keyboard")) {
            throw new XException("Expecting <keyboard> not <" + xElem.name() + '>', xElem);
        }
        if (xElem.attrSize() != 0) {
            throw new XException("No attributes allowed on <keyboard>", xElem);
        }
        this.parseRows(xElem.elems());
    }

    private final void parseRows(XElem[] xElemArray) {
        this.rows = new ArrayList();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem = xElemArray[n];
            if (!xElem.name().equals("row")) {
                throw new XException("Expecting <row> not <" + xElem.name() + '>', xElem);
            }
            if (xElem.attrSize() != 0) {
                throw new XException("No attributes allowed on <row>", xElem);
            }
            this.rows.add(this.parseRow(xElem.elems()));
            ++n;
        }
    }

    private final Key[] parseRow(XElem[] xElemArray) {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem = xElemArray[n];
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (!xElem.name().equals("key")) {
                throw new XException("Expecting <key> not <" + xElem.name() + '>', xElem);
            }
            if (xElem.elems().length != 0) {
                throw new XException("No children allowed in <key>", xElem);
            }
            int n2 = 0;
            while (n2 < xElem.attrSize()) {
                String string6 = xElem.attrName(n2);
                String string7 = xElem.attrValue(n2);
                if (string6.equals("code")) {
                    string = string7;
                } else if (string6.equals("normal")) {
                    string2 = string7;
                } else if (string6.equals("shift")) {
                    string3 = string7;
                } else if (string6.equals("alt")) {
                    string4 = string7;
                } else if (string6.equals("label")) {
                    string5 = string7;
                } else {
                    throw new XException("Invalid attribute for <key>: '" + string6 + '\'', xElem);
                }
                ++n2;
            }
            if (string == null) {
                throw new XException("'code' attribute required for <key>", xElem);
            }
            if (string2 == null) {
                throw new XException("'normal' attribute required for <key>", xElem);
            }
            Key key = new Key();
            try {
                key.code = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XException("'code' value must be an integer: " + string, xElem);
            }
            if (string2.length() != 1) {
                throw new XException("'normal' value must be 1 char long: " + string2, xElem);
            }
            if (string3 != null && string3.length() != 1) {
                throw new XException("'shift' value must be 1 char long: " + string3, xElem);
            }
            if (string4 != null && string4.length() != 1) {
                throw new XException("'alt' value must be 1 char long: " + string4, xElem);
            }
            key.normal = string2.charAt(0);
            key.shift = string3 == null ? key.normal : string3.charAt(0);
            key.alt = string4 == null ? key.normal : string4.charAt(0);
            key.label = string5;
            arrayList.add(key);
            ++n;
        }
        return arrayList.toArray(new Key[arrayList.size()]);
    }

    public static class Key {
        public int code;
        public char normal;
        public char shift;
        public char alt;
        public String label;
    }
}

