/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRoundedPopup
extends BRoundedDialog {
    public static final Property yesButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_yes"), null);
    public static final Property noButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_no"), null);
    public static final Property okButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_ok"), null);
    public static final Property cancelButton = BRoundedPopup.newProperty((int)0, (BValue)new BButton("_cancel"), null);
    public static final Action buttonPressed = BRoundedPopup.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE;
    private int buttons;
    private BImage icon;
    private RectGeom iconRect;
    private RectGeom contentRect;
    private RectGeom buttonsRect;
    private RectGeom titleRect;
    private Size buttonDim;
    private int result;
    private BWidget title;
    static /* synthetic */ Class class$com$tridium$ui$BRoundedPopup;

    public BButton getYesButton() {
        return (BButton)this.get(yesButton);
    }

    public void setYesButton(BButton bButton) {
        this.set(yesButton, (BValue)bButton, null);
    }

    public BButton getNoButton() {
        return (BButton)this.get(noButton);
    }

    public void setNoButton(BButton bButton) {
        this.set(noButton, (BValue)bButton, null);
    }

    public BButton getOkButton() {
        return (BButton)this.get(okButton);
    }

    public void setOkButton(BButton bButton) {
        this.set(okButton, (BValue)bButton, null);
    }

    public BButton getCancelButton() {
        return (BButton)this.get(cancelButton);
    }

    public void setCancelButton(BButton bButton) {
        this.set(cancelButton, (BValue)bButton, null);
    }

    public void buttonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(buttonPressed, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final void init() {
        this.linkTo("linkA", this.getOkButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkB", this.getCancelButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkC", this.getYesButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkD", this.getNoButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        UiLexicon uiLexicon = UiLexicon.bajaui();
        if ((this.buttons & 4) != 0) {
            this.getYesButton().setText(uiLexicon.getText("dialog.yes"));
        } else {
            this.getYesButton().setVisible(false);
        }
        if ((this.buttons & 8) != 0) {
            this.getNoButton().setText(uiLexicon.getText("dialog.no"));
        } else {
            this.getNoButton().setVisible(false);
        }
        if ((this.buttons & 1) != 0) {
            this.getOkButton().setText(uiLexicon.getText("dialog.ok"));
        } else {
            this.getOkButton().setVisible(false);
        }
        if ((this.buttons & 2) != 0) {
            this.getCancelButton().setText(uiLexicon.getText("dialog.cancel"));
        } else {
            this.getCancelButton().setVisible(false);
        }
        if ((this.buttons & 1) != 0) {
            this.setDefaultButton(this.getOkButton());
        } else if ((this.buttons & 4) != 0) {
            this.setDefaultButton(this.getYesButton());
        }
    }

    public void computePreferredSize() {
        this.computeIconPrefSize();
        this.computeTitlePrefSize();
        this.computeContentPrefSize();
        this.computeButtonsPrefSize();
        double d = this.iconRect.width;
        double d2 = this.iconRect.height;
        double d3 = this.titleRect.height;
        double d4 = this.contentRect.width;
        double d5 = this.contentRect.height;
        double d6 = this.buttonsRect.width;
        double d7 = this.buttonsRect.height;
        double d8 = Math.max(d + d4, d6);
        double d9 = Math.max(d2, d5) + d7 + d3;
        this.setPreferredSize(d8, d9);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.computePreferredSize();
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.layoutButtons(d, d2);
        this.layoutContentAndIcon(d, d2);
    }

    private final void computeIconPrefSize() {
        if (this.icon == null) {
            this.iconRect.height = 0.0;
            this.iconRect.width = 0.0;
        } else {
            this.iconRect.width = this.icon.getWidth() + 8.0;
            this.iconRect.height = this.icon.getHeight() + 8.0;
        }
    }

    private final void computeTitlePrefSize() {
        if (this.title == null) {
            this.titleRect.height = 0.0;
            this.titleRect.width = 0.0;
        } else {
            this.titleRect.height = this.title.getPreferredHeight();
            this.titleRect.width = this.getWidth();
        }
    }

    private final void computeContentPrefSize() {
        BWidget bWidget = this.getContent();
        bWidget.computePreferredSize();
        this.contentRect.width = bWidget.getPreferredWidth() + 12.0;
        this.contentRect.height = bWidget.getPreferredHeight() + 8.0;
        if (!(bWidget instanceof BTextEditorPane) && (bWidget instanceof BScrollPane || bWidget instanceof BTabbedPane)) {
            this.contentRect.width = 400.0;
            this.contentRect.height = 300.0;
        }
    }

    private final void computeButtonsPrefSize() {
        BButton bButton;
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        if ((this.buttons & 4) != 0) {
            bButton = this.getYesButton();
            bButton.computePreferredSize();
            d2 = Math.max(d2, bButton.getPreferredWidth());
            d = Math.max(d, bButton.getPreferredHeight());
            ++n;
        }
        if ((this.buttons & 8) != 0) {
            bButton = this.getNoButton();
            bButton.computePreferredSize();
            d2 = Math.max(d2, bButton.getPreferredWidth());
            d = Math.max(d, bButton.getPreferredHeight());
            ++n;
        }
        if ((this.buttons & 1) != 0) {
            bButton = this.getOkButton();
            bButton.computePreferredSize();
            d2 = Math.max(d2, bButton.getPreferredWidth());
            d = Math.max(d, bButton.getPreferredHeight());
            ++n;
        }
        if ((this.buttons & 2) != 0) {
            bButton = this.getCancelButton();
            bButton.computePreferredSize();
            d2 = Math.max(d2, bButton.getPreferredWidth());
            d = Math.max(d, bButton.getPreferredHeight());
            ++n;
        }
        this.buttonDim.width = d2;
        this.buttonDim.height = d;
        this.buttonsRect.width = d2 * (double)n + (double)(4 * (n - 1)) + 8.0;
        this.buttonsRect.height = d + 8.0;
    }

    private final void layoutButtons(double d, double d2) {
        double d3 = this.buttonsRect.x = (d - this.buttonsRect.width) / (double)2 + (double)4;
        double d4 = this.buttonsRect.y = d2 - this.buttonDim.height - (double)4;
        double d5 = this.buttonDim.width;
        double d6 = this.buttonDim.height;
        if ((this.buttons & 4) != 0) {
            this.getYesButton().setBounds(d3, d4, d5, d6);
            d3 += d5 + (double)4;
        } else {
            this.getYesButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 8) != 0) {
            this.getNoButton().setBounds(d3, d4, d5, d6);
            d3 += d5 + (double)4;
        } else {
            this.getNoButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 1) != 0) {
            this.getOkButton().setBounds(d3, d4, d5, d6);
            d3 += d5 + (double)4;
        } else {
            this.getOkButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 2) != 0) {
            this.getCancelButton().setBounds(d3, d4, d5, d6);
            d3 += d5 + (double)4;
        } else {
            this.getCancelButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    private final void layoutContentAndIcon(double d, double d2) {
        double d3;
        BWidget bWidget;
        double d4 = this.buttonsRect.y - 8.0;
        if (this.icon == null) {
            this.iconRect.y = 0.0;
            this.iconRect.x = 0.0;
        } else {
            this.iconRect.x = 4;
            this.iconRect.y = (d4 - this.iconRect.height) / (double)2 + (double)4;
        }
        double d5 = this.titleRect.height;
        BWidget bWidget2 = this.getContent();
        if (bWidget2 instanceof BEdgePane && (bWidget = ((BEdgePane)bWidget2).getTop()) instanceof BWizardHeader) {
            d5 = 0.0;
        }
        double d6 = this.iconRect.x + this.iconRect.width + d5;
        double d7 = d5;
        double d8 = d3 = d - d6 - d5;
        double d9 = d4;
        this.contentRect.x = d6;
        this.contentRect.y = d7;
        this.contentRect.width = d8;
        this.contentRect.height = d9;
        this.getContent().setBounds(d6, d7, d8, d9);
    }

    public void paint(Graphics graphics) {
        this.paintChildren(graphics);
        if (this.icon != null) {
            graphics.drawImage(this.icon, this.iconRect.x, this.iconRect.y);
        }
        double d = this.getWidth();
        double d2 = this.getHeight();
        int n = (int)(this.arcWidth / 2.0f);
        int n2 = (int)(this.arcHeight / 2.0f);
        graphics.setPen(BPen.make((double)1.0));
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, (double)n, 0.0, d2 - (double)n);
        graphics.strokeLine((double)n, 0.0, d - (double)n, 0.0);
        graphics.strokeLine(d - 1.0, (double)n2, d - 1.0, d2 - (double)n2);
        graphics.strokeLine((double)n, d2 - 1.0, d - (double)n, d2 - 1.0);
        IPathGeom.Segment[] segmentArray = new IPathGeom.Segment[]{new IPathGeom.MoveTo(true, 0.0, (double)(n2 - 1)), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, (double)n, 0.0), new IPathGeom.MoveTo(true, d - (double)n, 0.0), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, d - 1.0, (double)n2), new IPathGeom.MoveTo(true, d - 1.0, d2 - (double)n2 - 1.0), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, d - (double)n, d2 - 1.0), new IPathGeom.MoveTo(true, (double)(n - 1), d2 - 1.0), new IPathGeom.ArcTo(true, (double)this.arcWidth, (double)this.arcHeight, 0.0, false, false, 0.0, d2 - (double)n2 - 1.0)};
        graphics.stroke((IGeom)BPathGeom.make((IPathGeom.Segment[])segmentArray));
    }

    public int getResult() {
        return this.result;
    }

    public void close(int n) {
        this.result = n;
        this.close();
    }

    public void open() {
        super.open();
    }

    public void doButtonPressed(BWidgetEvent bWidgetEvent) {
        BWidget bWidget = bWidgetEvent.getWidget();
        if (bWidget == this.getOkButton()) {
            this.close(1);
        }
        if (bWidget == this.getCancelButton()) {
            this.close(2);
        }
        if (bWidget == this.getYesButton()) {
            this.close(4);
        }
        if (bWidget == this.getNoButton()) {
            this.close(8);
        }
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.result = (this.buttons & 2) != 0 ? 2 : ((this.buttons & 1) != 0 ? 1 : ((this.buttons & 8) != 0 ? 8 : ((this.buttons & 4) != 0 ? 4 : 2)));
        this.close();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.iconRect = new RectGeom();
        this.contentRect = new RectGeom();
        this.buttonsRect = new RectGeom();
        this.titleRect = new RectGeom();
        this.buttonDim = new Size();
    }

    public BRoundedPopup() {
        this.this();
        throw new IllegalStateException();
    }

    public BRoundedPopup(BWidget bWidget, BWidget bWidget2, BWidget bWidget3, int n) {
        this(bWidget, bWidget2, bWidget3, 10.0f, 10.0f, n);
    }

    public BRoundedPopup(BWidget bWidget, BWidget bWidget2, String string, float f, float f2, int n) {
        super(bWidget, string, true, bWidget2, f, f2);
        this.this();
        this.buttons = n;
        this.setContent(new BNullWidget());
        BLabel bLabel = new BLabel(string);
        bLabel.setFont(Theme.label().getLargeBoldFont());
        bLabel.setForeground(Theme.toolPane().getForeground(this, false));
        BBrush bBrush = BBrush.makeSolid((BColor)BColor.black);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bLabel, BBorder.make(1.0, 1, bBrush, 0.0, 0, bBrush, 1.0, 1, bBrush, 0.0, 0, bBrush));
        bBorderPane.setPadding(BInsets.make((double)3, (double)0.0, (double)2, (double)0.0));
        bBorderPane.setFill(Theme.toolPane().getBackground(this, false));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter(new BBorderPane(bWidget2, 10.0, 5, 0.0, 5));
        bEdgePane.setTop(bBorderPane);
        this.setContent(bEdgePane);
        this.linkTo(bBorderPane, (Slot)BWidget.mouseEvent, (Slot)handleMouseEvent);
        this.init();
    }

    public BRoundedPopup(BWidget bWidget, BWidget bWidget2, BWidget bWidget3, float f, float f2, int n) {
        super(bWidget, bWidget3.getName(), true, bWidget2, f, f2);
        this.this();
        this.buttons = n;
        this.title = bWidget3;
        if (bWidget3 != null) {
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setCenter(new BBorderPane(bWidget2, 10.0, 5, 0.0, 5));
            bEdgePane.setTop(bWidget3);
            this.setContent(bEdgePane);
        }
        this.init();
    }

    static {
        Class clazz = class$com$tridium$ui$BRoundedPopup;
        if (clazz == null) {
            clazz = class$com$tridium$ui$BRoundedPopup = BRoundedPopup.class("[Lcom.tridium.ui.BRoundedPopup;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

