/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CDL {
    private static final String getValue(JSONTokener jSONTokener) throws JSONException {
        char c;
        while ((c = jSONTokener.next()) == ' ' || c == '\t') {
        }
        switch (c) {
            case '\u0000': {
                return null;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                StringBuffer stringBuffer = new StringBuffer();
                while ((c = jSONTokener.next()) != c2) {
                    if (c == '\u0000' || c == '\n' || c == '\r') {
                        throw jSONTokener.syntaxError("Missing close quote '" + c2 + "'.");
                    }
                    stringBuffer.append(c);
                }
                return stringBuffer.toString();
            }
            case ',': {
                jSONTokener.back();
                return "";
            }
        }
        jSONTokener.back();
        return jSONTokener.nextTo(',');
    }

    public static JSONArray rowToJSONArray(JSONTokener jSONTokener) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        block0: while (true) {
            String string = CDL.getValue(jSONTokener);
            char c = jSONTokener.next();
            if (string == null || jSONArray.length() == 0 && string.length() == 0 && c != ',') {
                return null;
            }
            jSONArray.put(string);
            while (true) {
                if (c == ',') continue block0;
                if (c != ' ') {
                    if (c == '\n' || c == '\r' || c == '\u0000') {
                        return jSONArray;
                    }
                    throw jSONTokener.syntaxError("Bad character '" + c + "' (" + c + ").");
                }
                c = jSONTokener.next();
            }
            break;
        }
    }

    public static JSONObject rowToJSONObject(JSONArray jSONArray, JSONTokener jSONTokener) throws JSONException {
        JSONArray jSONArray2 = CDL.rowToJSONArray(jSONTokener);
        return jSONArray2 != null ? jSONArray2.toJSONObject(jSONArray) : null;
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return CDL.toJSONArray(new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONTokener jSONTokener) throws JSONException {
        return CDL.toJSONArray(CDL.rowToJSONArray(jSONTokener), jSONTokener);
    }

    public static JSONArray toJSONArray(JSONArray jSONArray, String string) throws JSONException {
        return CDL.toJSONArray(jSONArray, new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONArray jSONArray, JSONTokener jSONTokener) throws JSONException {
        JSONObject jSONObject;
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        while ((jSONObject = CDL.rowToJSONObject(jSONArray, jSONTokener)) != null) {
            jSONArray2.put(jSONObject);
        }
        if (jSONArray2.length() == 0) {
            return null;
        }
        return jSONArray2;
    }

    public static String rowToString(JSONArray jSONArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < jSONArray.length()) {
            Object object;
            if (n > 0) {
                stringBuffer.append(',');
            }
            if ((object = jSONArray.opt(n)) != null) {
                String string = object.toString();
                if (string.length() > 0 && (string.indexOf(44) >= 0 || string.indexOf(10) >= 0 || string.indexOf(13) >= 0 || string.indexOf(0) >= 0 || string.charAt(0) == '\"')) {
                    stringBuffer.append('\"');
                    int n2 = string.length();
                    int n3 = 0;
                    while (n3 < n2) {
                        char c = string.charAt(n3);
                        if (c >= ' ' && c != '\"') {
                            stringBuffer.append(c);
                        }
                        ++n3;
                    }
                    stringBuffer.append('\"');
                } else {
                    stringBuffer.append(string);
                }
            }
            ++n;
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static String toString(JSONArray jSONArray) throws JSONException {
        JSONArray jSONArray2;
        JSONObject jSONObject = jSONArray.optJSONObject(0);
        if (jSONObject != null && (jSONArray2 = jSONObject.names()) != null) {
            return CDL.rowToString(jSONArray2) + CDL.toString(jSONArray2, jSONArray);
        }
        return null;
    }

    public static String toString(JSONArray jSONArray, JSONArray jSONArray2) throws JSONException {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < jSONArray2.length()) {
            JSONObject jSONObject = jSONArray2.optJSONObject(n);
            if (jSONObject != null) {
                stringBuffer.append(CDL.rowToString(jSONObject.toJSONArray(jSONArray)));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

