/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfPingRequest;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddfVideo.identify.BDdfVideoCameraInfo;
import com.tridium.milestone.BMilestoneCamera;
import com.tridium.milestone.comm.BMilestoneDvrHttpCommunicator;
import com.tridium.milestone.comm.req.ImageServerApiHttpReq;
import com.tridium.milestone.comm.req.MilestoneReqUtil;
import com.tridium.milestone.identify.BMilestoneCameraId;
import com.tridium.util.EscUtil;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BMilestoneCameraPingReq
extends BDdfPingRequest
implements ImageServerApiHttpReq {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$comm$req$BMilestoneCameraPingReq == null ? (class$com$tridium$milestone$comm$req$BMilestoneCameraPingReq = BMilestoneCameraPingReq.class$("com.tridium.milestone.comm.req.BMilestoneCameraPingReq")) : class$com$tridium$milestone$comm$req$BMilestoneCameraPingReq));
    protected BMilestoneDvrHttpCommunicator communicator;
    protected BMilestoneCamera camera;
    protected String milestoneDatabaseId;
    static /* synthetic */ Class class$com$tridium$milestone$comm$req$BMilestoneCameraPingReq;

    public Type getType() {
        return TYPE;
    }

    public String getMilestoneCameraId() {
        BMilestoneCameraId bMilestoneCameraId = (BMilestoneCameraId)this.getDeviceId();
        return bMilestoneCameraId.getCameraId();
    }

    public void setCamera(BMilestoneCamera bMilestoneCamera) {
        this.camera = bMilestoneCamera;
    }

    protected void configureCameraControls(XElem xElem) {
        String[] stringArray;
        Object object;
        BDdfVideoCameraInfo bDdfVideoCameraInfo = (BDdfVideoCameraInfo)this.camera.getPingParameters();
        bDdfVideoCameraInfo.setSupportsFocus(false);
        bDdfVideoCameraInfo.setSupportsIris(false);
        bDdfVideoCameraInfo.setSupportsStorePreset(false);
        XElem xElem2 = xElem.elem("ptz");
        XElem xElem3 = xElem.elem("userrights");
        XElem xElem4 = xElem.elem("presets");
        if (xElem4 != null && (object = xElem4.elems("preset")) != null && ((XElem[])object).length > 0) {
            stringArray = new String[((XElem[])object).length];
            for (int i = 0; i < ((XElem[])object).length; ++i) {
                stringArray[i] = EscUtil.slot.escape(MilestoneReqUtil.getText(object[i]));
            }
            this.camera.setPresetText(BEnumRange.make((String[])stringArray));
        }
        if (xElem2 != null && xElem3 != null) {
            object = MilestoneReqUtil.getText(xElem3, "ptz");
            stringArray = MilestoneReqUtil.getText(xElem2, "pan");
            String string = MilestoneReqUtil.getText(xElem2, "tilt");
            String string2 = MilestoneReqUtil.getText(xElem2, "zoom");
            if ("yes".equals(object)) {
                bDdfVideoCameraInfo.setSupportsPanTilt(!"none".equals(stringArray) && !"none".equals(string));
                bDdfVideoCameraInfo.setSupportsZoom(!"none".equals(string2));
            } else {
                bDdfVideoCameraInfo.setSupportsPanTilt(false);
                bDdfVideoCameraInfo.setSupportsZoom(false);
            }
        }
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        String string = this.getMilestoneCameraId();
        try {
            boolean bl = false;
            XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(iDdfDataFrame);
            XElem xElem2 = MilestoneReqUtil.getElem(xElem, "engines");
            XElem[] xElemArray = xElem2.elems("engine");
            block3: for (int i = 0; i < xElemArray.length; ++i) {
                XElem xElem3 = xElemArray[i];
                XElem xElem4 = xElem3.elem("cameras");
                if (xElem4 == null) continue;
                XElem[] xElemArray2 = xElem4.elems("camera");
                for (int j = 0; j < xElemArray2.length; ++j) {
                    String string2;
                    String string3 = string2 = xElemArray2[j].get("cameraid");
                    if (!string2.equalsIgnoreCase(string)) continue;
                    bl = true;
                    this.camera.setMilestoneDatabaseId(string3);
                    String string4 = MilestoneReqUtil.getText(xElemArray2[j], "guid");
                    if (string4 != null && string4.length() > 0) {
                        this.camera.setMilestoneGuid(string4);
                    }
                    if (!this.camera.getAutoSetPtzSupport()) break block3;
                    this.configureCameraControls(xElemArray2[j]);
                    break block3;
                }
            }
            if (bl) {
                return new BDdfResponse();
            }
            throw new DdfResponseException("Camera id does not exist in Milestone ImageServer: " + string);
        }
        catch (DdfResponseException ddfResponseException) {
            throw ddfResponseException;
        }
        catch (Exception exception) {
            throw new DdfResponseException((Throwable)exception);
        }
    }

    public byte[] toByteArray() {
        return new String("http://" + this.communicator.getUrlAddress() + ':' + this.communicator.getPort() + "/systeminfo.xml").getBytes();
    }

    public void setCommunicator(BMilestoneDvrHttpCommunicator bMilestoneDvrHttpCommunicator) {
        this.communicator = bMilestoneDvrHttpCommunicator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

