/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone.comm;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddfIp.tcp.comm.BDdfTcpHelper;
import com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator;
import com.tridium.milestone.BMilestoneDvr;
import com.tridium.milestone.comm.BMilestoneDvrCommunicator;
import com.tridium.milestone.comm.BMilestoneDvrTcpHelper;
import com.tridium.milestone.comm.BMilestoneDvrTcpUnsolicitedMgr;
import com.tridium.milestone.comm.BMilestoneImageServerUserNameAndPassword;
import com.tridium.milestone.comm.BMilestoneTcpXmlReceiver;
import com.tridium.milestone.comm.BMilestoneTcpXmlTransmitter;
import com.tridium.milestone.comm.req.BMilestoneCameraInitiateRecordingReq;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMilestoneDvrTcpCommunicator
extends BDdfTcpMutCommunicator {
    public static final Property transmitter = BMilestoneDvrTcpCommunicator.newProperty((int)0, (BValue)new BMilestoneTcpXmlTransmitter(), null);
    public static final Property receiver = BMilestoneDvrTcpCommunicator.newProperty((int)0, (BValue)new BMilestoneTcpXmlReceiver(), null);
    public static final Property unsolicitedMgr = BMilestoneDvrTcpCommunicator.newProperty((int)0, (BValue)new BMilestoneDvrTcpUnsolicitedMgr(), (BFacets)MGR_INCLUDE);
    public static final Property tcpIpComm = BMilestoneDvrTcpCommunicator.newProperty((int)4, (BValue)new BMilestoneDvrTcpHelper(), null);
    public static final Property milestoneCentralCredentials = BMilestoneDvrTcpCommunicator.newProperty((int)0, (BValue)new BMilestoneImageServerUserNameAndPassword(), (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)MGR_OPTIONAL_IN_TABLE));
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$comm$BMilestoneDvrTcpCommunicator == null ? (class$com$tridium$milestone$comm$BMilestoneDvrTcpCommunicator = BMilestoneDvrTcpCommunicator.class$("com.tridium.milestone.comm.BMilestoneDvrTcpCommunicator")) : class$com$tridium$milestone$comm$BMilestoneDvrTcpCommunicator));
    static /* synthetic */ Class class$com$tridium$milestone$comm$BMilestoneDvrTcpCommunicator;

    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    public void setTransmitter(BDdfTransmitter bDdfTransmitter) {
        this.set(transmitter, (BValue)bDdfTransmitter, null);
    }

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver bDdfReceiver) {
        this.set(receiver, (BValue)bDdfReceiver, null);
    }

    public BDdfUnsolicitedMgr getUnsolicitedMgr() {
        return (BDdfUnsolicitedMgr)this.get(unsolicitedMgr);
    }

    public void setUnsolicitedMgr(BDdfUnsolicitedMgr bDdfUnsolicitedMgr) {
        this.set(unsolicitedMgr, (BValue)bDdfUnsolicitedMgr, null);
    }

    public BDdfTcpHelper getTcpIpComm() {
        return (BDdfTcpHelper)this.get(tcpIpComm);
    }

    public void setTcpIpComm(BDdfTcpHelper bDdfTcpHelper) {
        this.set(tcpIpComm, (BValue)bDdfTcpHelper, null);
    }

    public BMilestoneImageServerUserNameAndPassword getMilestoneCentralCredentials() {
        return (BMilestoneImageServerUserNameAndPassword)this.get(milestoneCentralCredentials);
    }

    public void setMilestoneCentralCredentials(BMilestoneImageServerUserNameAndPassword bMilestoneImageServerUserNameAndPassword) {
        this.set(milestoneCentralCredentials, (BValue)bMilestoneImageServerUserNameAndPassword, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (property.equals(milestoneCentralCredentials)) {
            BMilestoneDvrTcpUnsolicitedMgr bMilestoneDvrTcpUnsolicitedMgr = (BMilestoneDvrTcpUnsolicitedMgr)this.getUnsolicitedMgr();
            bMilestoneDvrTcpUnsolicitedMgr.doAliveIntervalExpired();
        }
    }

    public void doCommunicate(BIDdfRequest bIDdfRequest) {
        if (bIDdfRequest instanceof BMilestoneCameraInitiateRecordingReq) {
            try {
                this.uploadInitiateRecordingEvent((BMilestoneCameraInitiateRecordingReq)bIDdfRequest);
            }
            catch (Exception exception) {
                this.getLog().error("Error while initiating rrecording.", (Throwable)exception);
            }
        } else {
            super.doCommunicate(bIDdfRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadInitiateRecordingEvent(BMilestoneCameraInitiateRecordingReq bMilestoneCameraInitiateRecordingReq) throws Exception {
        Object object;
        try {
            object = this.getMilestoneDvr();
            if (object != null) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace("Initiating recording for camera...");
                }
                EstablishUploadEventConnection establishUploadEventConnection = new EstablishUploadEventConnection(bMilestoneCameraInitiateRecordingReq);
                establishUploadEventConnection.start();
                BMilestoneDvrCommunicator bMilestoneDvrCommunicator = (BMilestoneDvrCommunicator)((BMilestoneDvr)((Object)object)).getCommunicator();
                establishUploadEventConnection.join(bMilestoneDvrCommunicator.getTcpCommunicator().getTcpIpComm().getSocketConnectionTimeout().getMillis());
                if (establishUploadEventConnection.isAlive()) {
                    establishUploadEventConnection.interrupt();
                }
                if (establishUploadEventConnection.uploadEventsSocket != null) {
                    establishUploadEventConnection.uploadEventsSocket.close();
                }
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace("Finished initiating recording for camera.");
                }
            } else if (this.getLog().isTraceOn()) {
                this.getLog().trace("Unable to determine DVR for camera to initiate recording");
            }
        }
        finally {
            object = bMilestoneCameraInitiateRecordingReq;
            synchronized (object) {
                ((Object)((Object)bMilestoneCameraInitiateRecordingReq)).notifyAll();
            }
        }
    }

    public BMilestoneDvr getMilestoneDvr() {
        return (BMilestoneDvr)this.getDvr();
    }

    public BIVideoDvr getDvr() {
        BComplex bComplex;
        for (bComplex = this.getParent(); bComplex != null && !(bComplex instanceof BIVideoDvr); bComplex = bComplex.getParent()) {
        }
        return (BIVideoDvr)bComplex;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class EstablishUploadEventConnection
    extends Thread {
        Socket uploadEventsSocket;
        protected byte[] initiateRecordingEventMessage;

        public EstablishUploadEventConnection(BMilestoneCameraInitiateRecordingReq bMilestoneCameraInitiateRecordingReq) {
            super("InitiateRecording.Camera" + bMilestoneCameraInitiateRecordingReq.getMilestoneCameraId());
            this.initiateRecordingEventMessage = bMilestoneCameraInitiateRecordingReq.toByteArray();
        }

        public void run() {
            BMilestoneDvrTcpHelper bMilestoneDvrTcpHelper = (BMilestoneDvrTcpHelper)BMilestoneDvrTcpCommunicator.this.getTcpIpComm();
            try {
                if (BMilestoneDvrTcpCommunicator.this.getLog().isTraceOn()) {
                    BMilestoneDvrTcpCommunicator.this.getLog().trace("Opening socket to Milestone server for uploading a recording event");
                }
                this.uploadEventsSocket = bMilestoneDvrTcpHelper.createUploadEventSocket();
                OutputStream outputStream = this.uploadEventsSocket.getOutputStream();
                if (BMilestoneDvrTcpCommunicator.this.getLog().isTraceOn()) {
                    BMilestoneDvrTcpCommunicator.this.getLog().trace("Uploading recording event to Milestone server: " + new String(this.initiateRecordingEventMessage));
                }
                outputStream.write(this.initiateRecordingEventMessage);
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                BMilestoneDvrTcpCommunicator.this.getLog().error("Unable to initiate recording", (Throwable)iOException);
            }
            finally {
                if (this.uploadEventsSocket != null) {
                    if (BMilestoneDvrTcpCommunicator.this.getLog().isTraceOn()) {
                        BMilestoneDvrTcpCommunicator.this.getLog().trace("Closing socket to Milestone server for uploading the recording event");
                    }
                    try {
                        this.uploadEventsSocket.close();
                    }
                    catch (IOException iOException) {
                        BMilestoneDvrTcpCommunicator.this.getLog().error("IOException while closing socket to Milestone server for uploading the recording event", (Throwable)iOException);
                    }
                }
            }
        }
    }
}

