/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone.comm;

import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddfHttp.comm.BDdfHttpCommunicator;
import com.tridium.milestone.BMilestoneDvr;
import com.tridium.milestone.comm.BMilestoneDvrCommunicator;
import com.tridium.milestone.comm.BMilestoneDvrHttpReceiver;
import com.tridium.milestone.comm.BMilestoneDvrHttpTransmitter;
import com.tridium.milestone.comm.req.BMilestoneSessionPingReq;
import com.tridium.milestone.comm.req.BMilestoneSessionStartReq;
import com.tridium.milestone.comm.req.BMilestoneSessionStopReq;
import com.tridium.milestone.comm.req.ImageServerApiHttpReq;
import java.util.StringTokenizer;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMilestoneDvrHttpCommunicator
extends BDdfHttpCommunicator {
    public static final Property transmitter = BMilestoneDvrHttpCommunicator.newProperty((int)0, (BValue)new BMilestoneDvrHttpTransmitter(), null);
    public static final Property receiver = BMilestoneDvrHttpCommunicator.newProperty((int)0, (BValue)new BMilestoneDvrHttpReceiver(), null);
    public static final Property recentSessionIds = BMilestoneDvrHttpCommunicator.newProperty((int)4, (String)"", null);
    public static final Property maxRecentSessionsToClose = BMilestoneDvrHttpCommunicator.newProperty((int)4, (int)100, null);
    public static final Action startSession = BMilestoneDvrHttpCommunicator.newAction((int)0, null);
    public static final Action stopSession = BMilestoneDvrHttpCommunicator.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$comm$BMilestoneDvrHttpCommunicator == null ? (class$com$tridium$milestone$comm$BMilestoneDvrHttpCommunicator = BMilestoneDvrHttpCommunicator.class$("com.tridium.milestone.comm.BMilestoneDvrHttpCommunicator")) : class$com$tridium$milestone$comm$BMilestoneDvrHttpCommunicator));
    protected Object sessionTracking = new Object();
    protected static int nextSessionPingTimerId = 1;
    protected String milestoneSessionId = null;
    protected boolean milestoneSessionFailure = false;
    protected Object access = new Object();
    protected SessionPingTimer sessionPingTimer = null;
    public static final long FORTY_FIVE_SECONDS = 45000L;
    protected BMilestoneDvrCommunicator dvrCommunicator;
    protected BMilestoneDvr dvr;
    protected Object commSynchronizer = new Object();
    static /* synthetic */ Class class$com$tridium$milestone$comm$BMilestoneDvrHttpCommunicator;

    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    public void setTransmitter(BDdfTransmitter bDdfTransmitter) {
        this.set(transmitter, (BValue)bDdfTransmitter, null);
    }

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver bDdfReceiver) {
        this.set(receiver, (BValue)bDdfReceiver, null);
    }

    public String getRecentSessionIds() {
        return this.getString(recentSessionIds);
    }

    public void setRecentSessionIds(String string) {
        this.setString(recentSessionIds, string, null);
    }

    public int getMaxRecentSessionsToClose() {
        return this.getInt(maxRecentSessionsToClose);
    }

    public void setMaxRecentSessionsToClose(int n) {
        this.setInt(maxRecentSessionsToClose, n, null);
    }

    public void startSession() {
        this.invoke(startSession, null, null);
    }

    public void stopSession() {
        this.invoke(stopSession, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getUrlAddress() {
        return this.getDvrCommunicator().getImageServerIpAddressPort().getIpAddress();
    }

    public int getPort() {
        return this.getDvrCommunicator().getImageServerIpAddressPort().getIpPort();
    }

    public BMilestoneDvr getMilestoneDvr() {
        if (this.dvr == null) {
            this.dvr = (BMilestoneDvr)this.getDvrCommunicator().getParent();
        }
        return this.dvr;
    }

    public BMilestoneDvrCommunicator getDvrCommunicator() {
        if (this.dvrCommunicator == null) {
            this.dvrCommunicator = (BMilestoneDvrCommunicator)this.getParent();
        }
        return this.dvrCommunicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void communicate(BIDdfRequest bIDdfRequest) {
        Object object = this.commSynchronizer;
        synchronized (object) {
            if (bIDdfRequest instanceof ImageServerApiHttpReq) {
                ((ImageServerApiHttpReq)bIDdfRequest).setCommunicator(this);
            }
            super.communicate(bIDdfRequest);
        }
    }

    public synchronized void startCommunicating() {
        super.startCommunicating();
        new Thread(this.getName() + ".startCommunicating"){

            public void run() {
                BMilestoneDvrHttpCommunicator.this.doStartSession();
            }
        }.start();
    }

    public void stopCommunicating() {
        if (this.milestoneSessionId != null) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Sending stop...");
            }
            this.doStopSession(this.milestoneSessionId);
        }
        if (this.sessionPingTimer != null) {
            this.sessionPingTimer.stopPingTimer();
        }
        super.stopCommunicating();
    }

    public void doStartSession() {
        String string = "StartSession:MilestoneDvrHttpCommunicator";
        Object object = this.getHandle();
        if (object != null) {
            string = string + ":" + object;
        }
        new Thread(string){

            public void run() {
                BMilestoneDvrHttpCommunicator.this.closeRecentMilestoneSessions();
                BMilestoneDvrHttpCommunicator.this.doStartSessionSync();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rememberMilestoneSession(String string) {
        Object object = this.sessionTracking;
        synchronized (object) {
            int n = this.getMaxRecentSessionsToClose();
            String string2 = this.getRecentSessionIds();
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens() && ++n2 < n) {
                string3 = stringTokenizer.nextToken() + ';' + string3;
            }
            string3 = string + ';' + string3;
            this.setRecentSessionIds(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeRecentMilestoneSessions() {
        Object object = this.sessionTracking;
        synchronized (object) {
            int n = this.getMaxRecentSessionsToClose();
            String string = this.getRecentSessionIds();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens() && n2++ < n) {
                String string2 = stringTokenizer.nextToken();
                this.doStopSessionSync(string2);
            }
            this.setRecentSessionIds("");
        }
    }

    public boolean doStartSessionSync() {
        if (this.isRunning()) {
            BMilestoneSessionStartReq bMilestoneSessionStartReq = new BMilestoneSessionStartReq();
            DdfRequestUtil.communicateSync((BIDdfCommunicator)this, (BIDdfRequest)bMilestoneSessionStartReq);
            if (bMilestoneSessionStartReq.isSuccessful()) {
                if (this.milestoneSessionFailure) {
                    this.getMilestoneDvr().configOk();
                    this.milestoneSessionFailure = false;
                }
                this.milestoneSessionId = bMilestoneSessionStartReq.getMilestoneSessionId();
                this.rememberMilestoneSession(this.milestoneSessionId);
                this.sessionPingTimer = new SessionPingTimer();
                this.sessionPingTimer.start();
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace("Session started correctly: " + this.milestoneSessionId);
                }
                return true;
            }
            this.milestoneSessionFailure = true;
            this.getLog().error("Milestone Session Failure: " + bMilestoneSessionStartReq.getResultText());
            this.milestoneSessionId = null;
            try {
                Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)45000L), (Action)startSession, null);
            }
            catch (NotRunningException notRunningException) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    public BBoolean doPingSession() {
        BMilestoneSessionPingReq bMilestoneSessionPingReq = new BMilestoneSessionPingReq(this.milestoneSessionId);
        DdfRequestUtil.communicateSync((BIDdfCommunicator)this, (BIDdfRequest)bMilestoneSessionPingReq);
        if (bMilestoneSessionPingReq.isSuccessful()) {
            this.milestoneSessionId = bMilestoneSessionPingReq.getMilestoneSessionId();
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Session ping sucess.");
            }
            return BBoolean.TRUE;
        }
        this.getLog().message("Session ping unsuccessful: " + this.milestoneSessionId);
        return BBoolean.FALSE;
    }

    public void doStopSession() {
        this.doStopSession(this.milestoneSessionId);
    }

    public void doStopSession(final String string) {
        String string2 = "StopSession:MilestoneDvrHttpCommunicator";
        Object object = this.getHandle();
        if (object != null) {
            string2 = string2 + ":" + object;
        }
        new Thread(string2){

            public void run() {
                BMilestoneDvrHttpCommunicator.this.doStopSessionSync(string);
            }
        }.start();
    }

    public boolean doStopSessionSync(String string) {
        BMilestoneSessionStopReq bMilestoneSessionStopReq = new BMilestoneSessionStopReq(string);
        DdfRequestUtil.communicateSync((BIDdfCommunicator)this, (BIDdfRequest)bMilestoneSessionStopReq);
        if (bMilestoneSessionStopReq.isSuccessful()) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Session stop success.");
            }
            return true;
        }
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("Unable to stop session: " + this.milestoneSessionId);
        }
        return false;
    }

    public String getMilestoneSessionId() {
        return this.milestoneSessionId;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class SessionPingTimer
    extends Thread {
        public boolean running = true;

        public SessionPingTimer() {
            super("milestone.sessionPing." + nextSessionPingTimerId++);
        }

        public void run() {
            try {
                while (this.running) {
                    Thread.sleep(45000L);
                    BMilestoneDvrHttpCommunicator.this.doPingSession();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void stopPingTimer() {
            this.running = false;
            this.interrupt();
        }
    }
}

