/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusSlave.comm;

import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.messages.ModbusInputStream;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.server.messages.ModbusServerReadFileRequest;
import com.tridium.modbusCore.server.messages.ModbusServerReadFileResponse;
import com.tridium.modbusCore.server.messages.ModbusServerReadRequest;
import com.tridium.modbusCore.server.messages.ModbusServerWriteFileRequest;
import com.tridium.modbusCore.server.messages.ModbusServerWriteFileResponse;
import com.tridium.modbusCore.server.messages.ModbusServerWriteRequest;
import com.tridium.modbusCore.server.util.TLinkedListElement;
import com.tridium.modbusCore.server.util.TLinkedListManager;
import com.tridium.modbusSlave.BModbusSlaveDevice;
import com.tridium.modbusSlave.BModbusSlaveNetwork;
import com.tridium.modbusSlave.comm.UnsolicitedMessageElement;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusUnsolicitedReceive
implements Runnable,
ModbusMessageConst {
    private TLinkedListManager unsolicitedMessageManager;
    private BModbusSlaveNetwork host;
    private boolean timeToDie;
    private Thread myThread;
    private long delayedStartTicks;

    public final void init() {
    }

    public final void cleanup() {
    }

    public final void start() {
        this.timeToDie = false;
        this.myThread = new Thread((Runnable)this, "ModSlave:UnsolRcv");
        this.myThread.start();
    }

    public final void stop() {
        this.timeToDie = true;
        this.myThread.stop();
    }

    public boolean isDying() {
        return this.timeToDie;
    }

    public void atSteadyState() {
        this.delayedStartTicks = Clock.ticks() + 1000L;
    }

    public void run() {
        this.delayedStartTicks = Sys.atSteadyState() ? Clock.ticks() + 10000L : Clock.ticks() + 120000L;
        this.unsolicitedMessageManager = new TLinkedListManager("ModbusUnsolicitedReceive Manager");
        while (!this.timeToDie) {
            UnsolicitedMessageElement unsolicitedMessageElement;
            try {
                unsolicitedMessageElement = (UnsolicitedMessageElement)this.unsolicitedMessageManager.removeFromHead((long)-1);
                if (this.delayedStartTicks > 0L) {
                    long l = this.delayedStartTicks - Clock.ticks();
                    if (l > 0L) {
                        this.host.getModbusLog().message("delayedStartsTicks: " + l);
                        unsolicitedMessageElement = null;
                    } else if (unsolicitedMessageElement != null) {
                        this.delayedStartTicks = 0L;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.host.getModbusLog().error("ModbusUnsolicitedReceive.run Problem with " + this.unsolicitedMessageManager.getName() + ": ", (Throwable)interruptedException);
                unsolicitedMessageElement = null;
            }
            try {
                if (unsolicitedMessageElement == null) continue;
                byte[] byArray = unsolicitedMessageElement.getMessage();
                if (this.host.getModbusMode() == 0) {
                    byArray = ModbusInputStream.convertAscii2Rtu((byte[])byArray);
                }
                if (byArray.length == 0) continue;
                int n = byArray[0] & 0xFF;
                BModbusSlaveDevice bModbusSlaveDevice = this.findModbusDevice(n);
                if (bModbusSlaveDevice != null) {
                    bModbusSlaveDevice.incrementRequest();
                    if (!bModbusSlaveDevice.getStatus().isDisabled()) {
                        switch (byArray[1]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                ModbusServerReadRequest modbusServerReadRequest = new ModbusServerReadRequest(this.host.getModbusMode(), (BModbusDevice)bModbusSlaveDevice, byArray);
                                this.processReadRequest(bModbusSlaveDevice, modbusServerReadRequest);
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 15: 
                            case 16: {
                                ModbusServerWriteRequest modbusServerWriteRequest = new ModbusServerWriteRequest(this.host.getModbusMode(), (BModbusDevice)bModbusSlaveDevice, byArray);
                                this.processWriteRequest(bModbusSlaveDevice, modbusServerWriteRequest);
                                break;
                            }
                            case 20: {
                                ModbusServerReadFileRequest modbusServerReadFileRequest = new ModbusServerReadFileRequest(byArray);
                                this.processReadFileRequest(bModbusSlaveDevice, modbusServerReadFileRequest);
                                break;
                            }
                            case 21: {
                                ModbusServerWriteFileRequest modbusServerWriteFileRequest = new ModbusServerWriteFileRequest(byArray);
                                this.processWriteFileRequest(bModbusSlaveDevice, modbusServerWriteFileRequest);
                                break;
                            }
                            default: {
                                ModbusResponse modbusResponse = new ModbusResponse(this.host.getModbusMode(), (BModbusDevice)bModbusSlaveDevice);
                                modbusResponse.setResponseExpected(false);
                                modbusResponse.deviceAddress = (byte)n;
                                modbusResponse.functionCode = (byte)(byArray[1] | 0x80);
                                modbusResponse.byteCount = 1;
                                modbusResponse.data = new byte[0];
                                this.host.sendSync((Message)modbusResponse);
                                break;
                            }
                        }
                        continue;
                    }
                    if (!this.host.getModbusLog().isTraceOn()) continue;
                    this.host.getModbusLog().trace("ModbusUnsolicitedReceive found device is disabled: " + n);
                    continue;
                }
                if (!this.host.getModbusLog().isTraceOn()) continue;
                this.host.getModbusLog().trace("ModbusUnsolicitedReceive did not find device: " + n);
            }
            catch (Exception exception) {
                this.host.getModbusLog().error(" ModbusSlaveUnsolicitedReceive thread caught Exception: ", (Throwable)exception);
            }
        }
    }

    private final void processReadRequest(BModbusSlaveDevice bModbusSlaveDevice, ModbusServerReadRequest modbusServerReadRequest) {
        ModbusResponse modbusResponse = new ModbusResponse(this.host.getModbusMode(), (BModbusDevice)bModbusSlaveDevice);
        modbusResponse.setResponseExpected(false);
        modbusResponse.deviceAddress = (byte)modbusServerReadRequest.deviceAddress;
        modbusResponse.functionCode = (byte)modbusServerReadRequest.functionCode;
        int n = modbusServerReadRequest.startAddress;
        int n2 = modbusServerReadRequest.functionCode;
        int n3 = modbusServerReadRequest.numberPoints;
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    modbusResponse.data = bModbusSlaveDevice.getCoilStatusValues(n, n3);
                    break;
                }
                case 2: {
                    modbusResponse.data = bModbusSlaveDevice.getInputStatusValues(n, n3);
                    break;
                }
                case 3: {
                    modbusResponse.data = bModbusSlaveDevice.getHoldingRegisterValues(n, n3);
                    break;
                }
                case 4: {
                    modbusResponse.data = bModbusSlaveDevice.getInputRegisterValues(n, n3);
                    break;
                }
                default: {
                    bl = true;
                    break;
                }
            }
        }
        catch (ModbusException modbusException) {
            bl = true;
        }
        if (bl) {
            modbusResponse.functionCode = (byte)(modbusResponse.functionCode | 0x80);
            modbusResponse.byteCount = 2;
            modbusResponse.data = new byte[0];
            this.host.sendSync((Message)modbusResponse);
        } else {
            modbusResponse.byteCount = (byte)modbusResponse.data.length;
            this.host.sendSync((Message)modbusResponse);
        }
    }

    private final void processWriteRequest(BModbusSlaveDevice bModbusSlaveDevice, ModbusServerWriteRequest modbusServerWriteRequest) {
        ModbusResponse modbusResponse = new ModbusResponse(this.host.getModbusMode(), (BModbusDevice)bModbusSlaveDevice, (ModbusWriteRequest)modbusServerWriteRequest);
        modbusResponse.setResponseExpected(false);
        int n = modbusServerWriteRequest.startAddress;
        int n2 = modbusServerWriteRequest.functionCode;
        boolean bl = false;
        switch (n2) {
            case 5: {
                if (bModbusSlaveDevice.isCoilAddressValid(n, modbusServerWriteRequest.numberPoints)) {
                    boolean bl2 = false;
                    if ((modbusServerWriteRequest.data[0] & 0xFF) == 255) {
                        bl2 = true;
                    }
                    bModbusSlaveDevice.setCoilStatusValue(n, bl2);
                    break;
                }
                bl = true;
                break;
            }
            case 15: {
                if (bModbusSlaveDevice.isCoilAddressValid(n, modbusServerWriteRequest.numberPoints)) {
                    bModbusSlaveDevice.setCoilStatusValue(n, modbusServerWriteRequest.numberPoints, modbusServerWriteRequest.data);
                    break;
                }
                bl = true;
                break;
            }
            case 6: 
            case 16: {
                if (bModbusSlaveDevice.isHoldingRegisterAddressValid(n, modbusServerWriteRequest.numberPoints)) {
                    bModbusSlaveDevice.setHoldingRegisterValues(n, modbusServerWriteRequest.data);
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            modbusResponse.functionCode = (byte)(modbusResponse.functionCode | 0x80);
            modbusResponse.byteCount = 2;
            this.host.sendSync((Message)modbusResponse);
        } else {
            this.host.sendSync((Message)modbusResponse);
        }
    }

    private final void processReadFileRequest(BModbusSlaveDevice bModbusSlaveDevice, ModbusServerReadFileRequest modbusServerReadFileRequest) {
        ModbusServerReadFileResponse modbusServerReadFileResponse = new ModbusServerReadFileResponse(this.host.getModbusMode(), (BModbusDevice)bModbusSlaveDevice, modbusServerReadFileRequest);
        int n = modbusServerReadFileRequest.getNumSubRequests();
        boolean bl = false;
        try {
            int n2 = 0;
            while (n2 < n) {
                modbusServerReadFileResponse.addSubRequestData(modbusServerReadFileRequest.getFileNumber(n2), modbusServerReadFileRequest.getStartingRecordNumber(n2), modbusServerReadFileRequest.getRecordLength(n2), bModbusSlaveDevice.getFileRecordData(modbusServerReadFileRequest.getFileNumber(n2), modbusServerReadFileRequest.getStartingRecordNumber(n2), modbusServerReadFileRequest.getRecordLength(n2)));
                ++n2;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            modbusServerReadFileResponse.functionCode = (byte)(modbusServerReadFileResponse.functionCode | 0x80);
            modbusServerReadFileResponse.byteCount = 2;
            modbusServerReadFileResponse.data = new byte[0];
            this.host.sendSync((Message)modbusServerReadFileResponse);
        } else {
            modbusServerReadFileResponse.byteCount = (byte)modbusServerReadFileResponse.data.length;
            this.host.sendSync((Message)modbusServerReadFileResponse);
        }
    }

    private final void processWriteFileRequest(BModbusSlaveDevice bModbusSlaveDevice, ModbusServerWriteFileRequest modbusServerWriteFileRequest) {
        ModbusServerWriteFileResponse modbusServerWriteFileResponse = new ModbusServerWriteFileResponse(this.host.getModbusMode(), (BModbusDevice)bModbusSlaveDevice, modbusServerWriteFileRequest);
        int n = modbusServerWriteFileRequest.getNumSubRequests();
        boolean bl = false;
        try {
            int n2 = 0;
            while (n2 < n) {
                modbusServerWriteFileResponse.addSubRequestData(modbusServerWriteFileRequest.getFileNumber(n2), modbusServerWriteFileRequest.getStartingRecordNumber(n2), modbusServerWriteFileRequest.getRecordLength(n2), bModbusSlaveDevice.setFileRecordData(modbusServerWriteFileRequest.getFileNumber(n2), modbusServerWriteFileRequest.getStartingRecordNumber(n2), modbusServerWriteFileRequest.getRecordLength(n2), modbusServerWriteFileRequest.getRecordData(n2)));
                ++n2;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            modbusServerWriteFileResponse.functionCode = (byte)(modbusServerWriteFileResponse.functionCode | 0x80);
            modbusServerWriteFileResponse.byteCount = 2;
            modbusServerWriteFileResponse.data = new byte[0];
            this.host.sendSync((Message)modbusServerWriteFileResponse);
        } else {
            modbusServerWriteFileResponse.byteCount = (byte)modbusServerWriteFileResponse.data.length;
            this.host.sendSync((Message)modbusServerWriteFileResponse);
        }
    }

    public void receiveMessage(UnsolicitedMessageElement unsolicitedMessageElement) {
        if (this.unsolicitedMessageManager != null) {
            this.unsolicitedMessageManager.addToTail((TLinkedListElement)unsolicitedMessageElement);
        }
    }

    public BModbusSlaveDevice findModbusDevice(int n) {
        return this.host.findModbusDevice(n);
    }

    private final /* synthetic */ void this() {
        this.unsolicitedMessageManager = null;
        this.timeToDie = true;
        this.delayedStartTicks = 0L;
    }

    public ModbusUnsolicitedReceive(BModbusSlaveNetwork bModbusSlaveNetwork) {
        this.this();
        this.host = bModbusSlaveNetwork;
    }
}

