/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusSlave.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.modbusSlave.BModbusSlaveNetwork;
import com.tridium.modbusSlave.comm.ModbusSlaveRxDriver;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusSlaveSerialComm
extends Comm {
    private static final long MIN_SLEEP_TIME = 1L;
    protected BISerialPort serialPort;
    protected InputStream in;
    protected OutputStream out;
    protected Thread rxThread;
    private long lastRecvMessageTicks;

    protected boolean started() throws Exception {
        try {
            BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = ((BModbusSlaveNetwork)this.getNetwork()).getSerialPortConfig().open(this.getNetwork().getName());
            this.serialPort.enableReceiveTimeout(bISerialService.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
        }
        catch (Exception exception) {
            String string = "Error opening and configuring the serial port";
            this.getNetwork().getLog().error(string, (Throwable)exception);
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception2) {
                    this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)exception2);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception exception3) {
                    this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)exception3);
                }
            }
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            throw exception;
        }
        this.getCommReceiver().setInputStream(this.in);
        this.getCommTransmitter().setOutputStream(this.out);
        this.rxThread = new Thread((Runnable)this.getCommReceiver(), "SerialRcv:" + this.getNetwork().getName());
        this.getCommReceiver().setAlive(true);
        this.rxThread.start();
        this.rxThread.setPriority(7);
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)exception);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)exception);
            }
        }
        if (this.serialPort != null) {
            this.serialPort.disableReceiveTimeout();
            this.serialPort.close();
        }
        this.in = null;
        this.out = null;
    }

    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        if (message == null) {
            return null;
        }
        if (!message.getResponseExpected()) {
            this.transmitNoResponse(message);
            return null;
        }
        this.performInterMessageDelay();
        return super.transmit(message, bRelTime, n);
    }

    public void transmitNoResponse(Message message) throws BasicException {
        if (message == null) {
            return;
        }
        if (!this.isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        this.performInterMessageDelay();
        super.transmitNoResponse(message);
    }

    public void receive(ReceivedMessage receivedMessage) {
        if (receivedMessage == null) {
            return;
        }
        this.setReceivedMessageTicks(Clock.ticks());
        super.receive(receivedMessage);
    }

    protected void performInterMessageDelay() {
        long l = ((BModbusSlaveNetwork)this.getNetwork()).getInterMessageDelay().getMillis();
        if (l <= 0L) {
            return;
        }
        long l2 = Clock.ticks() - this.lastRecvMessageTicks;
        if (l2 >= l) {
            return;
        }
        long l3 = Math.max(l - l2, 1L);
        try {
            Thread.sleep(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setReceivedMessageTicks(long l) {
        this.lastRecvMessageTicks = l;
    }

    public BISerialPort getSerialPort() {
        return this.serialPort;
    }

    private final /* synthetic */ void this() {
        this.lastRecvMessageTicks = 0L;
    }

    public ModbusSlaveSerialComm(BModbusSlaveNetwork bModbusSlaveNetwork) {
        super((BBasicNetwork)bModbusSlaveNetwork, (CommReceiver)new ModbusSlaveRxDriver(bModbusSlaveNetwork));
        this.this();
    }
}

