/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.trigger;

import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.control.trigger.TriggerScheduler;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTimeTrigger
extends BComponent {
    public static final Property triggerMode = BTimeTrigger.newProperty((int)0, (BValue)BDailyTriggerMode.DEFAULT, null);
    public static final Property lastTrigger = BTimeTrigger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property nextTrigger = BTimeTrigger.newProperty((int)65537, (BValue)BAbsTime.END_OF_TIME, null);
    public static final Action fireTrigger = BTimeTrigger.newAction((int)0, null);
    public static final Action checkTime = BTimeTrigger.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private TriggerScheduler scheduler;
    static /* synthetic */ Class class$javax$baja$control$trigger$BTimeTrigger;

    public BTriggerMode getTriggerMode() {
        return (BTriggerMode)this.get(triggerMode);
    }

    public void setTriggerMode(BTriggerMode bTriggerMode) {
        this.set(triggerMode, (BValue)bTriggerMode, null);
    }

    public BAbsTime getLastTrigger() {
        return (BAbsTime)this.get(lastTrigger);
    }

    public void setLastTrigger(BAbsTime bAbsTime) {
        this.set(lastTrigger, (BValue)bAbsTime, null);
    }

    public BAbsTime getNextTrigger() {
        return (BAbsTime)this.get(nextTrigger);
    }

    public void setNextTrigger(BAbsTime bAbsTime) {
        this.set(nextTrigger, (BValue)bAbsTime, null);
    }

    public void fireTrigger() {
        this.invoke(fireTrigger, null, null);
    }

    public void checkTime() {
        this.invoke(checkTime, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() {
        if (this.isRunning()) {
            this.init();
        }
    }

    public void started() {
        if (Sys.atSteadyState()) {
            this.init();
        }
    }

    public void stopped() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.scheduler = null;
    }

    private final void init() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.scheduler = this.getTriggerMode().makeScheduler(this);
        this.checkTime();
        this.scheduler.start();
        BAbsTime bAbsTime = this.scheduler.getScheduledTriggerTime();
        if (bAbsTime == null) {
            this.setNextTrigger(this.scheduler.getNextTriggerTime(Clock.time(), this.getLastTrigger()));
        } else {
            this.setNextTrigger(bAbsTime);
        }
    }

    public void doFireTrigger() {
        BAbsTime bAbsTime = Clock.time();
        this.setLastTrigger(bAbsTime);
    }

    public void doCheckTime() {
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2 = Clock.time();
        if (this.scheduler.isTriggerTime(bAbsTime2)) {
            this.fireTrigger();
        }
        if ((bAbsTime = this.scheduler.getScheduledTriggerTime()) == null) {
            this.setNextTrigger(this.scheduler.getNextTriggerTime(bAbsTime2, this.getLastTrigger()));
        } else {
            this.setNextTrigger(bAbsTime);
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == triggerMode) {
            this.init();
        }
    }

    public void clockChanged(BRelTime bRelTime) {
        this.init();
    }

    public String toString(Context context) {
        return this.getTriggerMode().toString(context);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BTimeTrigger() {
    }

    public BTimeTrigger(BTriggerMode bTriggerMode) {
        this.setTriggerMode(bTriggerMode);
    }

    static {
        Class clazz = class$javax$baja$control$trigger$BTimeTrigger;
        if (clazz == null) {
            clazz = class$javax$baja$control$trigger$BTimeTrigger = BTimeTrigger.class("[Ljavax.baja.control.trigger.BTimeTrigger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/trigger.png");
    }
}

