/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.trigger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.control.trigger.TriggerScheduler;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BIntervalTriggerMode
extends BTriggerMode {
    public static final BIntervalTriggerMode DEFAULT = new BIntervalTriggerMode();
    public static final Type TYPE;
    private static Random rand;
    private static LexiconText dispName;
    private boolean rangeEnabled;
    private BTime startTime;
    private BTime endTime;
    private BRelTime interval;
    private BDaysOfWeekBits daysOfWeek;
    private BAbsTime scheduledTime;
    static /* synthetic */ Class class$javax$baja$control$trigger$BIntervalTriggerMode;

    public static final BIntervalTriggerMode make() {
        return DEFAULT;
    }

    public static final BIntervalTriggerMode make(BRelTime bRelTime) {
        BIntervalTriggerMode bIntervalTriggerMode = new BIntervalTriggerMode();
        bIntervalTriggerMode.interval = bRelTime;
        return bIntervalTriggerMode;
    }

    public static final BIntervalTriggerMode make(BRelTime bRelTime, BDaysOfWeekBits bDaysOfWeekBits) {
        BIntervalTriggerMode bIntervalTriggerMode = new BIntervalTriggerMode();
        bIntervalTriggerMode.interval = bRelTime;
        bIntervalTriggerMode.daysOfWeek = bDaysOfWeekBits;
        return bIntervalTriggerMode;
    }

    public static final BIntervalTriggerMode make(BTime bTime, BTime bTime2, BRelTime bRelTime, BDaysOfWeekBits bDaysOfWeekBits) {
        return BIntervalTriggerMode.make(true, bTime, bTime2, bRelTime, bDaysOfWeekBits);
    }

    public static final BIntervalTriggerMode make(boolean bl, BTime bTime, BTime bTime2, BRelTime bRelTime, BDaysOfWeekBits bDaysOfWeekBits) {
        BIntervalTriggerMode bIntervalTriggerMode = new BIntervalTriggerMode();
        bIntervalTriggerMode.rangeEnabled = bl;
        bIntervalTriggerMode.startTime = bTime;
        bIntervalTriggerMode.endTime = bTime2;
        bIntervalTriggerMode.interval = bRelTime;
        bIntervalTriggerMode.daysOfWeek = bDaysOfWeekBits;
        return bIntervalTriggerMode;
    }

    public final String getDisplayName(Context context) {
        return dispName.getText(context);
    }

    public final boolean isRangeEnabled() {
        return this.rangeEnabled;
    }

    public final BTime getStartTime() {
        return this.startTime;
    }

    public final BTime getEndTime() {
        return this.endTime;
    }

    public final BRelTime getInterval() {
        return this.interval;
    }

    public final BDaysOfWeekBits getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public final TriggerScheduler makeScheduler(BTimeTrigger bTimeTrigger) {
        return new IntervalTriggerScheduler(bTimeTrigger);
    }

    public final int hashCode() {
        return this.startTime.hashCode() ^ this.endTime.hashCode() ^ this.interval.hashCode() ^ this.daysOfWeek.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof BIntervalTriggerMode) {
            BIntervalTriggerMode bIntervalTriggerMode = (BIntervalTriggerMode)((Object)object);
            boolean bl = false;
            if (this.rangeEnabled == bIntervalTriggerMode.rangeEnabled && this.startTime.equals((Object)bIntervalTriggerMode.startTime) && this.endTime.equals((Object)bIntervalTriggerMode.endTime) && this.interval.equals((Object)bIntervalTriggerMode.interval) && this.daysOfWeek.equals((Object)bIntervalTriggerMode.daysOfWeek)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.rangeEnabled);
        this.startTime.encode(dataOutput);
        this.endTime.encode(dataOutput);
        this.interval.encode(dataOutput);
        this.daysOfWeek.encode(dataOutput);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BIntervalTriggerMode.make(dataInput.readBoolean(), (BTime)BTime.DEFAULT.decode(dataInput), (BTime)BTime.DEFAULT.decode(dataInput), (BRelTime)BRelTime.DEFAULT.decode(dataInput), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT.decode(dataInput));
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBoolean.encode((boolean)this.rangeEnabled));
        stringBuffer.append(';').append(this.startTime.encodeToString());
        stringBuffer.append(';').append(this.endTime.encodeToString());
        stringBuffer.append(';').append(this.interval.encodeToString());
        stringBuffer.append(';').append(this.daysOfWeek.encodeToString());
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        return BIntervalTriggerMode.make(BBoolean.decode((String)stringTokenizer.nextToken()), (BTime)BTime.DEFAULT.decodeFromString(stringTokenizer.nextToken()), (BTime)BTime.DEFAULT.decodeFromString(stringTokenizer.nextToken()), (BRelTime)BRelTime.DEFAULT.decodeFromString(stringTokenizer.nextToken()), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT.decodeFromString(stringTokenizer.nextToken()));
    }

    public final String toString(Context context) {
        return this.interval.toString(context) + ' ' + this.daysOfWeek.toString(context);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.rangeEnabled = false;
        this.startTime = BTime.make((int)0, (int)0, (int)0);
        this.endTime = BTime.make((int)23, (int)59, (int)59, (int)999);
        this.interval = BRelTime.makeMinutes((int)1);
        this.daysOfWeek = BDaysOfWeekBits.DEFAULT;
    }

    private BIntervalTriggerMode() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$control$trigger$BIntervalTriggerMode;
        if (clazz == null) {
            clazz = class$javax$baja$control$trigger$BIntervalTriggerMode = BIntervalTriggerMode.class("[Ljavax.baja.control.trigger.BIntervalTriggerMode;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        rand = new Random();
        dispName = LexiconText.make((String)"control", (String)"trigger.interval");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IntervalTriggerScheduler
    extends TriggerScheduler {
        private Clock.Ticket ticket;

        public void start() {
            BIntervalTriggerMode.this.scheduledTime = this.getNextTriggerTime(Clock.time(), this.getTrigger().getLastTrigger());
            if (BIntervalTriggerMode.this.interval.getMillis() > 0L) {
                this.ticket = Clock.schedulePeriodically((BComponent)this.getTrigger(), (BAbsTime)BIntervalTriggerMode.this.scheduledTime, (BRelTime)BIntervalTriggerMode.this.interval, (Action)BTimeTrigger.checkTime, null);
            }
        }

        public void stop() {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
        }

        public boolean isTriggerTime(BAbsTime bAbsTime) {
            BAbsTime bAbsTime2 = this.getTrigger().getNextTrigger();
            boolean bl = bAbsTime.isBefore(bAbsTime2) ^ true;
            if (bl) {
                BIntervalTriggerMode.this.scheduledTime = this.getNextTriggerTime(bAbsTime, bAbsTime2);
                return true;
            }
            if (this.ticket != null) {
                BIntervalTriggerMode.this.scheduledTime = bAbsTime2;
                this.ticket.cancel();
                this.ticket = Clock.schedulePeriodically((BComponent)this.getTrigger(), (BAbsTime)bAbsTime2, (BRelTime)BIntervalTriggerMode.this.getInterval(), (Action)BTimeTrigger.checkTime, null);
            }
            return false;
        }

        BAbsTime getScheduledTriggerTime() {
            return BIntervalTriggerMode.this.scheduledTime;
        }

        public BAbsTime getNextTriggerTime(BAbsTime bAbsTime, BAbsTime bAbsTime2) {
            BRelTime bRelTime;
            BDaysOfWeekBits bDaysOfWeekBits = BIntervalTriggerMode.this.getDaysOfWeek();
            if (bDaysOfWeekBits.isEmpty()) {
                return BAbsTime.END_OF_TIME;
            }
            if (bAbsTime2.isAfter(bAbsTime)) {
                bAbsTime2 = BAbsTime.NULL;
            }
            if ((bRelTime = BIntervalTriggerMode.this.getInterval()).getMillis() <= 0L) {
                return BAbsTime.END_OF_TIME;
            }
            if (!BIntervalTriggerMode.this.isRangeEnabled()) {
                BAbsTime bAbsTime3 = null;
                if (bAbsTime2.isNull()) {
                    bAbsTime3 = bAbsTime.add(BRelTime.make((long)((long)((double)bRelTime.getMillis() * rand.nextDouble()))));
                } else {
                    BRelTime bRelTime2 = bAbsTime.delta(bAbsTime2).abs();
                    if (bRelTime2.getMillis() > bRelTime.getMillis() * (long)3) {
                        bAbsTime3 = bAbsTime.add(BRelTime.make((long)((long)((double)bRelTime.getMillis() * rand.nextDouble()))));
                    } else {
                        bAbsTime3 = bAbsTime2.add(bRelTime);
                        while (bAbsTime3.isBefore(bAbsTime)) {
                            bAbsTime3 = bAbsTime3.add(bRelTime);
                        }
                    }
                }
                while (!bDaysOfWeekBits.includes(bAbsTime3)) {
                    bAbsTime3 = bAbsTime3.add(bRelTime);
                }
                return bAbsTime3;
            }
            BTime bTime = BIntervalTriggerMode.this.getStartTime();
            BTime bTime2 = BIntervalTriggerMode.this.getEndTime();
            if (bTime2.isBefore(bTime)) {
                return BAbsTime.END_OF_TIME;
            }
            BAbsTime bAbsTime4 = BAbsTime.make((BAbsTime)bAbsTime, (BTime)bTime);
            if (BTime.make((BAbsTime)bAbsTime).isAfter(bTime2)) {
                bAbsTime4 = bAbsTime4.nextDay();
            }
            if (!bDaysOfWeekBits.includes(bAbsTime4)) {
                while (!bDaysOfWeekBits.includes(bAbsTime4)) {
                    bAbsTime4 = bAbsTime4.nextDay();
                }
            }
            while (bAbsTime4.isBefore(bAbsTime)) {
                bAbsTime4 = bAbsTime4.add(bRelTime);
            }
            return bAbsTime4;
        }

        public IntervalTriggerScheduler(BTimeTrigger bTimeTrigger) {
            super(bTimeTrigger);
        }
    }
}

