/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.sql;

import com.tridium.rdb.BResultSetTable;
import com.tridium.rdb.RdbmsUtil;
import java.sql.Connection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsSession;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.sql.SqlQuery;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSqlScheme
extends BOrdScheme {
    public static final BSqlScheme INSTANCE = new BSqlScheme();
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$sql$BSqlScheme == null ? (class$javax$baja$rdb$sql$BSqlScheme = BSqlScheme.class$("javax.baja.rdb.sql.BSqlScheme")) : class$javax$baja$rdb$sql$BSqlScheme));
    static /* synthetic */ Class class$javax$baja$rdb$sql$BSqlScheme;

    public BSqlScheme() {
        super("sql");
    }

    public OrdQuery parse(String queryBody) {
        return new SqlQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        Connection connection = null;
        try {
            ConnectionAndContext cc = this.obtainConnectionAndContext(base);
            connection = cc.connection;
            RdbmsContext cx = cc.context;
            String body = ((SqlQuery)query).getBody();
            RdbmsUtil.checkSqlBody(body);
            OrdTarget ordTarget = new OrdTarget(base, (BObject)new BResultSetTable(connection, body, cx));
            return ordTarget;
        }
        catch (Exception e) {
            throw new UnresolvedException("Could not resolve " + base + ", " + query, (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private ConnectionAndContext obtainConnectionAndContext(OrdTarget base) throws Exception {
        BObject baseObject = base.get();
        if (baseObject instanceof BRdbms) {
            BRdbms db = (BRdbms)baseObject;
            BPermissions perm = db.getPermissions((Context)base);
            db.lease();
            if (!db.getSqlSchemeEnabled()) {
                throw new BajaRuntimeException("The 'sql' scheme is not enabled.");
            }
            BPermissions permissions = db.getPermissions((Context)base);
            if (!permissions.hasAdminWrite() || !permissions.hasAdminInvoke()) {
                throw new PermissionException();
            }
            return new ConnectionAndContext(db.getConnection(db.getUserName(), db.getPassword()), db.getRdbmsContext());
        }
        BRdbmsSession session = (BRdbmsSession)BOrd.toSession((BObject)baseObject);
        session.connect();
        session.getDatabase().lease();
        return new ConnectionAndContext(session.getConnection(), session.getDatabase().getRdbmsContext());
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConnectionAndContext {
        Connection connection;
        RdbmsContext context;

        ConnectionAndContext(Connection connection, RdbmsContext context) {
            this.connection = connection;
            this.context = context;
        }
    }
}

