/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.point;

import com.tridium.rdb.BResultSetTable;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.rdb.point.BRdbmsPointDeviceExt;
import javax.baja.rdb.point.BRdbmsPointQuery;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFilter;

public class BRdbmsProxyExt
extends BProxyExt {
    public static final Property valueColumn = BRdbmsProxyExt.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    public static final Property keyValue1 = BRdbmsProxyExt.newProperty((int)0, (String)"", null);
    public static final Property keyValue2 = BRdbmsProxyExt.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$point$BRdbmsProxyExt == null ? (class$javax$baja$rdb$point$BRdbmsProxyExt = BRdbmsProxyExt.class$("javax.baja.rdb.point.BRdbmsProxyExt")) : class$javax$baja$rdb$point$BRdbmsProxyExt));
    static /* synthetic */ Class class$javax$baja$rdb$point$BRdbmsProxyExt;

    public String getValueColumn() {
        return this.getString(valueColumn);
    }

    public void setValueColumn(String v) {
        this.setString(valueColumn, v, null);
    }

    public String getKeyValue1() {
        return this.getString(keyValue1);
    }

    public void setKeyValue1(String v) {
        this.setString(keyValue1, v, null);
    }

    public String getKeyValue2() {
        return this.getString(keyValue2);
    }

    public void setKeyValue2(String v) {
        this.setString(keyValue2, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BRdbmsPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    public void changed(Property prop, Context cx) {
        BRdbmsPointQuery query;
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if ((prop.equals(enabled) || prop.getName().startsWith("keyValue") || prop.equals(valueColumn)) && (query = this.getQuery()) != null) {
            query.invoke(BRdbmsPointQuery.execute, null, cx);
        }
    }

    public boolean write(Context cx) {
        return false;
    }

    private BRdbmsPointQuery getQuery() {
        BRdbmsProxyExt c = this;
        while (!c.getType().is(BRdbmsPointQuery.TYPE)) {
            if ((c = c.getParent()) != null) continue;
            return null;
        }
        return (BRdbmsPointQuery)((Object)c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(BResultSetTable table) {
        if (!this.getEnabled() || !this.isRunning()) {
            return;
        }
        if (this.getValueColumn() == null || this.getValueColumn().trim().length() == 0) {
            this.readFail("Value column must be set.");
            return;
        }
        Cursor cursor = null;
        try {
            cursor = table.filter(new IFilter(){

                public boolean accept(Object obj) {
                    BRdbmsPointQuery query = BRdbmsProxyExt.this.getQuery();
                    int i = 0;
                    while (true) {
                        block12: {
                            BString column;
                            if ((column = (BString)query.get("keyColumn" + (i + 1))) == null || column.equals((Object)BString.DEFAULT)) {
                                return true;
                            }
                            String name = column.toString().trim();
                            BValue dbValue = ((BComponent)obj).get(name);
                            String queryValue = ((BString)BRdbmsProxyExt.this.get("keyValue" + (i + 1))).toString();
                            if (dbValue == null) {
                                throw new BajaRuntimeException("No value returned by query for primary key " + name + ".");
                            }
                            try {
                                if (queryValue == null) {
                                    throw new BajaRuntimeException("No key value defined.");
                                }
                                if (dbValue.getType().is(BNumber.TYPE)) {
                                    if (((BNumber)dbValue).getDouble() != Double.parseDouble(queryValue)) {
                                        return false;
                                    }
                                    break block12;
                                }
                                if (dbValue.getType().is(BBoolean.TYPE)) {
                                    if (((BBoolean)dbValue).getBoolean() ? !queryValue.equals("1") && !queryValue.equalsIgnoreCase("true") : !queryValue.equals("0") && !queryValue.equalsIgnoreCase("false")) {
                                        return false;
                                    }
                                    break block12;
                                }
                                if (dbValue.getType().is(BString.TYPE)) {
                                    if (!((BString)dbValue).getString().trim().equals(queryValue.trim())) {
                                        return false;
                                    }
                                    break block12;
                                }
                                throw new BajaRuntimeException("Unexpected data type: " + dbValue.getType() + " on " + BRdbmsProxyExt.this.toString(null));
                            }
                            catch (Exception e) {
                                throw new BajaRuntimeException("Invalid value for KeyValue" + (i + 1) + " on " + BRdbmsProxyExt.this.toString(null), (Throwable)e);
                            }
                        }
                        ++i;
                    }
                }
            }).cursor();
        }
        catch (Exception e) {
            this.getQuery().getLog().error(e.getMessage(), (Throwable)e);
            this.readFail(e.getMessage());
            return;
        }
        if (cursor.next()) {
            BComponent row = (BComponent)cursor.get();
            BValue value = row.get(this.getValueColumn());
            try {
                try {
                    if (this.getParentPoint().getType().is(BEnumPoint.TYPE)) {
                        if (value.getType().is(BNumber.TYPE)) {
                            this.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)((BNumber)value).getInt())));
                        } else {
                            if (!value.getType().is(BBoolean.TYPE)) throw new BajaRuntimeException(this.toString(null) + " is type " + this.getParentPoint().getType() + " but value is " + value.getType());
                            this.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)((BBoolean)value).getOrdinal())));
                        }
                    } else if (this.getParentPoint().getType().is(BBooleanPoint.TYPE)) {
                        this.readOk((BStatusValue)new BStatusBoolean(((BBoolean)value).getBoolean()));
                    } else if (this.getParentPoint().getType().is(BNumericPoint.TYPE)) {
                        this.readOk((BStatusValue)new BStatusNumeric(((BNumber)value).getDouble()));
                    } else if (this.getParentPoint().getType().is(BStringPoint.TYPE)) {
                        this.readOk((BStatusValue)new BStatusString(value.toString().trim()));
                    }
                }
                catch (NumberFormatException e) {
                    throw new BajaRuntimeException(this.toString(null) + " is type " + this.getParentPoint().getType() + " but value is " + value.getType(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new BajaRuntimeException(this.toString(null) + " is type " + this.getParentPoint().getType() + " but value is " + value.getType(), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.getQuery().getLog().error(e.getMessage(), (Throwable)e);
                this.readFail(e.getMessage());
            }
            if (!cursor.next()) return;
            this.getQuery().getLog().warning("Key columns not specific enough, multiple matches for " + this.toString(null) + ".");
            return;
        }
        this.readFail("No value found.");
        this.getQuery().getLog().warning("Key columns do not match any value for " + this.toString(null) + ".");
    }

    public void subscribed() {
        super.subscribed();
        this.readSubscribed(null);
    }

    public void unsubscribed() {
        super.unsubscribed();
        this.readUnsubscribed(null);
    }

    public void readSubscribed(Context cx) {
        BRdbmsPointQuery query = this.getQuery();
        if (query != null) {
            query.addToPollGroup(this);
        }
    }

    public void readUnsubscribed(Context cx) {
        BRdbmsPointQuery query = this.getQuery();
        if (query != null) {
            query.removeFromPollGroup(this);
        }
    }

    public String toString(Context cx) {
        StringBuffer string = new StringBuffer();
        string.append(this.getQuery().getName()).append(".").append(this.getParentPoint().getDisplayName(cx));
        return string.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

